/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.freewheelclutch;

import com.hlysine.create_connected.CCBlocks;
import com.hlysine.create_connected.content.ClutchValueBox;
import com.hlysine.create_connected.content.freewheelclutch.FreewheelClutchBlock;
import com.simibubi.create.content.contraptions.bearing.WindmillBearingBlockEntity;
import com.simibubi.create.content.kinetics.RotationPropagator;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.transmission.SplitShaftBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.ticks.TickPriority;

public class FreewheelClutchBlockEntity
extends SplitShaftBlockEntity {
    protected ScrollOptionBehaviour<WindmillBearingBlockEntity.RotationDirection> movementDirection;
    public boolean reattachNextTick = false;

    public FreewheelClutchBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.movementDirection = new ScrollOptionBehaviour(WindmillBearingBlockEntity.RotationDirection.class, (Component)CreateLang.translateDirect((String)"contraptions.windmill.rotation_direction", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new ClutchValueBox());
        this.movementDirection.withCallback(i -> this.onKineticUpdate());
        behaviours.add((BlockEntityBehaviour)this.movementDirection);
    }

    public void initialize() {
        this.onKineticUpdate();
        super.initialize();
    }

    private void onKineticUpdate() {
        boolean correctDirection;
        boolean coupled = (Boolean)this.getBlockState().getValue((Property)FreewheelClutchBlock.UNCOUPLED) == false;
        boolean bl = correctDirection = Mth.sign((double)this.getSpeed()) == this.movementDirection.getValue() * 2 - 1;
        if (coupled != correctDirection && !this.isOverStressed() && this.level != null) {
            this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().cycle((Property)FreewheelClutchBlock.UNCOUPLED));
            this.level.scheduleTick(this.getBlockPos(), (Block)CCBlocks.FREEWHEEL_CLUTCH.get(), 0, TickPriority.EXTREMELY_HIGH);
            this.reattachNextTick = true;
        }
    }

    public void updateFromNetwork(float maxStress, float currentStress, int networkSize) {
        super.updateFromNetwork(maxStress, currentStress, networkSize);
        this.onKineticUpdate();
    }

    public void onSpeedChanged(float previousSpeed) {
        this.onKineticUpdate();
        super.onSpeedChanged(previousSpeed);
    }

    public void tick() {
        super.tick();
        if (this.reattachNextTick && this.level != null) {
            this.reattachNextTick = false;
            RotationPropagator.handleAdded((Level)this.level, (BlockPos)this.getBlockPos(), (KineticBlockEntity)this);
        }
    }

    public float getRotationSpeedModifier(Direction face) {
        if (face == this.getBlockState().getValue((Property)BlockStateProperties.FACING) && ((Boolean)this.getBlockState().getValue((Property)FreewheelClutchBlock.UNCOUPLED)).booleanValue()) {
            return 0.0f;
        }
        return 1.0f;
    }
}

