/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.mixin.copycat.panel;

import com.copycatsplus.copycats.foundation.copycat.CopycatExternalContext;
import com.copycatsplus.copycats.foundation.copycat.ICopycatBlock;
import com.simibubi.create.content.decoration.copycat.CopycatBlockEntity;
import com.simibubi.create.content.decoration.copycat.CopycatPanelBlock;
import com.simibubi.create.content.decoration.copycat.WaterloggedCopycatBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CopycatPanelBlock.class}, remap=false)
public abstract class CopycatPanelBlockMixin
extends WaterloggedCopycatBlock
implements ICopycatBlock {
    public CopycatPanelBlockMixin(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public BlockState getAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, @Nullable BlockState queryState, @Nullable BlockPos queryPos) {
        if (!this.isCTEnabled(state, level, queryPos)) {
            return state;
        }
        return super.getAppearance(state, level, pos, side, queryState, queryPos);
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return this.toggleCT(state, level, pos, player, hitResult);
    }

    @Override
    @Unique
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Unique
    @Nullable
    public CopycatBlockEntity getBlockEntity(BlockGetter worldIn, BlockPos pos) {
        return (CopycatBlockEntity)super.getBlockEntity(worldIn, pos);
    }

    @Inject(method={"isIgnoredConnectivitySide"}, at={@At(value="RETURN")}, cancellable=true)
    private void isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState state, Direction face, BlockPos fromPos, BlockPos toPos, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)cir.getReturnValue()).booleanValue()) {
            return;
        }
        if (CopycatExternalContext.isForBlockingLogic()) {
            cir.setReturnValue((Object)false);
            return;
        }
        if (toPos == null) {
            cir.setReturnValue((Object)true);
            return;
        }
        cir.setReturnValue((Object)(!this.checkConnection(reader, toPos, fromPos, reader.getBlockState(toPos)) ? 1 : 0));
    }

    @Inject(method={"canConnectTexturesToward"}, at={@At(value="RETURN")}, cancellable=true)
    private void canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState fromState, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue()) {
            return;
        }
        BlockState toState = reader.getBlockState(toPos);
        if (toState.getBlock() instanceof ICopycatBlock) {
            cir.setReturnValue((Object)true);
            return;
        }
        cir.setReturnValue((Object)this.checkConnection(reader, fromPos, toPos, fromState));
    }

    @Override
    @Unique
    @NotNull
    public BlockState mirror(@NotNull BlockState pState, @NotNull Mirror pMirror) {
        return super.mirror(pState, pMirror);
    }

    @Override
    @Unique
    @NotNull
    public BlockState rotate(@NotNull BlockState pState, Rotation pRot) {
        return super.rotate(pState, pRot);
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    @Override
    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        return ICopycatBlock.hidesNeighborFace(level, pos, state, neighborState, dir);
    }
}

