/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base.profiles;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import pro.gravit.launcher.DaRklAuNcheRcw;
import pro.gravit.launcher.base.profiles.ClientProfile$ClassLoaderConfig;
import pro.gravit.launcher.base.profiles.ClientProfile$CompatibilityFlags;
import pro.gravit.launcher.base.profiles.ClientProfile$ProfileDefaultSettings;
import pro.gravit.launcher.base.profiles.ClientProfile$ServerProfile;
import pro.gravit.launcher.base.profiles.ClientProfile$Version;
import pro.gravit.launcher.base.profiles.ClientProfileVersions;
import pro.gravit.launcher.base.profiles.optional.OptionalDepend;
import pro.gravit.launcher.base.profiles.optional.OptionalFile;
import pro.gravit.launcher.base.profiles.optional.triggers.OptionalTrigger;
import pro.gravit.launcher.daRklAuNCHeRCk;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.VerifyHelper;
import pro.gravit.utils.launch.LaunchOptions$ModuleConf;

public final class ClientProfile
implements Comparable<ClientProfile> {
    private static final DaRklAuNcheRcw ASSET_MATCHER = new DaRklAuNcheRcw(new String[0], new String[]{"indexes", "objects"}, new String[0]);
    @daRklAuNCHeRCk
    private String title;
    @daRklAuNCHeRCk
    private UUID uuid;
    @daRklAuNCHeRCk
    private ClientProfile$Version version;
    @daRklAuNCHeRCk
    private String info;
    @daRklAuNCHeRCk
    private String dir;
    @daRklAuNCHeRCk
    private int sortIndex;
    @daRklAuNCHeRCk
    private String assetIndex;
    @daRklAuNCHeRCk
    private String assetDir;
    @daRklAuNCHeRCk
    private List<String> update;
    @daRklAuNCHeRCk
    private List<String> updateExclusions;
    @daRklAuNCHeRCk
    private List<String> updateVerify;
    @daRklAuNCHeRCk
    private Set<OptionalFile> updateOptional;
    @daRklAuNCHeRCk
    private List<String> jvmArgs;
    @daRklAuNCHeRCk
    private List<String> classPath;
    @daRklAuNCHeRCk
    private List<String> altClassPath;
    @daRklAuNCHeRCk
    private List<String> clientArgs;
    @daRklAuNCHeRCk
    private List<String> compatClasses;
    @daRklAuNCHeRCk
    private List<String> loadNatives;
    @daRklAuNCHeRCk
    private Map<String, String> properties;
    @daRklAuNCHeRCk
    private List<ClientProfile$ServerProfile> servers;
    @daRklAuNCHeRCk
    private ClientProfile$ClassLoaderConfig classLoaderConfig;
    @daRklAuNCHeRCk
    private List<ClientProfile$CompatibilityFlags> flags;
    @daRklAuNCHeRCk
    private int recommendJavaVersion = 8;
    @daRklAuNCHeRCk
    private int minJavaVersion = 8;
    @daRklAuNCHeRCk
    private int maxJavaVersion = 999;
    @daRklAuNCHeRCk
    private ClientProfile$ProfileDefaultSettings settings = new ClientProfile$ProfileDefaultSettings();
    @daRklAuNCHeRCk
    private boolean limited;
    @daRklAuNCHeRCk
    private String mainClass;
    @daRklAuNCHeRCk
    private String mainModule;
    @daRklAuNCHeRCk
    private LaunchOptions$ModuleConf moduleConf;

    public ClientProfile(String string, UUID uUID, ClientProfile$Version clientProfile$Version, String string2, String string3, int n, String string4, String string5, List<String> list, List<String> list2, List<String> list3, Set<OptionalFile> set, List<String> list4, List<String> list5, List<String> list6, List<String> list7, List<String> list8, List<String> list9, Map<String, String> map, List<ClientProfile$ServerProfile> list10, ClientProfile$ClassLoaderConfig clientProfile$ClassLoaderConfig, List<ClientProfile$CompatibilityFlags> list11, int n2, int n3, int n4, ClientProfile$ProfileDefaultSettings clientProfile$ProfileDefaultSettings, boolean bl, String string6, String string7, LaunchOptions$ModuleConf launchOptions$ModuleConf) {
        this.title = string;
        this.uuid = uUID;
        this.version = clientProfile$Version;
        this.info = string2;
        this.dir = string3;
        this.sortIndex = n;
        this.assetIndex = string4;
        this.assetDir = string5;
        this.update = list;
        this.updateExclusions = list2;
        this.updateVerify = list3;
        this.updateOptional = set;
        this.jvmArgs = list4;
        this.classPath = list5;
        this.altClassPath = list6;
        this.clientArgs = list7;
        this.compatClasses = list8;
        this.loadNatives = list9;
        this.properties = map;
        this.servers = list10;
        this.classLoaderConfig = clientProfile$ClassLoaderConfig;
        this.flags = list11;
        this.recommendJavaVersion = n2;
        this.minJavaVersion = n3;
        this.maxJavaVersion = n4;
        this.settings = clientProfile$ProfileDefaultSettings;
        this.limited = bl;
        this.mainClass = string6;
        this.mainModule = string7;
        this.moduleConf = launchOptions$ModuleConf;
    }

    public ClientProfile$ServerProfile getDefaultServerProfile() {
        for (ClientProfile$ServerProfile clientProfile$ServerProfile : this.servers) {
            if (!clientProfile$ServerProfile.isDefault) continue;
            return clientProfile$ServerProfile;
        }
        return null;
    }

    @Override
    public int compareTo(ClientProfile clientProfile) {
        return Integer.compare(this.getSortIndex(), clientProfile.getSortIndex());
    }

    public String getAssetIndex() {
        return this.assetIndex;
    }

    public DaRklAuNcheRcw getAssetUpdateMatcher() {
        return this.getVersion().compareTo(ClientProfileVersions.MINECRAFT_1_7_10) >= 0 ? ASSET_MATCHER : null;
    }

    public List<String> getClassPath() {
        return Collections.unmodifiableList(this.classPath);
    }

    public List<String> getAlternativeClassPath() {
        return Collections.unmodifiableList(this.altClassPath);
    }

    public List<String> getClientArgs() {
        return Collections.unmodifiableList(this.clientArgs);
    }

    public String getDir() {
        return this.dir;
    }

    public String getAssetDir() {
        return this.assetDir;
    }

    public List<String> getUpdateExclusions() {
        return Collections.unmodifiableList(this.updateExclusions);
    }

    public List<String> getUpdate() {
        return Collections.unmodifiableList(this.update);
    }

    public List<String> getUpdateVerify() {
        return Collections.unmodifiableList(this.updateVerify);
    }

    public DaRklAuNcheRcw getClientUpdateMatcher() {
        String[] stringArray = this.update.toArray(new String[0]);
        String[] stringArray2 = this.updateVerify.toArray(new String[0]);
        List<String> list = this.updateExclusions;
        String[] stringArray3 = list.toArray(new String[0]);
        return new DaRklAuNcheRcw(stringArray, stringArray2, stringArray3);
    }

    public List<String> getJvmArgs() {
        return Collections.unmodifiableList(this.jvmArgs);
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public String getMainModule() {
        return this.mainModule;
    }

    public LaunchOptions$ModuleConf getModuleConf() {
        return this.moduleConf;
    }

    public List<ClientProfile$ServerProfile> getServers() {
        return this.servers;
    }

    public String getServerAddress() {
        ClientProfile$ServerProfile clientProfile$ServerProfile = this.getDefaultServerProfile();
        return clientProfile$ServerProfile == null ? "localhost" : clientProfile$ServerProfile.serverAddress;
    }

    public Set<OptionalFile> getOptional() {
        return this.updateOptional;
    }

    public int getRecommendJavaVersion() {
        return this.recommendJavaVersion;
    }

    public int getMinJavaVersion() {
        return this.minJavaVersion;
    }

    public int getMaxJavaVersion() {
        return this.maxJavaVersion;
    }

    public ClientProfile$ProfileDefaultSettings getSettings() {
        return this.settings;
    }

    public List<String> getLoadNatives() {
        return this.loadNatives;
    }

    public void updateOptionalGraph() {
        for (OptionalFile optionalFile : this.updateOptional) {
            int n;
            if (optionalFile.dependenciesFile != null) {
                optionalFile.dependencies = new OptionalFile[optionalFile.dependenciesFile.length];
                for (n = 0; n < optionalFile.dependenciesFile.length; ++n) {
                    optionalFile.dependencies[n] = this.getOptionalFile(optionalFile.dependenciesFile[n].name);
                }
            }
            if (optionalFile.conflictFile != null) {
                optionalFile.conflict = new OptionalFile[optionalFile.conflictFile.length];
                for (n = 0; n < optionalFile.conflictFile.length; ++n) {
                    optionalFile.conflict[n] = this.getOptionalFile(optionalFile.conflictFile[n].name);
                }
            }
            if (optionalFile.groupFile == null) continue;
            optionalFile.group = new OptionalFile[optionalFile.groupFile.length];
            for (n = 0; n < optionalFile.groupFile.length; ++n) {
                optionalFile.group[n] = this.getOptionalFile(optionalFile.groupFile[n].name);
            }
        }
    }

    public OptionalFile getOptionalFile(String string) {
        for (OptionalFile optionalFile : this.updateOptional) {
            if (!optionalFile.name.equals(string)) continue;
            return optionalFile;
        }
        return null;
    }

    public int getServerPort() {
        ClientProfile$ServerProfile clientProfile$ServerProfile = this.getDefaultServerProfile();
        return clientProfile$ServerProfile == null ? 25565 : clientProfile$ServerProfile.serverPort;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public String getTitle() {
        return this.title;
    }

    public String getInfo() {
        return this.info;
    }

    public ClientProfile$Version getVersion() {
        return this.version;
    }

    @Deprecated
    public boolean isUpdateFastCheck() {
        return true;
    }

    public String toString() {
        return String.format("%s (%s)", this.title, this.uuid);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public boolean hasFlag(ClientProfile$CompatibilityFlags clientProfile$CompatibilityFlags) {
        return this.flags.contains((Object)clientProfile$CompatibilityFlags);
    }

    public void verify() {
        this.getVersion();
        IOHelper.verifyFileName(this.getAssetIndex());
        VerifyHelper.verify(this.getTitle(), VerifyHelper.NOT_EMPTY, "Profile title can't be empty");
        VerifyHelper.verify(this.getInfo(), VerifyHelper.NOT_EMPTY, "Profile info can't be empty");
        VerifyHelper.verify(this.getTitle(), VerifyHelper.NOT_EMPTY, "Main class can't be empty");
        if (this.getUUID() == null) {
            throw new IllegalArgumentException("Profile UUID can't be null");
        }
        for (String object : this.update) {
            if (object != null) continue;
            throw new IllegalArgumentException("Found null entry in update");
        }
        for (String string : this.updateVerify) {
            if (string != null) continue;
            throw new IllegalArgumentException("Found null entry in updateVerify");
        }
        for (String string : this.updateExclusions) {
            if (string != null) continue;
            throw new IllegalArgumentException("Found null entry in updateExclusions");
        }
        for (String string : this.classPath) {
            if (string != null) continue;
            throw new IllegalArgumentException("Found null entry in classPath");
        }
        for (String string : this.jvmArgs) {
            if (string != null) continue;
            throw new IllegalArgumentException("Found null entry in jvmArgs");
        }
        for (String string : this.clientArgs) {
            if (string != null) continue;
            throw new IllegalArgumentException("Found null entry in clientArgs");
        }
        for (String string : this.compatClasses) {
            if (string != null) continue;
            throw new IllegalArgumentException("Found null entry in compatClasses");
        }
        for (OptionalFile optionalFile : this.updateOptional) {
            if (optionalFile == null) {
                throw new IllegalArgumentException("Found null entry in updateOptional");
            }
            if (optionalFile.name == null) {
                throw new IllegalArgumentException("Optional: name must not be null");
            }
            if (optionalFile.conflictFile != null) {
                for (OptionalDepend optionalDepend : optionalFile.conflictFile) {
                    if (optionalDepend != null) continue;
                    throw new IllegalArgumentException(String.format("Found null entry in updateOptional.%s.conflictFile", optionalFile.name));
                }
            }
            if (optionalFile.dependenciesFile != null) {
                for (OptionalDepend optionalDepend : optionalFile.dependenciesFile) {
                    if (optionalDepend != null) continue;
                    throw new IllegalArgumentException(String.format("Found null entry in updateOptional.%s.dependenciesFile", optionalFile.name));
                }
            }
            if (optionalFile.groupFile != null) {
                for (OptionalDepend optionalDepend : optionalFile.groupFile) {
                    if (optionalDepend != null) continue;
                    throw new IllegalArgumentException(String.format("Found null entry in updateOptional.%s.groupFile", optionalFile.name));
                }
            }
            if (optionalFile.triggersList == null) continue;
            for (OptionalTrigger optionalTrigger : optionalFile.triggersList) {
                if (optionalTrigger != null) continue;
                throw new IllegalArgumentException(String.format("Found null entry in updateOptional.%s.triggers", optionalFile.name));
            }
        }
    }

    public String getProperty(String string) {
        return this.properties.get(string);
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public List<String> getCompatClasses() {
        return Collections.unmodifiableList(this.compatClasses);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ClientProfile clientProfile = (ClientProfile)object;
        return Objects.equals(this.uuid, clientProfile.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }

    public ClientProfile$ClassLoaderConfig getClassLoaderConfig() {
        return this.classLoaderConfig;
    }

    public boolean isLimited() {
        return this.limited;
    }

    public List<ClientProfile$CompatibilityFlags> getFlags() {
        return this.flags;
    }
}

