/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.util;

import com.b1n_ry.yigd.util.DropRule;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;

public class GraveOverrideAreas {
    public static GraveOverrideAreas INSTANCE = new GraveOverrideAreas();
    @SerializedName(value="default_drop_rule")
    public DropRule defaultDropRule = DropRule.PUT_IN_GRAVE;
    @SerializedName(value="values")
    public List<Area> values = new ArrayList<Area>();

    public DropRule getDropRuleFromArea(BlockPos pos, ServerLevel world) {
        ResourceLocation worldId = world.dimension().location();
        for (Area area : this.values) {
            if (!worldId.equals((Object)area.worldId)) continue;
            int minX = Math.min(area.from.getX(), area.to.getX());
            int minY = Math.min(area.from.getY(), area.to.getY());
            int minZ = Math.min(area.from.getZ(), area.to.getZ());
            int maxX = Math.max(area.from.getX(), area.to.getX());
            int maxY = Math.max(area.from.getY(), area.to.getY());
            int maxZ = Math.max(area.from.getZ(), area.to.getZ());
            int blockX = pos.getX();
            int blockY = pos.getY();
            int blockZ = pos.getZ();
            if (blockX < minX || maxX < blockX || (blockY < minY || maxY < blockY) && !area.yDependent || blockZ < minZ || maxZ < blockZ) continue;
            return area.areaDropRule;
        }
        return this.defaultDropRule;
    }

    public static class Area {
        @SerializedName(value="from")
        public Vec3i from;
        @SerializedName(value="to")
        public Vec3i to;
        @SerializedName(value="area_drop_rule")
        public DropRule areaDropRule;
        @SerializedName(value="y_dependent")
        public boolean yDependent = false;
        @SerializedName(value="world_id")
        public ResourceLocation worldId;
    }
}

