/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.components;

import com.b1n_ry.yigd.compat.CompatComponent;
import com.b1n_ry.yigd.compat.InvModCompat;
import com.b1n_ry.yigd.config.InventoryConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.DeathContext;
import com.b1n_ry.yigd.events.YigdEvents;
import com.b1n_ry.yigd.util.DropRule;
import com.b1n_ry.yigd.util.GraveOverrideAreas;
import com.b1n_ry.yigd.util.PairModificationConsumer;
import com.b1n_ry.yigd.util.YigdTags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class InventoryComponent {
    private final NonNullList<Tuple<ItemStack, DropRule>> items = NonNullList.create();
    private final Map<String, CompatComponent<?>> modInventoryItems;
    public final int mainSize;
    public final int armorSize;
    public final int offHandSize;
    private static final Random RANDOM = new Random();
    public static final Tuple<ItemStack, DropRule> EMPTY_ITEM_PAIR = new Tuple((Object)ItemStack.EMPTY, (Object)GraveOverrideAreas.INSTANCE.defaultDropRule);

    public InventoryComponent(ServerPlayer player) {
        for (ItemStack stack : this.getInventoryItems(player)) {
            this.items.add((Object)new Tuple((Object)stack, (Object)DropRule.PUT_IN_GRAVE));
        }
        this.modInventoryItems = this.getModInventoryItems(player);
        Inventory inventory = player.getInventory();
        this.mainSize = inventory.items.size();
        this.armorSize = inventory.armor.size();
        this.offHandSize = inventory.offhand.size();
    }

    private InventoryComponent(NonNullList<Tuple<ItemStack, DropRule>> items, Map<String, CompatComponent<?>> modInventoryItems, int mainSize, int armorSize, int offHandSize) {
        this.items.addAll(items);
        this.modInventoryItems = modInventoryItems;
        this.mainSize = mainSize;
        this.armorSize = armorSize;
        this.offHandSize = offHandSize;
    }

    public NonNullList<Tuple<ItemStack, DropRule>> getItems() {
        return this.items;
    }

    public NonNullList<ItemStack> getAllExtraItems(boolean withoutEmpty) {
        NonNullList stacks = NonNullList.create();
        for (CompatComponent<?> compatComponent : this.modInventoryItems.values()) {
            for (Tuple pair : compatComponent.getAsStackDropList()) {
                ItemStack stack = (ItemStack)pair.getA();
                if (withoutEmpty && stack.isEmpty()) continue;
                stacks.add((Object)stack);
            }
        }
        return stacks;
    }

    public boolean removeItem(Predicate<ItemStack> predicate, int itemCount) {
        predicate = predicate.and(stack -> stack.getCount() >= itemCount);
        for (Tuple pair : this.items) {
            ItemStack stack2 = (ItemStack)pair.getA();
            if (!predicate.test(stack2)) continue;
            stack2.shrink(itemCount);
            return true;
        }
        for (CompatComponent<?> compatComponent : this.modInventoryItems.values()) {
            if (!compatComponent.removeItem(predicate, itemCount)) continue;
            return true;
        }
        return false;
    }

    private NonNullList<ItemStack> getInventoryItems(ServerPlayer player) {
        Inventory inventory = player.getInventory();
        NonNullList items = NonNullList.withSize((int)inventory.getContainerSize(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            items.set(i, (Object)inventory.getItem(i));
        }
        return items;
    }

    private Map<String, CompatComponent<?>> getModInventoryItems(ServerPlayer player) {
        HashMap modInventories = new HashMap();
        for (InvModCompat<?> compatMod : InvModCompat.invCompatMods) {
            modInventories.put(compatMod.getModName(), compatMod.getNewComponent(player));
        }
        return modInventories;
    }

    public void onDeath(DeathContext context) {
        YigdConfig config = YigdConfig.getConfig();
        if (config.inventoryConfig.dropPlayerHead) {
            ItemStack playerHead = new ItemStack((ItemLike)Items.PLAYER_HEAD);
            playerHead.set(DataComponents.PROFILE, (Object)new ResolvableProfile(context.player().getGameProfile()));
            this.items.add((Object)new Tuple((Object)playerHead, (Object)GraveOverrideAreas.INSTANCE.defaultDropRule));
        }
        this.handleDropRules(context);
        InventoryComponent dropInventory = this.filteredInv(dropRule -> dropRule == DropRule.DROP);
        dropInventory.dropAll(context.world(), context.deathPos());
    }

    private void handleDropRules(DeathContext context) {
        for (int i = 0; i < this.items.size(); ++i) {
            Tuple pair = (Tuple)this.items.get(i);
            ItemStack item = (ItemStack)pair.getA();
            if (item.isEmpty()) continue;
            YigdEvents.DropRuleEvent event = (YigdEvents.DropRuleEvent)NeoForge.EVENT_BUS.post((Event)new YigdEvents.DropRuleEvent(item, i, context, true));
            DropRule dropRule = event.getDropRule();
            pair.setB((Object)dropRule);
        }
        for (InvModCompat<?> compatMod : InvModCompat.invCompatMods) {
            String modName = compatMod.getModName();
            CompatComponent<?> compatComponent = this.modInventoryItems.get(modName);
            compatComponent.handleDropRules(context);
        }
        NeoForge.EVENT_BUS.post((Event)new YigdEvents.AdjustDropRuleEvent(this, context));
    }

    public void applyLoss() {
        int to;
        int from;
        YigdConfig config = YigdConfig.getConfig();
        InventoryConfig.ItemLossConfig itemLoss = config.inventoryConfig.itemLoss;
        if (itemLoss.usePercentRange) {
            NonNullList vanillaStacks = NonNullList.create();
            for (Tuple pair : this.items) {
                if (((ItemStack)pair.getA()).isEmpty() || pair.getB() == DropRule.DESTROY) continue;
                vanillaStacks.add((Object)((ItemStack)pair.getA()));
            }
            int itemCount = vanillaStacks.size();
            if (!itemLoss.affectStacks) {
                itemCount = 0;
                for (ItemStack stack : vanillaStacks) {
                    itemCount += stack.getCount();
                }
            }
            from = (int)((float)(itemCount * itemLoss.lossRangeFrom) / 100.0f);
            to = (int)((float)(itemCount * itemLoss.lossRangeTo) / 100.0f);
        } else {
            from = itemLoss.lossRangeFrom;
            to = itemLoss.lossRangeTo;
        }
        int amount = from < to ? new Random().nextInt(from, to + 1) : from;
        for (int i = 0; i < amount; ++i) {
            if (Math.random() > (double)itemLoss.percentChanceOfLoss / 100.0) continue;
            this.loseRandomItem();
        }
    }

    private void loseRandomItem() {
        YigdConfig config = YigdConfig.getConfig();
        InventoryConfig.ItemLossConfig itemLoss = config.inventoryConfig.itemLoss;
        ArrayList<Integer> itemSlots = new ArrayList<Integer>();
        int vanillaLimit = this.items.size();
        for (int i = 0; i < vanillaLimit; ++i) {
            Tuple pair2 = (Tuple)this.items.get(i);
            ItemStack itemStack = (ItemStack)pair2.getA();
            if (itemStack.isEmpty() || pair2.getB() == DropRule.KEEP && !itemLoss.canLoseSoulbound || itemStack.is(YigdTags.LOSS_IMMUNE)) continue;
            itemSlots.add(i);
        }
        NonNullList extraItems = NonNullList.create();
        if (itemLoss.includeModdedInventories) {
            for (CompatComponent compatComponent : this.modInventoryItems.values()) {
                for (Tuple tuple : compatComponent.getAsStackDropList()) {
                    if (((ItemStack)tuple.getA()).isEmpty()) continue;
                    extraItems.add((Object)((ItemStack)tuple.getA()));
                }
            }
            for (int i = 0; i < extraItems.size(); ++i) {
                itemSlots.add(vanillaLimit + i);
            }
        }
        if (itemSlots.isEmpty()) {
            return;
        }
        int random = RANDOM.nextInt(itemSlots.size());
        int n = (Integer)itemSlots.get(random);
        if (itemLoss.affectStacks) {
            if (n >= vanillaLimit) {
                ItemStack toBeRemoved = (ItemStack)extraItems.get(n - vanillaLimit);
                this.handleItemPairs(s -> !s.equals("vanilla"), (stack, s, pair) -> {
                    if (stack.equals(toBeRemoved)) {
                        pair.setB((Object)DropRule.DESTROY);
                    }
                });
            } else {
                ((Tuple)this.items.get(n)).setB((Object)DropRule.DESTROY);
            }
        } else {
            ItemStack stack2 = n >= vanillaLimit ? (ItemStack)extraItems.get(n - vanillaLimit) : (ItemStack)((Tuple)this.items.get(n)).getA();
            stack2.shrink(1);
        }
        ItemStack decreased = (ItemStack)((Tuple)this.items.get(n)).getA();
        if (decreased.isEmpty() || decreased.getCount() == 0) {
            itemSlots.remove((Object)n);
        }
    }

    public void dropAll(ServerLevel world, Vec3 pos) {
        for (Tuple pair : this.items) {
            ItemStack stack = (ItemStack)pair.getA();
            if (stack.isEmpty()) continue;
            InventoryComponent.dropItemIfToBeDropped(stack, pos.x, pos.y, pos.z, world);
        }
        for (CompatComponent<?> compatComponent : this.modInventoryItems.values()) {
            compatComponent.dropItems(world, pos);
        }
    }

    public void dropGraveItems(ServerLevel world, Vec3 pos) {
        for (Tuple pair : this.items) {
            ItemStack stack = (ItemStack)pair.getA();
            if (stack.isEmpty() || pair.getB() != DropRule.PUT_IN_GRAVE) continue;
            pair.setB((Object)DropRule.DROP);
            InventoryComponent.dropItemIfToBeDropped(stack, pos.x, pos.y, pos.z, world);
        }
        for (CompatComponent<?> compatComponent : this.modInventoryItems.values()) {
            compatComponent.dropGraveItems(world, pos);
        }
    }

    public NonNullList<ItemStack> merge(InventoryComponent mergingComponent, ServerPlayer merger) {
        YigdConfig config = YigdConfig.getConfig();
        NonNullList extraItems = NonNullList.create();
        for (int i = 0; i < mergingComponent.items.size(); ++i) {
            int combinationSlot;
            int currentComponentIndex;
            if (i < mergingComponent.mainSize) {
                groupIndex = i;
                currentComponentIndex = groupIndex < this.mainSize ? groupIndex : 0;
            } else if (i < mergingComponent.mainSize + mergingComponent.armorSize) {
                groupIndex = i - mergingComponent.mainSize;
                currentComponentIndex = groupIndex < this.armorSize ? groupIndex + this.mainSize : this.mainSize;
            } else if (i < mergingComponent.mainSize + mergingComponent.armorSize + mergingComponent.offHandSize) {
                groupIndex = i - (mergingComponent.mainSize + mergingComponent.armorSize);
                currentComponentIndex = groupIndex < this.offHandSize ? groupIndex + this.mainSize + this.armorSize : this.mainSize + this.armorSize;
            } else {
                groupIndex = i - (mergingComponent.mainSize + mergingComponent.armorSize + mergingComponent.offHandSize);
                currentComponentIndex = groupIndex + this.mainSize + this.armorSize + this.offHandSize;
            }
            ItemStack mergingStack = ((ItemStack)((Tuple)mergingComponent.items.get(i)).getA()).copy();
            if (currentComponentIndex > this.items.size()) {
                extraItems.add((Object)mergingStack);
                continue;
            }
            Iterator currentStack = (ItemStack)((Tuple)this.items.get(currentComponentIndex)).getA();
            if (config.graveConfig.treatBindingCurse && i >= mergingComponent.mainSize && i < mergingComponent.mainSize + mergingComponent.armorSize && EnchantmentHelper.has((ItemStack)mergingStack, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE)) {
                if (!currentStack.isEmpty()) {
                    extraItems.add((Object)currentStack);
                }
                this.items.set(currentComponentIndex, EMPTY_ITEM_PAIR);
                currentStack = (ItemStack)((Tuple)this.items.get(currentComponentIndex)).getA();
            }
            if (config.graveConfig.mergeStacksOnRetrieve && (combinationSlot = this.findMatchingStackSlot(mergingStack)) != -1) {
                this.mergeItemInSlot(mergingStack, combinationSlot);
            }
            if (mergingStack.isEmpty()) continue;
            if (currentStack.isEmpty()) {
                this.items.set(currentComponentIndex, (Object)new Tuple((Object)mergingStack, (Object)DropRule.PUT_IN_GRAVE));
                continue;
            }
            extraItems.add((Object)mergingStack);
        }
        for (InvModCompat<?> modCompat : InvModCompat.invCompatMods) {
            String modName = modCompat.getModName();
            if (!mergingComponent.modInventoryItems.containsKey(modName)) continue;
            CompatComponent<?> mergingCompatComponent = mergingComponent.modInventoryItems.get(modName);
            if (!this.modInventoryItems.containsKey(modName)) {
                for (Tuple pair : mergingCompatComponent.getAsStackDropList()) {
                    ItemStack item = (ItemStack)pair.getA();
                    if (item.isEmpty()) continue;
                    extraItems.add((Object)item);
                }
                continue;
            }
            CompatComponent<?> compatComponent = this.modInventoryItems.get(modName);
            NonNullList<ItemStack> extraModItems = compatComponent.merge(mergingCompatComponent, merger);
            extraItems.addAll(extraModItems);
        }
        this.addStacksToMain((NonNullList<ItemStack>)extraItems);
        return extraItems;
    }

    private int findMatchingStackSlot(ItemStack stack) {
        for (int i = 0; i < this.mainSize; ++i) {
            ItemStack iStack = (ItemStack)((Tuple)this.items.get(i)).getA();
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)iStack) || !iStack.isStackable() || iStack.getMaxStackSize() <= iStack.getCount()) continue;
            return i;
        }
        return -1;
    }

    private void mergeItemInSlot(ItemStack toMerge, int slot) {
        ItemStack mergeTo = (ItemStack)((Tuple)this.items.get(slot)).getA();
        int remaining = mergeTo.getMaxStackSize() - mergeTo.getCount();
        int ableToAdd = Math.min(toMerge.getCount(), remaining);
        mergeTo.grow(ableToAdd);
        toMerge.shrink(ableToAdd);
    }

    public NonNullList<ItemStack> pullBindingCurseItems(ServerPlayer playerRef) {
        NonNullList bindingItems = NonNullList.create();
        for (int i = 0; i < this.armorSize; ++i) {
            ItemStack armorStack = (ItemStack)((Tuple)this.items.get(this.mainSize + i)).getA();
            if (!EnchantmentHelper.has((ItemStack)armorStack, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE)) continue;
            bindingItems.add((Object)armorStack);
            this.items.set(this.mainSize + i, EMPTY_ITEM_PAIR);
        }
        for (CompatComponent<?> compatComponent : this.modInventoryItems.values()) {
            bindingItems.addAll(compatComponent.pullBindingCurseItems(playerRef));
        }
        return bindingItems;
    }

    private void addStacksToMain(NonNullList<ItemStack> extraItems) {
        YigdConfig config = YigdConfig.getConfig();
        while (!extraItems.isEmpty()) {
            ItemStack stack = (ItemStack)extraItems.getFirst();
            int addToSlot = -1;
            if (config.graveConfig.mergeStacksOnRetrieve) {
                addToSlot = this.findMatchingStackSlot(stack);
            }
            if (addToSlot == -1 && (addToSlot = this.findEmptySlot()) == -1) {
                return;
            }
            ItemStack addToStack = (ItemStack)((Tuple)this.items.get(addToSlot)).getA();
            if (addToStack.isEmpty()) {
                this.items.set(addToSlot, (Object)new Tuple((Object)stack, (Object)GraveOverrideAreas.INSTANCE.defaultDropRule));
                extraItems.removeFirst();
                continue;
            }
            this.mergeItemInSlot(stack, addToSlot);
            if (!stack.isEmpty()) continue;
            extraItems.removeFirst();
        }
    }

    private int findEmptySlot() {
        for (int i = 0; i < this.mainSize; ++i) {
            if (!((ItemStack)((Tuple)this.items.get(i)).getA()).isEmpty()) continue;
            return i;
        }
        return -1;
    }

    public boolean containsAny(Predicate<ItemStack> itemPredicate, Predicate<String> modPredicate, Predicate<Integer> slotPredicate) {
        if (modPredicate.test("vanilla")) {
            for (int i = 0; i < this.items.size(); ++i) {
                Tuple pair = (Tuple)this.items.get(i);
                if (!slotPredicate.test(i) || !itemPredicate.test((ItemStack)pair.getA())) continue;
                return true;
            }
        }
        for (Map.Entry<String, CompatComponent<?>> entry : this.modInventoryItems.entrySet()) {
            CompatComponent<?> compatComponent = entry.getValue();
            if (!modPredicate.test(entry.getKey()) || !compatComponent.containsAny(itemPredicate)) continue;
            return true;
        }
        return false;
    }

    public void handleItemPairs(Predicate<String> modPredicate, PairModificationConsumer modification) {
        if (modPredicate.test("vanilla")) {
            for (int i = 0; i < this.items.size(); ++i) {
                Tuple pair = (Tuple)this.items.get(i);
                modification.accept((ItemStack)pair.getA(), i, (Tuple<ItemStack, DropRule>)pair);
            }
        }
        for (Map.Entry<String, CompatComponent<?>> entry : this.modInventoryItems.entrySet()) {
            CompatComponent<?> compatComponent = entry.getValue();
            if (!modPredicate.test(entry.getKey())) continue;
            compatComponent.handleItemPairs(modification);
        }
    }

    public boolean isGraveEmpty() {
        for (CompatComponent<?> compatComponent : this.modInventoryItems.values()) {
            if (!compatComponent.containsGraveItems()) continue;
            return false;
        }
        for (Tuple pair : this.items) {
            if (((ItemStack)pair.getA()).isEmpty() || pair.getB() != DropRule.PUT_IN_GRAVE) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        for (CompatComponent<?> compatComponent : this.modInventoryItems.values()) {
            if (compatComponent.isEmpty()) continue;
            return false;
        }
        for (Tuple pair : this.items) {
            if (((ItemStack)pair.getA()).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int graveSize() {
        int size = 0;
        for (CompatComponent<?> compatComponent : this.modInventoryItems.values()) {
            for (Tuple pair : compatComponent.getAsStackDropList()) {
                if (((ItemStack)pair.getA()).isEmpty() || pair.getB() != DropRule.PUT_IN_GRAVE) continue;
                ++size;
            }
        }
        for (Tuple pair : this.items) {
            if (((ItemStack)pair.getA()).isEmpty() || pair.getB() != DropRule.PUT_IN_GRAVE) continue;
            ++size;
        }
        return size;
    }

    public NonNullList<ItemStack> applyToPlayer(ServerPlayer player) {
        NonNullList extraItems = NonNullList.create();
        Inventory inventory = player.getInventory();
        int invMainSize = inventory.items.size();
        int invArmorSize = inventory.armor.size();
        int invOffHandSize = inventory.offhand.size();
        for (int i = 0; i < this.items.size(); ++i) {
            int playerInvIndex;
            if (i < this.mainSize) {
                groupIndex = i;
                playerInvIndex = groupIndex < invMainSize ? groupIndex : -1;
            } else if (i < this.mainSize + this.armorSize) {
                groupIndex = i - this.mainSize;
                playerInvIndex = groupIndex < invArmorSize ? groupIndex + invMainSize : -1;
            } else if (i < this.mainSize + this.armorSize + this.offHandSize) {
                groupIndex = i - (this.mainSize + this.armorSize);
                playerInvIndex = groupIndex < invOffHandSize ? groupIndex + invMainSize + invArmorSize : -1;
            } else {
                groupIndex = i - (this.mainSize + this.armorSize + this.offHandSize);
                playerInvIndex = groupIndex + invMainSize + invArmorSize + invOffHandSize;
            }
            ItemStack stack = ((ItemStack)((Tuple)this.items.get(i)).getA()).copy();
            if (playerInvIndex >= inventory.getContainerSize() || playerInvIndex == -1) {
                extraItems.add((Object)stack);
                continue;
            }
            inventory.setItem(playerInvIndex, stack);
        }
        for (InvModCompat<?> modCompat : InvModCompat.invCompatMods) {
            String modName = modCompat.getModName();
            if (!this.modInventoryItems.containsKey(modName)) continue;
            NonNullList<ItemStack> extraModItems = this.modInventoryItems.get(modName).storeToPlayer(player);
            extraItems.addAll(extraModItems);
        }
        return extraItems;
    }

    public InventoryComponent filteredInv(Predicate<DropRule> filter) {
        NonNullList filteredItems = NonNullList.create();
        for (Tuple pair : this.items) {
            if (filter.test((DropRule)((Object)pair.getB()))) {
                filteredItems.add((Object)pair);
                continue;
            }
            filteredItems.add(EMPTY_ITEM_PAIR);
        }
        HashMap filteredModInventories = new HashMap();
        for (InvModCompat<?> compatMod : InvModCompat.invCompatMods) {
            String modName = compatMod.getModName();
            if (!this.modInventoryItems.containsKey(modName)) continue;
            CompatComponent<?> compatInv = this.modInventoryItems.get(modName);
            CompatComponent<?> filteredCompatInv = compatInv.filterInv(filter);
            filteredModInventories.put(modName, filteredCompatInv);
        }
        return new InventoryComponent((NonNullList<Tuple<ItemStack, DropRule>>)filteredItems, filteredModInventories, this.mainSize, this.armorSize, this.offHandSize);
    }

    public void clear() {
        Collections.fill(this.items, EMPTY_ITEM_PAIR);
        for (CompatComponent<?> component : this.modInventoryItems.values()) {
            component.clear();
        }
    }

    public CompoundTag toNbt(HolderLookup.Provider lookupRegistry) {
        CompoundTag nbt = new CompoundTag();
        CompoundTag vanillaInventoryNbt = InventoryComponent.listToNbt(this.items, pair -> {
            CompoundTag itemNbt = (CompoundTag)((ItemStack)pair.getA()).save(lookupRegistry);
            itemNbt.putString("dropRule", ((DropRule)((Object)((Object)pair.getB()))).name());
            return itemNbt;
        }, pair -> ((ItemStack)pair.getA()).isEmpty());
        vanillaInventoryNbt.putInt("mainSize", this.mainSize);
        vanillaInventoryNbt.putInt("armorSize", this.armorSize);
        vanillaInventoryNbt.putInt("offHandSize", this.offHandSize);
        CompoundTag modInventoriesNbt = new CompoundTag();
        for (InvModCompat<?> compatMod : InvModCompat.invCompatMods) {
            CompatComponent<?> compatInv;
            String modName = compatMod.getModName();
            if (!this.modInventoryItems.containsKey(modName) || (compatInv = this.modInventoryItems.get(modName)).isEmpty()) continue;
            modInventoriesNbt.put(modName, (Tag)compatInv.writeNbt(lookupRegistry));
        }
        nbt.put("vanilla", (Tag)vanillaInventoryNbt);
        nbt.put("mods", (Tag)modInventoriesNbt);
        return nbt;
    }

    public static InventoryComponent fromNbt(CompoundTag nbt, HolderLookup.Provider lookupRegistry) {
        CompoundTag vanillaInvNbt = nbt.getCompound("vanilla");
        NonNullList<Tuple<ItemStack, DropRule>> items = InventoryComponent.listFromNbt(vanillaInvNbt, itemNbt -> {
            ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)lookupRegistry, (CompoundTag)itemNbt);
            DropRule dropRule = GraveOverrideAreas.INSTANCE.defaultDropRule;
            if (itemNbt.contains("dropRule")) {
                dropRule = DropRule.valueOf(itemNbt.getString("dropRule"));
            }
            return new Tuple((Object)stack, (Object)dropRule);
        }, EMPTY_ITEM_PAIR);
        int mainSize = vanillaInvNbt.getInt("mainSize");
        int armorSize = vanillaInvNbt.getInt("armorSize");
        int offHandSize = vanillaInvNbt.getInt("offHandSize");
        CompoundTag modInventoriesNbt = nbt.getCompound("mods");
        HashMap compatComponents = new HashMap();
        for (InvModCompat<?> compatMod : InvModCompat.invCompatMods) {
            String modName = compatMod.getModName();
            if (!modInventoriesNbt.contains(modName)) continue;
            CompoundTag modNbt = modInventoriesNbt.getCompound(modName);
            compatComponents.put(modName, compatMod.readNbt(modNbt, lookupRegistry));
        }
        return new InventoryComponent(items, compatComponents, mainSize, armorSize, offHandSize);
    }

    public static <T> CompoundTag listToNbt(NonNullList<T> list, Function<T, CompoundTag> mappingFunction, Predicate<T> isEmpty) {
        return InventoryComponent.listToNbt(list, mappingFunction, isEmpty, "Items", "Slot");
    }

    public static <T> CompoundTag listToNbt(NonNullList<T> list, Function<T, CompoundTag> mappingFunction, Predicate<T> isEmpty, String listName, String itemName) {
        CompoundTag nbt = new CompoundTag();
        int size = list.size();
        nbt.putInt("size", size);
        ListTag nbtList = new ListTag();
        for (int i = 0; i < size; ++i) {
            Object item = list.get(i);
            if (isEmpty.test(item)) continue;
            CompoundTag itemNbt = mappingFunction.apply(item);
            itemNbt.putInt(itemName, i);
            nbtList.add((Object)itemNbt);
        }
        nbt.put(listName, (Tag)nbtList);
        return nbt;
    }

    public static <T> NonNullList<T> listFromNbt(CompoundTag nbt, Function<CompoundTag, T> mappingFunction, T emptyValue) {
        return InventoryComponent.listFromNbt(nbt, mappingFunction, emptyValue, "Items", "Slot");
    }

    public static <T> NonNullList<T> listFromNbt(CompoundTag nbt, Function<CompoundTag, T> mappingFunction, T emptyValue, String listName, String itemName) {
        int size = nbt.getInt("size");
        NonNullList list = NonNullList.withSize((int)size, emptyValue);
        ListTag nbtList = nbt.getList(listName, 10);
        for (Tag element : nbtList) {
            CompoundTag itemNbt = (CompoundTag)element;
            int index = itemNbt.getInt(itemName);
            T item = mappingFunction.apply(itemNbt);
            list.set(index, item);
        }
        return list;
    }

    public static void dropItemIfToBeDropped(ItemStack stack, double x, double y, double z, ServerLevel world) {
        YigdEvents.DropItemEvent event = (YigdEvents.DropItemEvent)NeoForge.EVENT_BUS.post((Event)new YigdEvents.DropItemEvent(stack, x, y, z, world));
        if (event.shouldDrop()) {
            Containers.dropItemStack((Level)world, (double)x, (double)y, (double)z, (ItemStack)stack.copy());
        }
    }

    public static void clearPlayer(ServerPlayer player) {
        Inventory inventory = player.getInventory();
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            inventory.setItem(i, ItemStack.EMPTY);
        }
        for (InvModCompat<?> invModCompat : InvModCompat.invCompatMods) {
            invModCompat.clear(player);
        }
    }
}

