/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.compat;

import com.b1n_ry.yigd.compat.CompatComponent;
import com.b1n_ry.yigd.compat.InvModCompat;
import com.b1n_ry.yigd.components.InventoryComponent;
import com.b1n_ry.yigd.config.CompatConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.DeathContext;
import com.b1n_ry.yigd.events.YigdEvents;
import com.b1n_ry.yigd.util.DropRule;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class TravelersBackpackCompat
implements InvModCompat<Tuple<ItemStack, DropRule>> {
    public static boolean isIntegrationEnabled() {
        try {
            return TravelersBackpack.enableIntegration();
        }
        catch (Error | Exception e) {
            return false;
        }
    }

    @Override
    public String getModName() {
        return "travelers backpack";
    }

    @Override
    public void clear(ServerPlayer player) {
        AttachmentUtils.getAttachment((Player)player).ifPresent(ITravelersBackpack::removeWearable);
    }

    @Override
    public CompatComponent<Tuple<ItemStack, DropRule>> readNbt(CompoundTag nbt, HolderLookup.Provider registries) {
        ItemStack stack = ItemStack.parse((HolderLookup.Provider)registries, (Tag)nbt).orElse(ItemStack.EMPTY);
        DropRule dropRule = nbt.contains("dropRule") ? DropRule.valueOf(nbt.getString("dropRule")) : YigdConfig.getConfig().compatConfig.defaultTravelersBackpackDropRule;
        return new TBCompatComponent((Tuple<ItemStack, DropRule>)new Tuple((Object)stack, (Object)dropRule));
    }

    @Override
    public CompatComponent<Tuple<ItemStack, DropRule>> getNewComponent(ServerPlayer player) {
        return new TBCompatComponent(player);
    }

    private static class TBCompatComponent
    extends CompatComponent<Tuple<ItemStack, DropRule>> {
        public TBCompatComponent(ServerPlayer player) {
            super(player);
        }

        public TBCompatComponent(Tuple<ItemStack, DropRule> inventory) {
            super(inventory);
        }

        @Override
        public Tuple<ItemStack, DropRule> getInventory(ServerPlayer player) {
            DropRule defaultDropRule = YigdConfig.getConfig().compatConfig.defaultTravelersBackpackDropRule;
            ItemStack stack = AttachmentUtils.getWearingBackpack((Player)player);
            return stack == null ? InventoryComponent.EMPTY_ITEM_PAIR : new Tuple((Object)stack, (Object)defaultDropRule);
        }

        @Override
        public NonNullList<ItemStack> merge(CompatComponent<?> mergingComponent, ServerPlayer merger) {
            NonNullList extraItems = NonNullList.create();
            Tuple pair = (Tuple)mergingComponent.inventory;
            ItemStack mergingStack = (ItemStack)pair.getA();
            ItemStack currentStack = (ItemStack)((Tuple)this.inventory).getA();
            if (mergingStack.isEmpty()) {
                return extraItems;
            }
            if (!currentStack.isEmpty()) {
                extraItems.add((Object)mergingStack);
                return extraItems;
            }
            this.inventory = new Tuple((Object)mergingStack, (Object)((DropRule)((Object)pair.getB())));
            return extraItems;
        }

        @Override
        public NonNullList<ItemStack> storeToPlayer(ServerPlayer player) {
            if (((ItemStack)((Tuple)this.inventory).getA()).isEmpty()) {
                return NonNullList.create();
            }
            AttachmentUtils.equipBackpack((Player)player, (ItemStack)((ItemStack)((Tuple)this.inventory).getA()).copy());
            return NonNullList.create();
        }

        @Override
        public void handleDropRules(DeathContext context) {
            CompatConfig compatConfig = YigdConfig.getConfig().compatConfig;
            DropRule dropRule = compatConfig.defaultTravelersBackpackDropRule;
            ItemStack stack = (ItemStack)((Tuple)this.inventory).getA();
            if (stack.isEmpty()) {
                return;
            }
            if (dropRule == DropRule.PUT_IN_GRAVE) {
                dropRule = ((YigdEvents.DropRuleEvent)NeoForge.EVENT_BUS.post((Event)new YigdEvents.DropRuleEvent(stack, -1, context, true))).getDropRule();
            }
            ((Tuple)this.inventory).setB((Object)dropRule);
        }

        @Override
        public NonNullList<Tuple<ItemStack, DropRule>> getAsStackDropList() {
            NonNullList stacks = NonNullList.create();
            stacks.add((Object)((Tuple)this.inventory));
            return stacks;
        }

        @Override
        public CompatComponent<Tuple<ItemStack, DropRule>> filterInv(Predicate<DropRule> predicate) {
            Tuple pair = predicate.test((DropRule)((Object)((Tuple)this.inventory).getB())) ? (Tuple)this.inventory : InventoryComponent.EMPTY_ITEM_PAIR;
            return new TBCompatComponent((Tuple<ItemStack, DropRule>)pair);
        }

        @Override
        public boolean removeItem(Predicate<ItemStack> predicate, int itemCount) {
            ItemStack stack = (ItemStack)((Tuple)this.inventory).getA();
            if (predicate.test(stack)) {
                stack.shrink(itemCount);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            this.inventory = InventoryComponent.EMPTY_ITEM_PAIR;
        }

        @Override
        public CompoundTag writeNbt(HolderLookup.Provider registries) {
            CompoundTag nbt = (CompoundTag)((ItemStack)((Tuple)this.inventory).getA()).save(registries);
            nbt.putString("dropRule", ((DropRule)((Object)((Tuple)this.inventory).getB())).name());
            return nbt;
        }
    }
}

