/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.compat;

import com.b1n_ry.yigd.compat.AccessoriesCompat;
import com.b1n_ry.yigd.compat.CompatComponent;
import com.b1n_ry.yigd.compat.CosmeticArmorCompat;
import com.b1n_ry.yigd.compat.CuriosCompat;
import com.b1n_ry.yigd.compat.TravelersBackpackCompat;
import com.b1n_ry.yigd.compat.misc_compat_mods.TwilightCompat;
import com.b1n_ry.yigd.config.CompatConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.fml.ModList;

public interface InvModCompat<T> {
    public static final List<InvModCompat<?>> invCompatMods = new ArrayList();

    public static void reloadModCompat() {
        invCompatMods.clear();
        ModList modList = ModList.get();
        CompatConfig compatConfig = YigdConfig.getConfig().compatConfig;
        boolean accessoriesPresent = modList.isLoaded("accessories");
        boolean curiosPresent = modList.isLoaded("curios");
        if (compatConfig.enableAccessoriesCompat && accessoriesPresent) {
            invCompatMods.add(new AccessoriesCompat());
        }
        if (compatConfig.enableCuriosCompat && curiosPresent && !modList.isLoaded("cclayer")) {
            invCompatMods.add(new CuriosCompat());
        }
        if (modList.isLoaded("travelersbackpack") && compatConfig.enableTravelersBackpackCompat && (!accessoriesPresent && !curiosPresent || !TravelersBackpackCompat.isIntegrationEnabled())) {
            invCompatMods.add(new TravelersBackpackCompat());
        }
        if (modList.isLoaded("cosmeticarmorreworked") && compatConfig.enableCosmeticArmorCompat) {
            invCompatMods.add(new CosmeticArmorCompat());
        }
        if (modList.isLoaded("twilightforest")) {
            TwilightCompat.init();
        }
    }

    public String getModName();

    public void clear(ServerPlayer var1);

    public CompatComponent<T> readNbt(CompoundTag var1, HolderLookup.Provider var2);

    public CompatComponent<T> getNewComponent(ServerPlayer var1);
}

