/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.compat;

import com.b1n_ry.yigd.compat.CompatComponent;
import com.b1n_ry.yigd.compat.InvModCompat;
import com.b1n_ry.yigd.components.InventoryComponent;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.DeathContext;
import com.b1n_ry.yigd.events.YigdEvents;
import com.b1n_ry.yigd.util.DropRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.event.DropRulesEvent;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CuriosCompat
implements InvModCompat<Map<String, CuriosSlotEntry>> {
    @Override
    public String getModName() {
        return "curios";
    }

    @Override
    public void clear(ServerPlayer player) {
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
            for (ICurioStacksHandler stacksHandler : handler.getCurios().values()) {
                IDynamicStackHandler[] stackHandlers;
                for (IDynamicStackHandler dynamicStackHandler : stackHandlers = new IDynamicStackHandler[]{stacksHandler.getStacks(), stacksHandler.getCosmeticStacks()}) {
                    for (int i = 0; i < dynamicStackHandler.getSlots(); ++i) {
                        dynamicStackHandler.setStackInSlot(i, ItemStack.EMPTY);
                    }
                }
            }
        });
    }

    @Override
    public CompatComponent<Map<String, CuriosSlotEntry>> readNbt(CompoundTag nbt, HolderLookup.Provider registries) {
        HashMap<String, CuriosSlotEntry> inventory = new HashMap<String, CuriosSlotEntry>();
        for (String key : nbt.getAllKeys()) {
            CompoundTag slotNbt = nbt.getCompound(key);
            NonNullList<Tuple<ItemStack, DropRule>> normalSlot = InventoryComponent.listFromNbt(slotNbt.getCompound("normal"), itemNbt -> {
                String dropRuleString;
                ItemStack stack = ItemStack.parse((HolderLookup.Provider)registries, (Tag)itemNbt).orElse(ItemStack.EMPTY);
                DropRule dropRule = itemNbt.contains("dropRule") ? ((dropRuleString = itemNbt.getString("dropRule")).equals("DEFAULT") ? YigdConfig.getConfig().compatConfig.defaultCuriosDropRule : DropRule.valueOf(dropRuleString)) : YigdConfig.getConfig().compatConfig.defaultCuriosDropRule;
                return new Tuple((Object)stack, (Object)dropRule);
            }, InventoryComponent.EMPTY_ITEM_PAIR);
            NonNullList<Tuple<ItemStack, DropRule>> cosmeticSlot = InventoryComponent.listFromNbt(slotNbt.getCompound("cosmetic"), itemNbt -> {
                String dropRuleString;
                ItemStack stack = ItemStack.parse((HolderLookup.Provider)registries, (Tag)itemNbt).orElse(ItemStack.EMPTY);
                DropRule dropRule = itemNbt.contains("dropRule") ? ((dropRuleString = itemNbt.getString("dropRule")).equals("DEFAULT") ? YigdConfig.getConfig().compatConfig.defaultCuriosDropRule : DropRule.valueOf(dropRuleString)) : YigdConfig.getConfig().compatConfig.defaultCuriosDropRule;
                return new Tuple((Object)stack, (Object)dropRule);
            }, InventoryComponent.EMPTY_ITEM_PAIR);
            inventory.put(key, new CuriosSlotEntry(normalSlot, cosmeticSlot));
        }
        return new CuriosCompatComponent((Map<String, CuriosSlotEntry>)inventory);
    }

    @Override
    public CompatComponent<Map<String, CuriosSlotEntry>> getNewComponent(ServerPlayer player) {
        return new CuriosCompatComponent(player);
    }

    public record CuriosSlotEntry(NonNullList<Tuple<ItemStack, DropRule>> normal, NonNullList<Tuple<ItemStack, DropRule>> cosmetic) {
        private void addAllNonEmptyToList(Collection<ItemStack> list) {
            for (Tuple pair : this.normal) {
                list.add(((ItemStack)pair.getA()).copy());
            }
            for (Tuple pair : this.cosmetic) {
                list.add(((ItemStack)pair.getA()).copy());
            }
        }
    }

    private static class CuriosCompatComponent
    extends CompatComponent<Map<String, CuriosSlotEntry>> {
        public CuriosCompatComponent(ServerPlayer player) {
            super(player);
        }

        public CuriosCompatComponent(Map<String, CuriosSlotEntry> inventory) {
            super(inventory);
        }

        @Override
        public Map<String, CuriosSlotEntry> getInventory(ServerPlayer player) {
            HashMap<String, CuriosSlotEntry> inventory = new HashMap<String, CuriosSlotEntry>();
            Optional optionalHandler = CuriosApi.getCuriosInventory((LivingEntity)player);
            if (optionalHandler.isEmpty()) {
                return inventory;
            }
            for (Map.Entry entry : ((ICuriosItemHandler)optionalHandler.get()).getCurios().entrySet()) {
                ICurioStacksHandler stacksHandler = (ICurioStacksHandler)entry.getValue();
                NonNullList normalItems = NonNullList.create();
                NonNullList cosmeticItems = NonNullList.create();
                IDynamicStackHandler normalEquipped = stacksHandler.getStacks();
                for (int i = 0; i < normalEquipped.getSlots(); ++i) {
                    normalItems.add((Object)new Tuple((Object)normalEquipped.getStackInSlot(i).copy(), (Object)DropRule.PUT_IN_GRAVE));
                }
                IDynamicStackHandler cosmeticEquipped = stacksHandler.getCosmeticStacks();
                for (int i = 0; i < cosmeticEquipped.getSlots(); ++i) {
                    cosmeticItems.add((Object)new Tuple((Object)cosmeticEquipped.getStackInSlot(i).copy(), (Object)DropRule.PUT_IN_GRAVE));
                }
                inventory.put((String)entry.getKey(), new CuriosSlotEntry((NonNullList<Tuple<ItemStack, DropRule>>)normalItems, (NonNullList<Tuple<ItemStack, DropRule>>)cosmeticItems));
            }
            return inventory;
        }

        @Override
        public NonNullList<ItemStack> merge(CompatComponent<?> mergingComponent, ServerPlayer merger) {
            NonNullList extraItems = NonNullList.create();
            Map mergingInventory = (Map)mergingComponent.inventory;
            for (Map.Entry entry : mergingInventory.entrySet()) {
                ItemStack thisStack;
                Tuple currentPair;
                ItemStack mergingStack;
                Tuple mergingTuple;
                int i;
                String key = (String)entry.getKey();
                if (!((Map)this.inventory).containsKey(key)) {
                    ((CuriosSlotEntry)entry.getValue()).addAllNonEmptyToList((Collection<ItemStack>)extraItems);
                    continue;
                }
                CuriosSlotEntry mergingSlot = (CuriosSlotEntry)entry.getValue();
                CuriosSlotEntry thisSlot = (CuriosSlotEntry)((Map)this.inventory).get(key);
                for (i = 0; i < mergingSlot.normal.size(); ++i) {
                    mergingTuple = (Tuple)mergingSlot.normal.get(i);
                    mergingStack = ((ItemStack)mergingTuple.getA()).copy();
                    if (mergingStack.isEmpty()) continue;
                    if (thisSlot.normal.size() <= i) {
                        extraItems.add((Object)mergingStack);
                        continue;
                    }
                    currentPair = (Tuple)thisSlot.normal.get(i);
                    thisStack = (ItemStack)currentPair.getA();
                    if (YigdConfig.getConfig().graveConfig.treatBindingCurse && this.blockUnequip(mergingStack, key, i, merger, false)) {
                        extraItems.add((Object)((ItemStack)currentPair.getA()));
                        thisSlot.normal.set(i, (Object)new Tuple((Object)mergingStack, (Object)((DropRule)((Object)mergingTuple.getB()))));
                        continue;
                    }
                    if (!thisStack.isEmpty()) {
                        extraItems.add((Object)mergingStack);
                        continue;
                    }
                    thisSlot.normal.set(i, (Object)mergingTuple);
                }
                for (i = 0; i < mergingSlot.cosmetic.size(); ++i) {
                    mergingTuple = (Tuple)mergingSlot.cosmetic.get(i);
                    mergingStack = ((ItemStack)mergingTuple.getA()).copy();
                    if (mergingStack.isEmpty()) continue;
                    if (thisSlot.cosmetic.size() <= i) {
                        extraItems.add((Object)mergingStack);
                        continue;
                    }
                    currentPair = (Tuple)thisSlot.cosmetic.get(i);
                    thisStack = (ItemStack)currentPair.getA();
                    if (YigdConfig.getConfig().graveConfig.treatBindingCurse && this.blockUnequip(mergingStack, key, i, merger, true)) {
                        extraItems.add((Object)((ItemStack)currentPair.getA()));
                        thisSlot.cosmetic.set(i, (Object)new Tuple((Object)mergingStack, (Object)((DropRule)((Object)mergingTuple.getB()))));
                        continue;
                    }
                    if (!thisStack.isEmpty()) {
                        extraItems.add((Object)mergingStack);
                        continue;
                    }
                    thisSlot.cosmetic.set(i, (Object)mergingTuple);
                }
            }
            return extraItems;
        }

        @Override
        public NonNullList<ItemStack> pullBindingCurseItems(ServerPlayer playerRef) {
            NonNullList noUnequipItems = NonNullList.create();
            if (!YigdConfig.getConfig().graveConfig.treatBindingCurse) {
                return noUnequipItems;
            }
            for (Map.Entry entry : ((Map)this.inventory).entrySet()) {
                boolean isBound;
                ItemStack stack;
                Tuple pair;
                int i;
                CuriosSlotEntry inventorySlot = (CuriosSlotEntry)entry.getValue();
                for (i = 0; i < inventorySlot.normal.size(); ++i) {
                    pair = (Tuple)inventorySlot.normal.get(i);
                    stack = (ItemStack)pair.getA();
                    isBound = this.blockUnequip(stack, (String)entry.getKey(), i, playerRef, false);
                    if (!isBound) continue;
                    noUnequipItems.add((Object)stack);
                    pair.setA((Object)ItemStack.EMPTY);
                }
                for (i = 0; i < inventorySlot.cosmetic.size(); ++i) {
                    pair = (Tuple)inventorySlot.cosmetic.get(i);
                    stack = (ItemStack)pair.getA();
                    isBound = this.blockUnequip(stack, (String)entry.getKey(), i, playerRef, true);
                    if (!isBound) continue;
                    noUnequipItems.add((Object)stack);
                    pair.setA((Object)ItemStack.EMPTY);
                }
            }
            return noUnequipItems;
        }

        private boolean blockUnequip(ItemStack stack, String key, int index, ServerPlayer playerRef, boolean cosmetic) {
            Optional iCurio = CuriosApi.getCurio((ItemStack)stack);
            return iCurio.map(curio -> curio.canUnequip(new SlotContext(key, (LivingEntity)playerRef, index, cosmetic, false))).orElse(true) == false;
        }

        @Override
        public NonNullList<ItemStack> storeToPlayer(ServerPlayer player) {
            NonNullList extraItems = NonNullList.create();
            Optional optional = CuriosApi.getCuriosInventory((LivingEntity)player);
            if (optional.isEmpty()) {
                return extraItems;
            }
            Map stacksHandlerMap = ((ICuriosItemHandler)optional.get()).getCurios();
            for (Map.Entry entry : ((Map)this.inventory).entrySet()) {
                Tuple tuple;
                int i;
                String key = (String)entry.getKey();
                if (!stacksHandlerMap.containsKey(key)) {
                    ((CuriosSlotEntry)entry.getValue()).addAllNonEmptyToList((Collection<ItemStack>)extraItems);
                    continue;
                }
                ICurioStacksHandler stacksHandler = (ICurioStacksHandler)stacksHandlerMap.get(key);
                CuriosSlotEntry slotEntry = (CuriosSlotEntry)entry.getValue();
                IDynamicStackHandler normalEquipped = stacksHandler.getStacks();
                IDynamicStackHandler cosmeticEquipped = stacksHandler.getCosmeticStacks();
                for (i = 0; i < slotEntry.normal.size(); ++i) {
                    tuple = (Tuple)slotEntry.normal.get(i);
                    if (i >= normalEquipped.getSlots()) {
                        extraItems.add((Object)((ItemStack)tuple.getA()).copy());
                        continue;
                    }
                    normalEquipped.setStackInSlot(i, ((ItemStack)tuple.getA()).copy());
                }
                for (i = 0; i < slotEntry.cosmetic.size(); ++i) {
                    tuple = (Tuple)slotEntry.cosmetic.get(i);
                    if (i >= cosmeticEquipped.getSlots()) {
                        extraItems.add((Object)((ItemStack)tuple.getA()).copy());
                        continue;
                    }
                    cosmeticEquipped.setStackInSlot(i, ((ItemStack)tuple.getA()).copy());
                }
            }
            return extraItems;
        }

        private ICurio.DropRule getDropRule(ItemStack stack, String key, int index, DeathContext context, boolean cosmetic, List<Tuple<Predicate<ItemStack>, ICurio.DropRule>> overrides) {
            for (Tuple<Predicate<ItemStack>, ICurio.DropRule> t : overrides) {
                if (!((Predicate)t.getA()).test(stack)) continue;
                return (ICurio.DropRule)t.getB();
            }
            Optional iCurio = CuriosApi.getCurio((ItemStack)stack);
            return iCurio.map(curio -> curio.getDropRule(new SlotContext(key, (LivingEntity)context.player(), index, cosmetic, false), context.deathSource(), 0, true)).orElse(ICurio.DropRule.DEFAULT);
        }

        @Override
        public void handleDropRules(DeathContext context) {
            ServerPlayer player = context.player();
            ArrayList<Tuple<Predicate<ItemStack>, ICurio.DropRule>> overrides = new ArrayList<Tuple<Predicate<ItemStack>, ICurio.DropRule>>();
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
                DropRulesEvent event = (DropRulesEvent)NeoForge.EVENT_BUS.post((Event)new DropRulesEvent((LivingEntity)player, handler, context.deathSource(), 0, false));
                overrides.addAll((Collection<Tuple<Predicate<ItemStack>, ICurio.DropRule>>)event.getOverrides());
            });
            for (Map.Entry entry : ((Map)this.inventory).entrySet()) {
                DropRule dropRule;
                DropRule defaultDropRule;
                ItemStack stack;
                Tuple pair;
                int i;
                String key = (String)entry.getKey();
                CuriosSlotEntry inventorySlot = (CuriosSlotEntry)entry.getValue();
                for (i = 0; i < inventorySlot.normal.size(); ++i) {
                    pair = (Tuple)inventorySlot.normal.get(i);
                    stack = (ItemStack)pair.getA();
                    dropRule = switch (this.getDropRule(stack, key, i, context, false, overrides)) {
                        case ICurio.DropRule.DESTROY -> DropRule.DESTROY;
                        case ICurio.DropRule.ALWAYS_KEEP -> DropRule.KEEP;
                        default -> {
                            defaultDropRule = YigdConfig.getConfig().compatConfig.defaultCuriosDropRule;
                            if (defaultDropRule == DropRule.PUT_IN_GRAVE) {
                                yield ((YigdEvents.DropRuleEvent)NeoForge.EVENT_BUS.post((Event)new YigdEvents.DropRuleEvent(stack, -1, context, true))).getDropRule();
                            }
                            yield defaultDropRule;
                        }
                    };
                    pair.setB((Object)dropRule);
                }
                for (i = 0; i < inventorySlot.cosmetic.size(); ++i) {
                    pair = (Tuple)inventorySlot.cosmetic.get(i);
                    stack = (ItemStack)pair.getA();
                    dropRule = switch (this.getDropRule(stack, key, i, context, true, overrides)) {
                        case ICurio.DropRule.DESTROY -> DropRule.DESTROY;
                        case ICurio.DropRule.ALWAYS_KEEP -> DropRule.KEEP;
                        default -> {
                            defaultDropRule = YigdConfig.getConfig().compatConfig.defaultCuriosDropRule;
                            if (defaultDropRule == DropRule.PUT_IN_GRAVE) {
                                yield ((YigdEvents.DropRuleEvent)NeoForge.EVENT_BUS.post((Event)new YigdEvents.DropRuleEvent(stack, -1, context, true))).getDropRule();
                            }
                            yield defaultDropRule;
                        }
                    };
                    pair.setB((Object)dropRule);
                }
            }
        }

        @Override
        public NonNullList<Tuple<ItemStack, DropRule>> getAsStackDropList() {
            NonNullList allItems = NonNullList.create();
            for (CuriosSlotEntry slotEntry : ((Map)this.inventory).values()) {
                allItems.addAll(slotEntry.normal);
                allItems.addAll(slotEntry.cosmetic);
            }
            return allItems;
        }

        @Override
        public CompatComponent<Map<String, CuriosSlotEntry>> filterInv(Predicate<DropRule> predicate) {
            HashMap<String, CuriosSlotEntry> filtered = new HashMap<String, CuriosSlotEntry>();
            for (Map.Entry entry : ((Map)this.inventory).entrySet()) {
                CuriosSlotEntry inventorySlot = (CuriosSlotEntry)entry.getValue();
                NonNullList normalSlot = NonNullList.create();
                NonNullList cosmeticSlot = NonNullList.create();
                for (Tuple pair : inventorySlot.normal) {
                    if (predicate.test((DropRule)((Object)pair.getB()))) {
                        normalSlot.add((Object)pair);
                        continue;
                    }
                    normalSlot.add(InventoryComponent.EMPTY_ITEM_PAIR);
                }
                for (Tuple pair : inventorySlot.cosmetic) {
                    if (predicate.test((DropRule)((Object)pair.getB()))) {
                        cosmeticSlot.add((Object)pair);
                        continue;
                    }
                    cosmeticSlot.add(InventoryComponent.EMPTY_ITEM_PAIR);
                }
                filtered.put((String)entry.getKey(), new CuriosSlotEntry((NonNullList<Tuple<ItemStack, DropRule>>)normalSlot, (NonNullList<Tuple<ItemStack, DropRule>>)cosmeticSlot));
            }
            return new CuriosCompatComponent((Map<String, CuriosSlotEntry>)filtered);
        }

        @Override
        public boolean removeItem(Predicate<ItemStack> predicate, int itemCount) {
            for (CuriosSlotEntry inventorySlot : ((Map)this.inventory).values()) {
                for (Tuple pair : inventorySlot.normal) {
                    ItemStack stack = (ItemStack)pair.getA();
                    if (!predicate.test(stack)) continue;
                    stack.shrink(itemCount);
                    return true;
                }
            }
            return false;
        }

        @Override
        public void clear() {
            for (CuriosSlotEntry inventorySlot : ((Map)this.inventory).values()) {
                Collections.fill(inventorySlot.normal, InventoryComponent.EMPTY_ITEM_PAIR);
                Collections.fill(inventorySlot.cosmetic, InventoryComponent.EMPTY_ITEM_PAIR);
            }
        }

        @Override
        public CompoundTag writeNbt(HolderLookup.Provider registries) {
            CompoundTag nbt = new CompoundTag();
            for (Map.Entry entry : ((Map)this.inventory).entrySet()) {
                CuriosSlotEntry inventorySlot = (CuriosSlotEntry)entry.getValue();
                CompoundTag slotNbt = new CompoundTag();
                CompoundTag normalNbt = InventoryComponent.listToNbt(inventorySlot.normal, pair -> {
                    CompoundTag itemNbt = (CompoundTag)((ItemStack)pair.getA()).save(registries);
                    itemNbt.putString("dropRule", ((DropRule)((Object)((Object)pair.getB()))).name());
                    return itemNbt;
                }, pair -> ((ItemStack)pair.getA()).isEmpty());
                CompoundTag cosmeticNbt = InventoryComponent.listToNbt(inventorySlot.cosmetic, pair -> {
                    CompoundTag itemNbt = (CompoundTag)((ItemStack)pair.getA()).save(registries);
                    itemNbt.putString("dropRule", ((DropRule)((Object)((Object)pair.getB()))).name());
                    return itemNbt;
                }, pair -> ((ItemStack)pair.getA()).isEmpty());
                slotNbt.put("normal", (Tag)normalNbt);
                slotNbt.put("cosmetic", (Tag)cosmeticNbt);
                nbt.put((String)entry.getKey(), (Tag)slotNbt);
            }
            return nbt;
        }
    }
}

