/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.compat;

import com.b1n_ry.yigd.components.InventoryComponent;
import com.b1n_ry.yigd.data.DeathContext;
import com.b1n_ry.yigd.util.DropRule;
import com.b1n_ry.yigd.util.PairModificationConsumer;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public abstract class CompatComponent<T> {
    protected T inventory;

    public CompatComponent(ServerPlayer player) {
        this.inventory = this.getInventory(player);
    }

    public CompatComponent(T inventory) {
        this.inventory = inventory;
    }

    public abstract T getInventory(ServerPlayer var1);

    public NonNullList<ItemStack> pullBindingCurseItems(ServerPlayer playerRef) {
        return NonNullList.create();
    }

    public abstract NonNullList<ItemStack> merge(CompatComponent<?> var1, ServerPlayer var2);

    public abstract NonNullList<ItemStack> storeToPlayer(ServerPlayer var1);

    public abstract void handleDropRules(DeathContext var1);

    public abstract NonNullList<Tuple<ItemStack, DropRule>> getAsStackDropList();

    public abstract CompatComponent<T> filterInv(Predicate<DropRule> var1);

    public abstract boolean removeItem(Predicate<ItemStack> var1, int var2);

    public void dropItems(ServerLevel world, Vec3 pos) {
        NonNullList<Tuple<ItemStack, DropRule>> items = this.getAsStackDropList();
        for (Tuple pair : items) {
            ItemStack stack = (ItemStack)pair.getA();
            if (stack.isEmpty()) continue;
            InventoryComponent.dropItemIfToBeDropped((ItemStack)pair.getA(), pos.x, pos.y, pos.z, world);
        }
    }

    public void dropGraveItems(ServerLevel world, Vec3 pos) {
        NonNullList<Tuple<ItemStack, DropRule>> items = this.getAsStackDropList();
        for (Tuple pair : items) {
            ItemStack stack = (ItemStack)pair.getA();
            if (stack.isEmpty() || pair.getB() == DropRule.KEEP || pair.getB() == DropRule.DESTROY) continue;
            pair.setB((Object)DropRule.DROP);
            InventoryComponent.dropItemIfToBeDropped((ItemStack)pair.getA(), pos.x, pos.y, pos.z, world);
        }
    }

    public abstract void clear();

    public boolean containsGraveItems() {
        for (Tuple pair : this.getAsStackDropList()) {
            if (((ItemStack)pair.getA()).isEmpty() || pair.getB() != DropRule.PUT_IN_GRAVE) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return !this.containsAny(stack -> !stack.isEmpty());
    }

    public boolean containsAny(Predicate<ItemStack> predicate) {
        for (Tuple pair : this.getAsStackDropList()) {
            if (!predicate.test((ItemStack)pair.getA())) continue;
            return true;
        }
        return false;
    }

    public void handleItemPairs(PairModificationConsumer modification) {
        for (Tuple pair : this.getAsStackDropList()) {
            modification.accept((ItemStack)pair.getA(), -1, (Tuple<ItemStack, DropRule>)pair);
        }
    }

    public abstract CompoundTag writeNbt(HolderLookup.Provider var1);
}

