/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.mixin;

import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.wanmine.wab.config.WabServerConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Sniffer.class})
public class SnifferMixin {
    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void onConstructed(CallbackInfo info) {
        Sniffer sniffer = (Sniffer)this;
        sniffer.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((Double)WabServerConfig.SNIFFER_HEALTH.get()).doubleValue());
        sniffer.getAttribute(Attributes.ARMOR).setBaseValue(((Double)WabServerConfig.SNIFFER_ARMOR.get()).doubleValue());
        sniffer.getAttribute(Attributes.ARMOR_TOUGHNESS).setBaseValue(((Double)WabServerConfig.SNIFFER_ARMOR_TOUGHNESS.get()).doubleValue());
        sniffer.setHealth((float)((double)sniffer.getHealth() / sniffer.getAttribute(Attributes.MAX_HEALTH).getBaseValue()) * ((Double)WabServerConfig.SNIFFER_HEALTH.get()).floatValue());
    }

    @Redirect(method={"createAttributes"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Mob;createMobAttributes()Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;"))
    private static AttributeSupplier.Builder redirectCreateMobAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.1f).add(Attributes.MAX_HEALTH, 75.0).add(Attributes.ARMOR, 3.0).add(Attributes.ARMOR_TOUGHNESS, 1.0);
    }
}

