/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.init.world;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.wanmine.wab.WanAncientBeasts;

public class WabSounds {
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((ResourceKey)Registries.SOUND_EVENT, (String)"wan_ancient_beasts");
    public static final DeferredHolder<SoundEvent, SoundEvent> EGG_HATCHED = WabSounds.register("block.egg.hatched");
    public static final DeferredHolder<SoundEvent, SoundEvent> EATER_IDLE = WabSounds.register("entity.eater.idle");
    public static final DeferredHolder<SoundEvent, SoundEvent> EATER_SLEEP = WabSounds.register("entity.eater.sleep");
    public static final DeferredHolder<SoundEvent, SoundEvent> EATER_STEP = WabSounds.register("entity.eater.step");
    public static final DeferredHolder<SoundEvent, SoundEvent> EATER_BITE = WabSounds.register("entity.eater.bite");
    public static final DeferredHolder<SoundEvent, SoundEvent> EATER_HIT = WabSounds.register("entity.eater.hit");
    public static final DeferredHolder<SoundEvent, SoundEvent> BABY_EATER_ROAR = WabSounds.register("entity.eater.baby_roar");
    public static final DeferredHolder<SoundEvent, SoundEvent> EATER_ROAR = WabSounds.register("entity.eater.roar");
    public static final DeferredHolder<SoundEvent, SoundEvent> EATER_DEATH = WabSounds.register("entity.eater.death");
    public static final DeferredHolder<SoundEvent, SoundEvent> WALKER_IDLE = WabSounds.register("entity.walker.idle");
    public static final DeferredHolder<SoundEvent, SoundEvent> WALKER_STEP = WabSounds.register("entity.walker.step");
    public static final DeferredHolder<SoundEvent, SoundEvent> WALKER_HIT = WabSounds.register("entity.walker.hit");
    public static final DeferredHolder<SoundEvent, SoundEvent> WALKER_DEATH = WabSounds.register("entity.walker.death");
    public static final DeferredHolder<SoundEvent, SoundEvent> CRUSHER_IDLE = WabSounds.register("entity.crusher.idle");
    public static final DeferredHolder<SoundEvent, SoundEvent> CRUSHER_ATTACK = WabSounds.register("entity.crusher.attack");
    public static final DeferredHolder<SoundEvent, SoundEvent> CRUSHER_ATTACK_AREA = WabSounds.register("entity.crusher.attack_area");
    public static final DeferredHolder<SoundEvent, SoundEvent> CRUSHER_HURT = WabSounds.register("entity.crusher.hurt");
    public static final DeferredHolder<SoundEvent, SoundEvent> GLIDER_IDLE = WabSounds.register("entity.glider.idle");
    public static final DeferredHolder<SoundEvent, SoundEvent> GLIDER_FLAP_START = WabSounds.register("entity.glider.flap_start");
    public static final DeferredHolder<SoundEvent, SoundEvent> GLIDER_FLAP = WabSounds.register("entity.glider.flap");
    public static final DeferredHolder<SoundEvent, SoundEvent> GLIDER_LANDING = WabSounds.register("entity.glider.landing");
    public static final DeferredHolder<SoundEvent, SoundEvent> GLIDER_HURT = WabSounds.register("entity.glider.hurt");
    public static final DeferredHolder<SoundEvent, SoundEvent> GLIDER_DEATH = WabSounds.register("entity.glider.death");
    public static final DeferredHolder<SoundEvent, SoundEvent> SOARER_IDLE = WabSounds.register("entity.soarer.idle");
    public static final DeferredHolder<SoundEvent, SoundEvent> SOARER_FLAP_START = WabSounds.register("entity.soarer.flap_start");
    public static final DeferredHolder<SoundEvent, SoundEvent> SOARER_FLAP = WabSounds.register("entity.soarer.flap");
    public static final DeferredHolder<SoundEvent, SoundEvent> SOARER_LANDING = WabSounds.register("entity.soarer.landing");
    public static final DeferredHolder<SoundEvent, SoundEvent> SOARER_GLIDE = WabSounds.register("entity.soarer.glide");
    public static final DeferredHolder<SoundEvent, SoundEvent> SOARER_ATTACK = WabSounds.register("entity.soarer.attack");
    public static final AgeableSoundRegistry SURFER_IDLE = WabSounds.registerAgeable("entity.surfer.idle");
    public static final AgeableSoundRegistry SURFER_WALK = WabSounds.registerAgeable("entity.surfer.walk");
    public static final AgeableSoundRegistry SURFER_RUN = WabSounds.registerAgeable("entity.surfer.run");
    public static final AgeableSoundRegistry SURFER_IDLE_WATER = WabSounds.registerAgeable("entity.surfer.idle_water");
    public static final AgeableSoundRegistry SURFER_SWIM = WabSounds.registerAgeable("entity.surfer.swim");
    public static final AgeableSoundRegistry SURFER_FAST_SWIM = WabSounds.registerAgeable("entity.surfer.fast_swim");
    public static final AgeableSoundRegistry SURFER_IDLE_TO_RELAX = WabSounds.registerAgeable("entity.surfer.idle_to_relax");
    public static final AgeableSoundRegistry SURFER_RELAX_TO_IDLE = WabSounds.registerAgeable("entity.surfer.relax_to_idle");
    public static final AgeableSoundRegistry SURFER_RELAX = WabSounds.registerAgeable("entity.surfer.relax");
    public static final AgeableSoundRegistry SURFER_ROAR = WabSounds.registerAgeable("entity.surfer.roar");
    public static final AgeableSoundRegistry SURFER_JUMP_START = WabSounds.registerAgeable("entity.surfer.jump_start");
    public static final AgeableSoundRegistry SURFER_JUMP_POSE = WabSounds.registerAgeable("entity.surfer.jump_pose");
    public static final AgeableSoundRegistry SURFER_JUMP_LANDING = WabSounds.registerAgeable("entity.surfer.jump_landing");
    public static final DeferredHolder<SoundEvent, SoundEvent> SURFER_HURT = WabSounds.register("entity.surfer.hurt");
    public static final AgeableSoundRegistry SURFER_DEATH = WabSounds.registerAgeable("entity.surfer.death");

    private static DeferredHolder<SoundEvent, SoundEvent> register(String name) {
        return SOUNDS.register(name, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)WanAncientBeasts.resource(name)));
    }

    private static AgeableSoundRegistry registerAgeable(String name) {
        return new AgeableSoundRegistry((DeferredHolder<SoundEvent, SoundEvent>)SOUNDS.register(name, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)WanAncientBeasts.resource(name))), (DeferredHolder<SoundEvent, SoundEvent>)SOUNDS.register(name + "_baby", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)WanAncientBeasts.resource(name + "_baby"))));
    }

    public record AgeableSoundRegistry(DeferredHolder<SoundEvent, SoundEvent> adult, DeferredHolder<SoundEvent, SoundEvent> baby) {
        public SoundEvent get(boolean baby) {
            return baby ? (SoundEvent)this.baby.get() : (SoundEvent)this.adult.get();
        }
    }
}

