/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.init.world;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.wanmine.wab.entity.Crusher;
import net.wanmine.wab.entity.Eater;
import net.wanmine.wab.entity.Glider;
import net.wanmine.wab.entity.Paleontologist;
import net.wanmine.wab.entity.Soarer;
import net.wanmine.wab.entity.Surfer;
import net.wanmine.wab.entity.Toxlacanth;
import net.wanmine.wab.entity.Walker;

public class WabEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"wan_ancient_beasts");
    public static final DeferredHolder<EntityType<?>, EntityType<Eater>> EATER = WabEntities.registerMob("eater", Eater::new, MobCategory.CREATURE, 2.2f, 2.7f);
    public static final DeferredHolder<EntityType<?>, EntityType<Walker>> WALKER = WabEntities.registerMob("walker", Walker::new, MobCategory.CREATURE, 3.5f, 4.5f);
    public static final DeferredHolder<EntityType<?>, EntityType<Crusher>> CRUSHER = WabEntities.registerMob("crusher", Crusher::new, MobCategory.CREATURE, 1.2f, 1.8f);
    public static final DeferredHolder<EntityType<?>, EntityType<Glider>> GLIDER = WabEntities.registerMob("glider", Glider::new, MobCategory.CREATURE, 0.9f, 1.1f);
    public static final DeferredHolder<EntityType<?>, EntityType<Soarer>> SOARER = WabEntities.registerMob("soarer", Soarer::new, MobCategory.CREATURE, 1.3f, 2.0f);
    public static final DeferredHolder<EntityType<?>, EntityType<Surfer>> SURFER = WabEntities.registerMob("surfer", Surfer::new, MobCategory.WATER_CREATURE, 1.2f, 0.7f);
    public static final DeferredHolder<EntityType<?>, EntityType<Paleontologist>> PALEONTOLOGIST = WabEntities.registerMob("paleontologist", Paleontologist::new, MobCategory.MISC, 0.6f, 1.95f);
    public static final DeferredHolder<EntityType<?>, EntityType<Toxlacanth>> TOXLACANTH = WabEntities.registerMob("toxlacanth", Toxlacanth::new, MobCategory.WATER_CREATURE, 0.5f, 0.7f);

    public static <T extends Mob> DeferredHolder<EntityType<?>, EntityType<T>> registerMob(String name, EntityType.EntityFactory<T> entity, MobCategory category, float width, float height) {
        return ENTITIES.register(name, () -> EntityType.Builder.of((EntityType.EntityFactory)entity, (MobCategory)category).sized(width, height).build(name));
    }
}

