/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.init.gen.data;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import net.wanmine.wab.WanAncientBeasts;
import net.wanmine.wab.init.data.WabTags;
import net.wanmine.wab.init.world.WabBlocks;
import net.wanmine.wab.init.world.WabItems;
import net.wanmine.wab.item.HangGlider;

public class WabRecipeGenerator
extends RecipeProvider
implements IConditionBuilder {
    public WabRecipeGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> lookUp) {
        super(output, lookUp);
    }

    protected void buildRecipes(RecipeOutput output) {
        WabRecipeGenerator.stair(output, (ItemLike)WabBlocks.STRAW_STAIRS.get(), (ItemLike)WabBlocks.STRAW_BLOCK.get());
        WabRecipeGenerator.slab((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)WabBlocks.STRAW_SLAB.get()), (ItemLike)((ItemLike)WabBlocks.STRAW_BLOCK.get()));
        WabRecipeGenerator.foodCampfire(output, (ItemLike)WabItems.FROZEN_ANCIENT_MEAT.get(), (ItemLike)WabItems.RAW_ANCIENT_MEAT.get());
        WabRecipeGenerator.foodCooking(output, (ItemLike)WabItems.RAW_ANCIENT_MEAT.get(), (ItemLike)WabItems.COOKED_ANCIENT_MEAT.get());
        WabRecipeGenerator.foodCooking(output, (ItemLike)WabItems.TOXLACANTH.get(), (ItemLike)WabItems.COOKED_TOXLACANTH.get());
        WabRecipeGenerator.trimSmithing(output, (Item)WabItems.SNIFF_ARMOR_TRIM_SMITHING_TEMPLATE.get());
        WabRecipeGenerator.trimSmithing(output, (Item)WabItems.SPIKE_ARMOR_TRIM_SMITHING_TEMPLATE.get());
        WabRecipeGenerator.ancientSmithing(output, RecipeCategory.COMBAT, (ItemLike)Items.SHIELD, (ItemLike)WabBlocks.CRUSHER_SPIKE.get(), (Item)WabItems.REINFORCED_SHIELD.get());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)WabItems.ANCIENT_CLUB.get())).pattern("###").pattern("#P#").pattern(" S ").define(Character.valueOf('#'), (ItemLike)WabItems.EATER_TOOTH.get()).define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('S'), (ItemLike)Items.STICK).unlockedBy(WabRecipeGenerator.getHasName((ItemLike)((ItemLike)WabItems.EATER_TOOTH.get())), WabRecipeGenerator.has((ItemLike)((ItemLike)WabItems.EATER_TOOTH.get()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)Items.ARROW, (int)4).pattern("X").pattern("#").pattern("Y").define(Character.valueOf('X'), (ItemLike)Items.FLINT).define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('Y'), (ItemLike)WabItems.GLIDER_FEATHER.get()).unlockedBy(WabRecipeGenerator.getHasName((ItemLike)((ItemLike)WabItems.GLIDER_FEATHER.get())), WabRecipeGenerator.has((ItemLike)((ItemLike)WabItems.GLIDER_FEATHER.get()))).save(output, WabRecipeGenerator.getConversionRecipeName((ItemLike)Items.ARROW, "glider"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)WabItems.CHISEL.get())).pattern("I").pattern("C").pattern("#").define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('C'), (ItemLike)Items.COPPER_INGOT).define(Character.valueOf('#'), (ItemLike)Items.STICK).unlockedBy(WabRecipeGenerator.getHasName((ItemLike)Items.IRON_INGOT), WabRecipeGenerator.has((ItemLike)Items.IRON_INGOT)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)WabItems.HANG_GLIDER.get())).pattern("FFF").pattern("###").pattern(" F ").define(Character.valueOf('F'), (ItemLike)WabItems.GLIDER_FEATHER.get()).define(Character.valueOf('#'), (ItemLike)Items.STICK).unlockedBy(WabRecipeGenerator.getHasName((ItemLike)((ItemLike)WabItems.GLIDER_FEATHER.get())), WabRecipeGenerator.has((ItemLike)((ItemLike)WabItems.GLIDER_FEATHER.get()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)WabItems.SURFER_ARMOR.get())).pattern("#  ").pattern("###").pattern(" # ").define(Character.valueOf('#'), (ItemLike)Items.TURTLE_SCUTE).unlockedBy(WabRecipeGenerator.getHasName((ItemLike)Items.TURTLE_SCUTE), WabRecipeGenerator.has((ItemLike)Items.TURTLE_SCUTE)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)WabBlocks.NEST.get())).pattern("# #").pattern("###").define(Character.valueOf('#'), (ItemLike)WabBlocks.STRAW_BLOCK.get()).unlockedBy(WabRecipeGenerator.getHasName((ItemLike)((ItemLike)WabBlocks.STRAW_BLOCK.get())), WabRecipeGenerator.has((ItemLike)((ItemLike)WabBlocks.STRAW_BLOCK.get()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)WabBlocks.STRAW_BLOCK.get())).pattern("W#W").pattern("#W#").pattern("W#W").define(Character.valueOf('W'), (ItemLike)Items.WHEAT).define(Character.valueOf('#'), (ItemLike)Items.STICK).unlockedBy(WabRecipeGenerator.getHasName((ItemLike)Items.WHEAT), WabRecipeGenerator.has((ItemLike)Items.WHEAT)).save(output);
        WabRecipeGenerator.coloredHangGlider(output, (HangGlider)((Object)WabItems.WHITE_HANG_GLIDER.get()), (ItemLike)Items.WHITE_DYE);
        WabRecipeGenerator.coloredHangGlider(output, (HangGlider)((Object)WabItems.LIGHT_GRAY_HANG_GLIDER.get()), (ItemLike)Items.LIGHT_GRAY_DYE);
        WabRecipeGenerator.coloredHangGlider(output, (HangGlider)((Object)WabItems.GRAY_HANG_GLIDER.get()), (ItemLike)Items.GRAY_DYE);
        WabRecipeGenerator.coloredHangGlider(output, (HangGlider)((Object)WabItems.BLACK_HANG_GLIDER.get()), (ItemLike)Items.BLACK_DYE);
        WabRecipeGenerator.coloredHangGlider(output, (HangGlider)((Object)WabItems.BROWN_HANG_GLIDER.get()), (ItemLike)Items.BROWN_DYE);
        WabRecipeGenerator.coloredHangGlider(output, (HangGlider)((Object)WabItems.RED_HANG_GLIDER.get()), (ItemLike)Items.RED_DYE);
        WabRecipeGenerator.coloredHangGlider(output, (HangGlider)((Object)WabItems.ORANGE_HANG_GLIDER.get()), (ItemLike)Items.ORANGE_DYE);
        WabRecipeGenerator.coloredHangGlider(output, (HangGlider)((Object)WabItems.YELLOW_HANG_GLIDER.get()), (ItemLike)Items.YELLOW_DYE);
        WabRecipeGenerator.coloredHangGlider(output, (HangGlider)((Object)WabItems.LIME_HANG_GLIDER.get()), (ItemLike)Items.LIME_DYE);
        WabRecipeGenerator.coloredHangGlider(output, (HangGlider)((Object)WabItems.GREEN_HANG_GLIDER.get()), (ItemLike)Items.GREEN_DYE);
        WabRecipeGenerator.coloredHangGlider(output, (HangGlider)((Object)WabItems.LIGHT_BLUE_HANG_GLIDER.get()), (ItemLike)Items.LIGHT_BLUE_DYE);
        WabRecipeGenerator.coloredHangGlider(output, (HangGlider)((Object)WabItems.CYAN_HANG_GLIDER.get()), (ItemLike)Items.CYAN_DYE);
        WabRecipeGenerator.coloredHangGlider(output, (HangGlider)((Object)WabItems.BLUE_HANG_GLIDER.get()), (ItemLike)Items.BLUE_DYE);
        WabRecipeGenerator.coloredHangGlider(output, (HangGlider)((Object)WabItems.PURPLE_HANG_GLIDER.get()), (ItemLike)Items.PURPLE_DYE);
        WabRecipeGenerator.coloredHangGlider(output, (HangGlider)((Object)WabItems.MAGENTA_HANG_GLIDER.get()), (ItemLike)Items.MAGENTA_DYE);
        WabRecipeGenerator.coloredHangGlider(output, (HangGlider)((Object)WabItems.PINK_HANG_GLIDER.get()), (ItemLike)Items.PINK_DYE);
    }

    protected static void stair(RecipeOutput output, ItemLike stair, ItemLike block) {
        WabRecipeGenerator.stairBuilder((ItemLike)stair, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{block})).unlockedBy(WabRecipeGenerator.getHasName((ItemLike)block), WabRecipeGenerator.has((ItemLike)block)).save(output);
    }

    protected static void foodCooking(RecipeOutput output, ItemLike rawFood, ItemLike cookedFood) {
        WabRecipeGenerator.foodSmelting(output, rawFood, cookedFood);
        WabRecipeGenerator.foodSmoking(output, rawFood, cookedFood);
        WabRecipeGenerator.foodCampfire(output, rawFood, cookedFood);
    }

    protected static void foodSmelting(RecipeOutput output, ItemLike rawFood, ItemLike cookedFood) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{rawFood}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)cookedFood, (float)0.35f, (int)200).unlockedBy(WabRecipeGenerator.getHasName((ItemLike)rawFood), WabRecipeGenerator.has((ItemLike)rawFood)).save(output);
    }

    protected static void foodSmoking(RecipeOutput output, ItemLike rawFood, ItemLike cookedFood) {
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{rawFood}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)cookedFood, (float)0.35f, (int)100).unlockedBy(WabRecipeGenerator.getHasName((ItemLike)rawFood), WabRecipeGenerator.has((ItemLike)rawFood)).save(output, WabRecipeGenerator.getFromConversionRecipeName(cookedFood, "smoking"));
    }

    protected static void foodCampfire(RecipeOutput output, ItemLike rawFood, ItemLike cookedFood) {
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{rawFood}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)cookedFood, (float)0.35f, (int)600).unlockedBy(WabRecipeGenerator.getHasName((ItemLike)rawFood), WabRecipeGenerator.has((ItemLike)rawFood)).save(output, WabRecipeGenerator.getFromConversionRecipeName(cookedFood, "campfire_cooking"));
    }

    protected static void trimSmithing(RecipeOutput output, Item item) {
        WabRecipeGenerator.trimSmithing((RecipeOutput)output, (Item)item, (ResourceLocation)WabRecipeGenerator.getConversionRecipeName((ItemLike)item, "smithing_trim"));
    }

    protected static void ancientSmithing(RecipeOutput output, RecipeCategory category, ItemLike base, ItemLike addition, Item item) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)WabItems.ANCIENT_UPGRADE_SMITHING_TEMPLATE.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{base}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{addition}), (RecipeCategory)category, (Item)item).unlocks("has_netherite_ingot", WabRecipeGenerator.has((ItemLike)addition)).save(output, WabRecipeGenerator.getConversionRecipeName((ItemLike)item, "smithing"));
    }

    protected static void coloredHangGlider(RecipeOutput output, HangGlider item, ItemLike dye) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)item).requires(WabTags.Items.HANG_GLIDERS).requires(dye).unlockedBy("hang_glider", WabRecipeGenerator.has(WabTags.Items.HANG_GLIDERS)).save(output);
    }

    protected static ResourceLocation getFromConversionRecipeName(ItemLike item, String method) {
        return WabRecipeGenerator.getConversionRecipeName(item, "from_" + method);
    }

    protected static ResourceLocation getConversionRecipeName(ItemLike item, String method) {
        return WanAncientBeasts.resource(WabRecipeGenerator.getItemName((ItemLike)item) + "_" + method);
    }
}

