/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.entity.goals.surfer;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;
import net.wanmine.wab.entity.Surfer;

public class SurferRandomStrollGoal
extends RandomStrollGoal {
    public static final int MIN_TIME_WHEN_CAN_RELAX = -2400;
    private final Surfer surfer;
    private boolean searchingRelaxingPlace = false;

    public SurferRandomStrollGoal(Surfer surfer, double speedFactor, int interval) {
        super((PathfinderMob)surfer, speedFactor, interval);
        this.surfer = surfer;
    }

    public boolean canUse() {
        return this.surfer.isAwake() && super.canUse();
    }

    public boolean canContinueToUse() {
        return this.surfer.isAwake() && super.canContinueToUse();
    }

    @Nullable
    protected Vec3 getPosition() {
        Vec3 pos = null;
        if (this.mob.isInWaterOrBubble()) {
            if (this.shouldGoOnLand()) {
                Vec3 landPos = LandRandomPos.getPos((PathfinderMob)this.mob, (int)24, (int)8);
                if (landPos != null) {
                    pos = landPos;
                    this.searchingRelaxingPlace = true;
                } else {
                    pos = BehaviorUtils.getRandomSwimmablePos((PathfinderMob)this.mob, (int)16, (int)6);
                }
            } else {
                pos = BehaviorUtils.getRandomSwimmablePos((PathfinderMob)this.mob, (int)10, (int)6);
            }
        } else if (this.shouldGoOnWater()) {
            BlockPos waterPos = BlockPos.findClosestMatch((BlockPos)this.mob.blockPosition(), (int)16, (int)1, position -> this.mob.level().isWaterAt(position)).orElse(null);
            pos = waterPos != null ? waterPos.getCenter() : LandRandomPos.getPos((PathfinderMob)this.mob, (int)16, (int)7);
        } else if (this.shouldRelax()) {
            this.surfer.setRelaxingTime(this.surfer.getRandom().nextInt(1800, 3000));
            this.searchingRelaxingPlace = false;
        } else {
            pos = LandRandomPos.getPos((PathfinderMob)this.mob, (int)10, (int)7);
        }
        return pos;
    }

    public boolean shouldGoOnLand() {
        return this.surfer.level().isDay() && !this.surfer.level().isRaining() && this.surfer.getRandom().nextInt(9600) < -(this.surfer.getRelaxingTime() - -2400);
    }

    public boolean shouldGoOnWater() {
        return !this.surfer.level().isDay() || this.surfer.level().isRaining() || !this.searchingRelaxingPlace && this.surfer.getRandom().nextInt(3) == 0;
    }

    public boolean shouldRelax() {
        return this.surfer.level().canSeeSky(this.surfer.blockPosition()) && this.surfer.getRandom().nextInt(3) == 0;
    }
}

