/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.entity.goals.surfer;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import net.wanmine.wab.entity.Surfer;
import net.wanmine.wab.init.world.WabSounds;

public class SurferPanicGoal
extends PanicGoal {
    private final Surfer surfer;

    public SurferPanicGoal(Surfer surfer, double speedModifier) {
        super((PathfinderMob)surfer, speedModifier);
        this.surfer = surfer;
    }

    public void start() {
        super.start();
        this.surfer.setRunning(true);
        if (this.surfer.isApproachingPlayer()) {
            this.surfer.playSound(WabSounds.SURFER_ROAR.get(this.surfer.isBaby()));
        }
    }

    public void stop() {
        super.stop();
        this.surfer.setRunning(false);
    }

    public boolean canUse() {
        return super.canUse() && this.surfer.isAwake();
    }

    protected boolean findRandomPosition() {
        Vec3 pos = null;
        if (this.mob.isInWaterOrBubble()) {
            pos = BehaviorUtils.getRandomSwimmablePos((PathfinderMob)this.mob, (int)16, (int)7);
        } else {
            BlockPos blockPos = this.lookForWater((BlockGetter)this.mob.level(), (Entity)this.mob, 24);
            if (blockPos != null) {
                pos = blockPos.getCenter();
            }
        }
        if (pos != null) {
            this.posX = pos.x;
            this.posY = pos.y;
            this.posZ = pos.z;
            return true;
        }
        return super.findRandomPosition();
    }

    protected boolean shouldPanic() {
        return super.shouldPanic() || this.surfer.isApproachingPlayer();
    }
}

