/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.entity.goals.eater;

import net.minecraft.world.entity.ai.goal.Goal;
import net.wanmine.wab.entity.Eater;

public class EaterSleepingGoal
extends Goal {
    private final Eater entity;
    private int ticksLeft = -1;

    public EaterSleepingGoal(Eater entity) {
        this.entity = entity;
    }

    public void start() {
        this.ticksLeft = 16;
        this.entity.setState(Eater.State.START_SLEEP);
    }

    public void stop() {
        this.entity.setSleepingTime(-1);
    }

    public void tick() {
        if (this.entity.getSleepingTime() == 0) {
            this.entity.setState(Eater.State.WAKE_UP);
        } else {
            this.entity.setSleepingTime(this.entity.getSleepingTime() - 1);
        }
        if (this.ticksLeft >= 0 && this.entity.getState() == Eater.State.WAKE_UP) {
            this.ticksLeft = -1;
        }
        if (this.ticksLeft == 0 && this.entity.getState() == Eater.State.START_SLEEP) {
            this.entity.setState(Eater.State.SLEEP);
            this.entity.setSleepingTime(600 + (int)(Math.random() * 1800.0));
        } else if (this.ticksLeft == -32 && this.entity.getState() == Eater.State.WAKE_UP) {
            this.entity.setState(Eater.State.IDLE);
            this.entity.setNomCount(0);
        } else if (this.ticksLeft != 0) {
            --this.ticksLeft;
        }
    }

    public boolean canContinueToUse() {
        return this.entity.getState() != Eater.State.IDLE;
    }

    public boolean canUse() {
        return this.entity.shouldBeSleeping();
    }
}

