/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.entity.goals.eater;

import javax.annotation.Nonnull;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.wanmine.wab.entity.Eater;

public class EaterMeleeAttackGoal
extends MeleeAttackGoal {
    public EaterMeleeAttackGoal(Eater entity, double speedModifier, boolean followingTargetEvenIfNotSeen) {
        super((PathfinderMob)entity, speedModifier, followingTargetEvenIfNotSeen);
    }

    protected void checkAndPerformAttack(@Nonnull LivingEntity enemy) {
        if (this.canPerformAttack(enemy)) {
            this.getEater().setState(Eater.State.BITE);
            this.resetAttackCooldown();
        }
    }

    protected boolean isTimeToAttack() {
        return this.getEater().getState() != Eater.State.BITE;
    }

    protected int getTicksUntilNextAttack() {
        return this.getEater().attackTick;
    }

    public void start() {
        super.start();
        this.getEater().setRunning(true);
    }

    public void stop() {
        super.stop();
        this.getEater().setRunning(false);
    }

    protected void resetAttackCooldown() {
        this.getEater().attackTick = 40;
    }

    public Eater getEater() {
        return (Eater)this.mob;
    }
}

