/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.enchantment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3;

public record BloodThirst(LevelBasedValue damage) implements EnchantmentEntityEffect
{
    public static final MapCodec<BloodThirst> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LevelBasedValue.CODEC.fieldOf("damage").forGetter(BloodThirst::damage)).apply((Applicative)instance, BloodThirst::new));

    public void apply(ServerLevel serverLevel, int level, EnchantedItemInUse enchantedItemInUse, Entity entity, Vec3 vec3) {
        LivingEntity attacker = enchantedItemInUse.owner();
        if (attacker != null && !attacker.getActiveEffects().isEmpty() && entity.isAlive()) {
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                entity.hurt(player.damageSources().playerAttack(player), this.damage.calculate(level));
            } else {
                entity.hurt(attacker.damageSources().mobAttack(attacker), this.damage.calculate(level));
            }
        }
    }

    public MapCodec<? extends EnchantmentEntityEffect> codec() {
        return CODEC;
    }
}

