/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.block;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.wanmine.wab.init.data.WabAttachments;
import net.wanmine.wab.init.data.WabDamageType;
import net.wanmine.wab.init.data.WabTriggers;
import net.wanmine.wab.init.data.attachment.QuickSandAttachment;
import org.jetbrains.annotations.Nullable;

public class QuickSand
extends PowderSnowBlock {
    private static final VoxelShape FALLING_COLLISION_SHAPE = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.9f, (double)1.0);
    public final Supplier<SolidBucketItem> bucket;
    public final int color;

    public QuickSand(Supplier<SolidBucketItem> bucket, int color, BlockBehaviour.Properties properties) {
        super(properties);
        this.bucket = bucket;
        this.color = color;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!(entity instanceof LivingEntity) || entity.level().getBlockState(entity.blockPosition()).is((Block)this)) {
            entity.makeStuckInBlock(state, new Vec3((double)0.9f, 1.5, (double)0.9f));
        }
        if (BlockPos.containing((Position)entity.getEyePosition()).equals((Object)pos)) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                ((PlayerTrigger)WabTriggers.QUICK_SAND_FALL.get()).trigger(player);
            }
            if (((QuickSandAttachment)entity.getData(WabAttachments.QUICKSAND)).getLastTick() != entity.level().getGameTime()) {
                ((QuickSandAttachment)entity.getData(WabAttachments.QUICKSAND)).addTickInQuicksand(entity.level().getGameTime());
                entity.setAirSupply(Math.max(0, entity.getAirSupply() - 6));
                if (entity.getAirSupply() <= 0) {
                    entity.hurt(WabDamageType.damageSource((LevelReader)level, WabDamageType.QUICK_SAND), 1.5f);
                }
            }
        }
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entitycollisioncontext;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (entitycollisioncontext = (EntityCollisionContext)context).getEntity()) != null) {
            if (entity.fallDistance > 2.5f) {
                return FALLING_COLLISION_SHAPE;
            }
            if (entity instanceof FallingBlockEntity) {
                return super.getCollisionShape(state, getter, pos, context);
            }
        }
        return Shapes.empty();
    }

    public ItemStack pickupBlock(@Nullable Player player, LevelAccessor level, BlockPos pos, BlockState state) {
        level.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
        if (!level.isClientSide()) {
            level.levelEvent(2001, pos, Block.getId((BlockState)state));
        }
        return new ItemStack((ItemLike)this.bucket.get());
    }

    public Optional<SoundEvent> getPickupSound() {
        return Optional.of(SoundEvents.SAND_BREAK);
    }
}

