/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.wanmine.wab.block.BeastEggBlock;
import net.wanmine.wab.init.world.WabBlocks;
import net.wanmine.wab.init.world.WabEntities;
import net.wanmine.wab.init.world.WabItems;
import org.jetbrains.annotations.NotNull;

public class Nest
extends Block {
    public static final IntegerProperty HATCH = BlockStateProperties.HATCH;
    public static final IntegerProperty COUNT = IntegerProperty.create((String)"count", (int)0, (int)5);
    public static final EnumProperty<Egg> EGG = EnumProperty.create((String)"egg", Egg.class);
    public static final BooleanProperty IS_DECORATIVE = BooleanProperty.create((String)"is_decorative");

    public Nest(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HATCH, (Comparable)Integer.valueOf(0))).setValue(EGG, (Comparable)((Object)Egg.NONE))).setValue((Property)IS_DECORATIVE, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext placeContext) {
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)COUNT, (Comparable)Integer.valueOf(0))).setValue((Property)HATCH, (Comparable)Integer.valueOf(0))).setValue(EGG, (Comparable)((Object)Egg.NONE))).setValue((Property)IS_DECORATIVE, (Comparable)Boolean.valueOf(false));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return ((Egg)((Object)state.getValue(Nest.EGG))).shape;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.add(new Property[]{COUNT, HATCH, EGG, IS_DECORATIVE});
    }

    public boolean isDecorative(BlockState state) {
        return (Boolean)state.getValue((Property)IS_DECORATIVE);
    }

    public int getHatchLevel(BlockState state) {
        return (Integer)state.getValue((Property)HATCH);
    }

    private boolean isReadyToHatch(BlockState state) {
        return this.getHatchLevel(state) == 2;
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Egg egg = (Egg)((Object)state.getValue(EGG));
        if (egg == Egg.NONE) {
            Egg newEgg = Egg.getByItem(itemStack.getItem());
            if (newEgg != Egg.NONE) {
                if (!player.getAbilities().instabuild) {
                    itemStack.shrink(1);
                }
                this.setEgg(state, level, pos, newEgg);
                level.playSound(player, pos, SoundEvents.METAL_PLACE, SoundSource.BLOCKS);
                if (level.isClientSide) {
                    ParticleUtils.spawnParticlesOnBlockFaces((Level)level, (BlockPos)pos, (ParticleOptions)ParticleTypes.EGG_CRACK, (IntProvider)UniformInt.of((int)3, (int)6));
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        } else {
            if (itemStack.is(egg.item.get()) && (Integer)state.getValue((Property)COUNT) < egg.maxCount && (Integer)state.getValue((Property)HATCH) == 0) {
                if (!player.getAbilities().instabuild) {
                    itemStack.shrink(1);
                }
                level.setBlock(pos, (BlockState)state.setValue((Property)COUNT, (Comparable)Integer.valueOf((Integer)state.getValue((Property)COUNT) + 1)), 2);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (itemStack.is((Item)WabItems.CHISEL.get()) && !this.isDecorative(state)) {
                if (!player.getAbilities().instabuild) {
                    itemStack.hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                }
                level.setBlock(pos, (BlockState)state.setValue((Property)IS_DECORATIVE, (Comparable)Boolean.valueOf(true)), 2);
                level.playSound(player, pos, SoundEvents.METAL_HIT, SoundSource.BLOCKS);
                if (level.isClientSide) {
                    ParticleUtils.spawnParticlesOnBlockFaces((Level)level, (BlockPos)pos, (ParticleOptions)ParticleTypes.WAX_ON, (IntProvider)UniformInt.of((int)3, (int)6));
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return ItemInteractionResult.FAIL;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource source) {
        if (!this.isDecorative(state)) {
            if (!this.isReadyToHatch(state)) {
                level.playSound((Player)null, pos, SoundEvents.SNIFFER_EGG_CRACK, SoundSource.BLOCKS, 0.7f, 0.9f + source.nextFloat() * 0.2f);
                level.setBlock(pos, (BlockState)state.setValue((Property)HATCH, (Comparable)Integer.valueOf(this.getHatchLevel(state) + 1)), 2);
            } else {
                level.playSound((Player)null, pos, SoundEvents.SNIFFER_EGG_HATCH, SoundSource.BLOCKS, 0.7f, 0.9f + source.nextFloat() * 0.2f);
                this.setEgg(state, (Level)level, pos, Egg.NONE);
                EntityType<? extends LivingEntity> entityType = ((Egg)((Object)state.getValue(Nest.EGG))).entity.get();
                if (entityType != null) {
                    for (int i = 0; i < (Integer)state.getValue((Property)COUNT); ++i) {
                        LivingEntity entity = (LivingEntity)entityType.create((Level)level);
                        if (entity == null) continue;
                        Vec3 vec3 = pos.getCenter();
                        if (entity instanceof AgeableMob) {
                            AgeableMob mob = (AgeableMob)entity;
                            mob.setBaby(true);
                        }
                        entity.moveTo(vec3.x(), vec3.y(), vec3.z(), Mth.wrapDegrees((float)(level.random.nextFloat() * 360.0f)), 0.0f);
                        level.addFreshEntity((Entity)entity);
                    }
                }
            }
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.is(newState.getBlock())) {
            this.setHatchTick((Egg)((Object)newState.getValue(EGG)), level, pos);
        } else {
            ItemEntity itementity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, ((Egg)((Object)state.getValue(EGG))).getItemStack((Integer)state.getValue((Property)COUNT)));
            itementity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itementity);
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    public void setEgg(BlockState state, Level level, BlockPos pos, Egg egg) {
        if (egg == Egg.NONE) {
            level.setBlock(pos, (BlockState)((BlockState)((BlockState)state.setValue(EGG, (Comparable)((Object)egg))).setValue((Property)COUNT, (Comparable)Integer.valueOf(0))).setValue((Property)HATCH, (Comparable)Integer.valueOf(0)), 3);
        } else {
            level.setBlock(pos, (BlockState)((BlockState)state.setValue(EGG, (Comparable)((Object)egg))).setValue((Property)COUNT, (Comparable)Integer.valueOf(1)), 2);
        }
    }

    protected void setHatchTick(Egg egg, Level level, BlockPos pos) {
        if (egg.hatchTicks > 0) {
            level.scheduleTick(pos, (Block)this, egg.hatchTicks + level.random.nextInt(300));
        }
    }

    public boolean isPathfindable(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType pathComputationType) {
        return false;
    }

    public static enum Egg implements StringRepresentable
    {
        NONE("none", () -> Items.AIR, Block.box((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0), 0, 0, () -> null),
        CHICKEN("chicken", () -> Items.EGG, Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0), 5, 0, () -> EntityType.CHICKEN),
        TURTLE("turtle", () -> Items.TURTLE_EGG, Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0), 4, 12000, () -> EntityType.TURTLE),
        SNIFFER("sniffer", () -> Items.SNIFFER_EGG, Block.box((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)14.0), 1, 2200, () -> EntityType.SNIFFER),
        EATER("eater", () -> ((BeastEggBlock)((Object)((Object)WabBlocks.EATER_EGG.get()))).asItem(), BeastEggBlock.EATER_EGG_SHAPE, 1, 2200, () -> WabEntities.EATER.get()),
        WALKER("walker", () -> ((BeastEggBlock)((Object)((Object)WabBlocks.WALKER_EGG.get()))).asItem(), BeastEggBlock.WALKER_EGG_SHAPE, 1, 2200, () -> WabEntities.WALKER.get()),
        CRUSHER("crusher", () -> ((BeastEggBlock)((Object)((Object)WabBlocks.CRUSHER_EGG.get()))).asItem(), BeastEggBlock.CRUSHER_EGG_SHAPE, 1, 2200, () -> WabEntities.CRUSHER.get()),
        GLIDER("glider", () -> ((BeastEggBlock)((Object)((Object)WabBlocks.GLIDER_EGG.get()))).asItem(), BeastEggBlock.GLIDER_EGG_SHAPE, 1, 2200, () -> WabEntities.GLIDER.get()),
        SOARER("soarer", () -> ((BeastEggBlock)((Object)((Object)WabBlocks.SOARER_EGG.get()))).asItem(), BeastEggBlock.SOARER_EGG_SHAPE, 1, 2200, () -> WabEntities.SOARER.get()),
        SURFER("surfer", () -> ((BeastEggBlock)((Object)((Object)WabBlocks.SURFER_EGG.get()))).asItem(), BeastEggBlock.SURFER_EGG_SHAPE, 1, 2200, () -> WabEntities.SURFER.get());

        public final VoxelShape NEST_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0);
        private final String name;
        public final Supplier<Item> item;
        public final VoxelShape shape;
        public final int maxCount;
        public final int hatchTicks;
        public final Supplier<EntityType<? extends LivingEntity>> entity;

        private Egg(String name, Supplier<Item> item, VoxelShape shape, int maxCount, int hatchTicks, Supplier<EntityType<? extends LivingEntity>> entity) {
            this.name = name;
            this.item = item;
            this.shape = Shapes.or((VoxelShape)this.NEST_SHAPE, (VoxelShape)shape);
            this.maxCount = maxCount;
            this.hatchTicks = hatchTicks;
            this.entity = entity;
        }

        public static Egg getByItem(Item item) {
            for (Egg egg : Egg.values()) {
                if (egg.item.get() != item) continue;
                return egg;
            }
            return NONE;
        }

        public ItemStack getItemStack(int count) {
            return new ItemStack((ItemLike)this.item.get(), count);
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }
    }
}

