/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.wanmine.wab.block.entity.AncientSkullEntity;
import net.wanmine.wab.init.world.WabBlocks;
import org.jetbrains.annotations.Nullable;

public class AncientSkull
extends BaseEntityBlock {
    public static final MapCodec<AncientSkull> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Type.CODEC.fieldOf("type").forGetter(AncientSkull::type), (App)AncientSkull.propertiesCodec()).apply((Applicative)builder, AncientSkull::new));
    public static final int ROTATIONS = RotationSegment.getMaxSegmentIndex() + 1;
    public static final IntegerProperty ROTATION = BlockStateProperties.ROTATION_16;
    public static final BooleanProperty ON_WALL = BooleanProperty.create((String)"on_wall");
    protected final Type type;

    public AncientSkull(Type type, BlockBehaviour.Properties properties) {
        super(properties);
        this.type = type;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ROTATION, (Comparable)Integer.valueOf(0))).setValue((Property)ON_WALL, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new AncientSkullEntity(this.type, blockPos, blockState);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.getValue((Property)ON_WALL)).booleanValue()) {
            return this.type.getWallShape((Integer)state.getValue((Property)ROTATION) / 4 * 90);
        }
        return this.type.shape;
    }

    public BlockState getStateForPlacement(BlockPlaceContext placeContext) {
        if (placeContext.getClickedFace().getAxis() == Direction.Axis.Y) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)ROTATION, (Comparable)Integer.valueOf(RotationSegment.convertToSegment((float)placeContext.getRotation())))).setValue((Property)ON_WALL, (Comparable)Boolean.valueOf(false));
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)ROTATION, (Comparable)Integer.valueOf((int)(placeContext.getClickedFace().getOpposite().toYRot() / 90.0f) * 4))).setValue((Property)ON_WALL, (Comparable)Boolean.valueOf(true));
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)ROTATION, (Comparable)Integer.valueOf(rotation.rotate(((Integer)state.getValue((Property)ROTATION)).intValue(), ROTATIONS)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)ROTATION, (Comparable)Integer.valueOf(mirror.mirror(((Integer)state.getValue((Property)ROTATION)).intValue(), ROTATIONS)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_56329_) {
        p_56329_.add(new Property[]{ROTATION, ON_WALL});
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public boolean isPathfindable(BlockState blockState, BlockGetter getter, BlockPos pos, PathComputationType computationType) {
        return false;
    }

    public Type type() {
        return this.type;
    }

    public static enum Type implements StringRepresentable
    {
        SNIFFER("sniffer", (Supplier<BlockEntityType<AncientSkullEntity>>)WabBlocks.Entities.SNIFFER_SKULL, Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), Block.box((double)2.0, (double)1.0, (double)0.0, (double)14.0, (double)14.0, (double)16.0)),
        EATER("eater", (Supplier<BlockEntityType<AncientSkullEntity>>)WabBlocks.Entities.EATER_SKULL, Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)),
        WALKER("walker", (Supplier<BlockEntityType<AncientSkullEntity>>)WabBlocks.Entities.WALKER_SKULL, Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)),
        CRUSHER("crusher", (Supplier<BlockEntityType<AncientSkullEntity>>)WabBlocks.Entities.CRUSHER_SKULL, Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0), Block.box((double)3.0, (double)3.0, (double)4.0, (double)13.0, (double)13.0, (double)16.0)),
        GLIDER("glider", (Supplier<BlockEntityType<AncientSkullEntity>>)WabBlocks.Entities.GLIDER_SKULL, Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0), Block.box((double)5.0, (double)5.0, (double)2.0, (double)11.0, (double)11.0, (double)16.0)),
        SOARER("soarer", (Supplier<BlockEntityType<AncientSkullEntity>>)WabBlocks.Entities.SOARER_SKULL, Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)11.0, (double)13.0), Block.box((double)3.0, (double)2.0, (double)0.0, (double)13.0, (double)13.0, (double)16.0)),
        CHARGER("charger", (Supplier<BlockEntityType<AncientSkullEntity>>)WabBlocks.Entities.CHARGER_SKULL, Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0), Block.box((double)2.0, (double)2.0, (double)1.0, (double)14.0, (double)15.0, (double)16.0)),
        SURFER("surfer", (Supplier<BlockEntityType<AncientSkullEntity>>)WabBlocks.Entities.SURFER_SKULL, Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0), Block.box((double)3.0, (double)4.0, (double)0.0, (double)13.0, (double)12.0, (double)16.0)),
        RAIDER("raider", (Supplier<BlockEntityType<AncientSkullEntity>>)WabBlocks.Entities.RAIDER_SKULL, Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)15.0, (double)13.0), Block.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)15.0, (double)16.0));

        public static final StringRepresentable.EnumCodec<Type> CODEC;
        public final String name;
        public final Supplier<BlockEntityType<AncientSkullEntity>> entity;
        public final VoxelShape shape;
        public final VoxelShape wallShape;

        private Type(String name, Supplier<BlockEntityType<AncientSkullEntity>> entity, VoxelShape shape, VoxelShape wallShape) {
            this.name = name;
            this.entity = entity;
            this.shape = shape;
            this.wallShape = wallShape;
        }

        public VoxelShape getWallShape(int rotation) {
            VoxelShape shape = this.wallShape;
            for (int i = 0; i < rotation / 90; ++i) {
                shape = Type.rotate90(shape);
            }
            return shape;
        }

        private static VoxelShape rotate90(VoxelShape shape) {
            VoxelShape rotated = Shapes.empty();
            for (AABB box : shape.toAabbs()) {
                AABB newBox = new AABB(1.0 - box.maxZ, box.minY, box.minX, 1.0 - box.minZ, box.maxY, box.maxX);
                rotated = Shapes.or((VoxelShape)rotated, (VoxelShape)Shapes.create((AABB)newBox));
            }
            return rotated;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
        }
    }
}

