/*
 * Decompiled with CFR 0.152.
 */
package net.ramixin.visibletraders.mixins;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.ramixin.visibletraders.VillagerDuck;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Villager.class})
public abstract class VillagerMixin
extends AbstractVillager
implements ReputationEventHandler,
VillagerDataHolder,
VillagerDuck {
    @Unique
    private static final Logger visibleTraders_NeoForge$visibleTradersLogger = LoggerFactory.getLogger((String)"Visible Traders");
    @Unique
    private List<MerchantOffers> visibleTraders_NeoForge$lockedOffers = null;
    @Unique
    private MerchantOffer visibleTraders_NeoForge$cachedTrade = null;
    @Unique
    private int visibleTraders_NeoForge$prevLevel = 0;

    @Shadow
    public abstract @NonNull VillagerData getVillagerData();

    @Shadow
    public abstract void setVillagerData(@NonNull VillagerData var1);

    @Shadow
    public abstract void updateTrades();

    @Shadow
    public abstract void onReputationEventFrom(@NonNull ReputationEventType var1, @NonNull Entity var2);

    public VillagerMixin(EntityType<? extends AbstractVillager> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="HEAD")})
    private void writeOfferingLevel(CompoundTag compoundTag, CallbackInfo ci) {
        if (this.visibleTraders_NeoForge$lockedOffers == null) {
            return;
        }
        DataResult val = Codec.list((Codec)MerchantOffers.CODEC).encodeStart((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), this.visibleTraders_NeoForge$lockedOffers);
        if (val.isError()) {
            visibleTraders_NeoForge$visibleTradersLogger.error(((DataResult.Error)val.error().get()).toString());
        } else {
            compoundTag.put("LockedOffers", (Tag)val.getOrThrow());
        }
    }

    @Unique
    private void visibleTraders_NeoForge$lockedTradesTick() {
        int size;
        int level;
        this.visibleTraders_NeoForge$prevLevel = level = this.getVillagerData().getLevel();
        if (this.offers == null) {
            this.visibleTraders_NeoForge$lockedOffers = null;
            return;
        }
        if (this.visibleTraders_NeoForge$cachedTrade == null || this.offers.isEmpty()) {
            this.visibleTraders_NeoForge$lockedOffers = null;
            if (!this.offers.isEmpty()) {
                this.visibleTraders_NeoForge$cachedTrade = (MerchantOffer)this.offers.getFirst();
            }
            return;
        }
        if (this.visibleTraders_NeoForge$cachedTrade != this.offers.getFirst()) {
            this.visibleTraders_NeoForge$lockedOffers = null;
            this.visibleTraders_NeoForge$cachedTrade = (MerchantOffer)this.offers.getFirst();
            return;
        }
        if (this.visibleTraders_NeoForge$lockedOffers == null) {
            this.visibleTraders_NeoForge$lockedOffers = new ArrayList<MerchantOffers>();
        }
        if ((size = this.visibleTraders_NeoForge$lockedOffers.size()) + level == 5) {
            return;
        }
        if (size > 0 && size + level > 5) {
            this.visibleTraders_NeoForge$lockedOffers.removeFirst();
            return;
        }
        VillagerData data = this.getVillagerData();
        this.setVillagerData(data.setLevel(data.getLevel() + size + 1));
        int prev = this.offers.size();
        this.updateTrades();
        int dif = this.offers.size() - prev;
        MerchantOffers newOffers = new MerchantOffers();
        for (int i = 0; i < dif; ++i) {
            newOffers.add((Object)((MerchantOffer)this.offers.removeLast()));
        }
        this.visibleTraders_NeoForge$lockedOffers.add(newOffers);
        this.setVillagerData(data);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void updateLockedTradesOnTick(CallbackInfo ci) {
        if (this.isClientSide()) {
            return;
        }
        if (!this.level().hasChunk((int)(this.getX() / 16.0), (int)(this.getZ() / 16.0))) {
            return;
        }
        this.visibleTraders_NeoForge$lockedTradesTick();
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readOfferingLevel(CompoundTag compoundTag, CallbackInfo ci) {
        if (compoundTag.contains("LockedOffers")) {
            Codec.list((Codec)MerchantOffers.CODEC).parse((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compoundTag.get("LockedOffers")).resultOrPartial(msg -> {
                this.visibleTraders_NeoForge$lockedOffers = new ArrayList<MerchantOffers>();
                visibleTraders_NeoForge$visibleTradersLogger.error(msg);
            }).ifPresent(lockedOffers -> {
                this.visibleTraders_NeoForge$lockedOffers = new ArrayList<MerchantOffers>((Collection<MerchantOffers>)lockedOffers);
            });
        } else {
            this.visibleTraders_NeoForge$lockedOffers = new ArrayList<MerchantOffers>();
        }
        if (this.offers != null && !this.offers.isEmpty()) {
            this.visibleTraders_NeoForge$cachedTrade = (MerchantOffer)this.offers.getFirst();
        }
    }

    @Inject(method={"updateTrades"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventAdditionalTradesOnRankIncrease(CallbackInfo ci) {
        if (this.offers == null) {
            return;
        }
        if (this.visibleTraders_NeoForge$lockedOffers == null) {
            return;
        }
        if (this.visibleTraders_NeoForge$prevLevel != this.getVillagerData().getLevel()) {
            return;
        }
        if (!this.visibleTraders_NeoForge$lockedOffers.isEmpty() && this.visibleTraders_NeoForge$lockedOffers.size() + this.getVillagerData().getLevel() > 5) {
            MerchantOffers newOffers = this.visibleTraders_NeoForge$lockedOffers.removeFirst();
            this.offers.addAll((Collection)newOffers);
            ci.cancel();
        }
    }

    @Inject(method={"increaseMerchantCareer"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/npc/Villager;updateTrades()V")})
    private void updateLastKnownLevelOnCareerIncrease(CallbackInfo ci) {
        this.visibleTraders_NeoForge$prevLevel = this.getVillagerData().getLevel();
    }

    @Override
    public void visibleTraders$forceTradeGeneration() {
        for (int i = 0; i < 5; ++i) {
            this.visibleTraders_NeoForge$lockedTradesTick();
        }
    }

    @Override
    public int visibleTraders$getAvailableOffersCount() {
        if (this.offers == null) {
            return 0;
        }
        return this.offers.size();
    }

    @Override
    public MerchantOffers visibleTraders$getLockedOffers() {
        if (this.visibleTraders_NeoForge$lockedOffers == null) {
            return new MerchantOffers();
        }
        MerchantOffers lockedOffers = new MerchantOffers();
        for (MerchantOffers listOffers : List.copyOf(this.visibleTraders_NeoForge$lockedOffers)) {
            for (MerchantOffer offer : listOffers) {
                if (offer.getResult().isEmpty()) {
                    this.visibleTraders_NeoForge$lockedOffers = new ArrayList<MerchantOffers>();
                    visibleTraders_NeoForge$visibleTradersLogger.error("detected incomplete trade. Rebuilding locked offers");
                    return new MerchantOffers();
                }
                lockedOffers.add((Object)offer);
            }
        }
        return lockedOffers;
    }
}

