/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.level.blocks;

import com.blackgear.vanillabackport.client.registries.ModSoundEvents;
import com.blackgear.vanillabackport.common.level.blockentities.CreakingHeartBlockEntity;
import com.blackgear.vanillabackport.common.level.blocks.blockstates.CreakingHeartState;
import com.blackgear.vanillabackport.common.registries.ModBlockEntities;
import com.blackgear.vanillabackport.common.registries.ModBlockStateProperties;
import com.blackgear.vanillabackport.core.data.tags.ModBlockTags;
import com.blackgear.vanillabackport.core.util.LevelUtils;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class CreakingHeartBlock
extends BaseEntityBlock {
    public static final MapCodec<CreakingHeartBlock> CODEC = CreakingHeartBlock.simpleCodec(CreakingHeartBlock::new);
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;
    public static final EnumProperty<CreakingHeartState> STATE = ModBlockStateProperties.CREAKING_HEART_STATE;
    public static final BooleanProperty NATURAL = ModBlockStateProperties.NATURAL;

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public CreakingHeartBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)Direction.Axis.Y)).setValue(STATE, (Comparable)((Object)CreakingHeartState.UPROOTED))).setValue((Property)NATURAL, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CreakingHeartBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.isClientSide()) {
            return null;
        }
        return state.getValue(STATE) != CreakingHeartState.UPROOTED ? CreakingHeartBlock.createTickerHelper(blockEntityType, ModBlockEntities.CREAKING_HEART.get(), CreakingHeartBlockEntity::serverTick) : null;
    }

    public static boolean isNaturalNight(Level level) {
        return LevelUtils.isMoonVisible(level);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (CreakingHeartBlock.isNaturalNight(level) && state.getValue(STATE) != CreakingHeartState.UPROOTED && random.nextInt(16) == 0 && CreakingHeartBlock.isSurroundedByLogs((LevelAccessor)level, pos)) {
            level.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), ModSoundEvents.CREAKING_HEART_IDLE.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        level.scheduleTick(pos, (Block)this, 1);
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockState updatedState = CreakingHeartBlock.updateState(state, (Level)level, pos);
        if (updatedState != state) {
            level.setBlock(pos, updatedState, 3);
        }
    }

    private static BlockState updateState(BlockState state, Level level, BlockPos pos) {
        boolean isUprooted;
        boolean hasRequiredLogs = CreakingHeartBlock.hasRequiredLogs(state, (LevelReader)level, pos);
        boolean bl = isUprooted = state.getValue(STATE) == CreakingHeartState.UPROOTED;
        return hasRequiredLogs && isUprooted ? (BlockState)state.setValue(STATE, (Comparable)((Object)(CreakingHeartBlock.isNaturalNight(level) ? CreakingHeartState.AWAKE : CreakingHeartState.DORMANT))) : state;
    }

    public static boolean hasRequiredLogs(BlockState state, LevelReader level, BlockPos pos) {
        Direction.Axis axis = (Direction.Axis)state.getValue(AXIS);
        for (Direction direction : CreakingHeartBlock.directions(axis)) {
            BlockPos neighborPos = pos.relative(direction);
            BlockState neighborState = level.getBlockState(neighborPos);
            if (neighborState.is(ModBlockTags.PALE_OAK_LOGS) && neighborState.getValue(AXIS) == axis) continue;
            return false;
        }
        return true;
    }

    private static Direction[] directions(Direction.Axis axis) {
        Direction[] directionArray;
        switch (axis) {
            default: {
                throw new MatchException(null, null);
            }
            case X: {
                Direction[] directionArray2 = new Direction[2];
                directionArray2[0] = Direction.NORTH;
                directionArray = directionArray2;
                directionArray2[1] = Direction.SOUTH;
                break;
            }
            case Y: {
                Direction[] directionArray3 = new Direction[2];
                directionArray3[0] = Direction.UP;
                directionArray = directionArray3;
                directionArray3[1] = Direction.DOWN;
                break;
            }
            case Z: {
                Direction[] directionArray4 = new Direction[2];
                directionArray4[0] = Direction.EAST;
                directionArray = directionArray4;
                directionArray4[1] = Direction.WEST;
            }
        }
        return directionArray;
    }

    private static boolean isSurroundedByLogs(LevelAccessor level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = pos.relative(direction);
            BlockState neighborState = level.getBlockState(neighborPos);
            if (neighborState.is(ModBlockTags.PALE_OAK_LOGS)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return CreakingHeartBlock.updateState((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)context.getClickedFace().getAxis()), context.getLevel(), context.getClickedPos());
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return RotatedPillarBlock.rotatePillar((BlockState)state, (Rotation)rotation);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS, STATE, NATURAL});
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CreakingHeartBlockEntity) {
            CreakingHeartBlockEntity heart = (CreakingHeartBlockEntity)blockEntity;
            heart.removeProtector(player.damageSources().playerAttack(player));
            this.tryAwardExperience(player, state, level, pos);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    private void tryAwardExperience(Player player, BlockState state, Level level, BlockPos pos) {
        if (!player.getAbilities().instabuild && !player.isSpectator() && ((Boolean)state.getValue((Property)NATURAL)).booleanValue() && level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            this.popExperience(server, pos, level.random.nextIntBetweenInclusive(20, 24));
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        int n;
        if (state.getValue(STATE) == CreakingHeartState.UPROOTED) {
            return 0;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CreakingHeartBlockEntity) {
            CreakingHeartBlockEntity heart = (CreakingHeartBlockEntity)blockEntity;
            n = heart.getAnalogOutputSignal();
        } else {
            n = 0;
        }
        return n;
    }
}

