/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.level.blockentities;

import com.blackgear.vanillabackport.client.level.particles.particleoptions.TrailParticleOption;
import com.blackgear.vanillabackport.client.registries.ModParticles;
import com.blackgear.vanillabackport.client.registries.ModSoundEvents;
import com.blackgear.vanillabackport.common.level.blocks.CreakingHeartBlock;
import com.blackgear.vanillabackport.common.level.blocks.blockstates.CreakingHeartState;
import com.blackgear.vanillabackport.common.level.entities.creaking.Creaking;
import com.blackgear.vanillabackport.common.registries.ModBlockEntities;
import com.blackgear.vanillabackport.common.registries.ModBlocks;
import com.blackgear.vanillabackport.common.registries.ModEntities;
import com.blackgear.vanillabackport.core.VanillaBackport;
import com.blackgear.vanillabackport.core.data.tags.ModBlockTags;
import com.blackgear.vanillabackport.core.util.SpawnExtras;
import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public class CreakingHeartBlockEntity
extends BlockEntity {
    private static final Optional<Creaking> NO_CREAKING = Optional.empty();
    @Nullable
    private Either<Creaking, UUID> creakingInfo;
    private long ticksExisted;
    private int ticker;
    private int emitter;
    @Nullable
    private Vec3 emitterTarget;
    private int outputSignal;

    public CreakingHeartBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.CREAKING_HEART.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CreakingHeartBlockEntity heart) {
        ++heart.ticksExisted;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            int signal = heart.computeAnalogOutputSignal();
            if (heart.outputSignal != signal) {
                heart.outputSignal = signal;
                level.updateNeighbourForOutputSignal(pos, ModBlocks.CREAKING_HEART.get());
            }
            if (heart.emitter > 0) {
                if (heart.emitter > 50) {
                    heart.emitParticles(server, 1, true);
                    heart.emitParticles(server, 1, false);
                }
                if (heart.emitter % 10 == 0 && heart.emitterTarget != null) {
                    heart.getCreakingProtector().ifPresent(creaking -> {
                        heart.emitterTarget = creaking.getBoundingBox().getCenter();
                    });
                    Vec3 center = Vec3.atCenterOf((Vec3i)pos);
                    float emission = 0.2f + 0.8f * (float)(100 - heart.emitter) / 100.0f;
                    Vec3 position = center.subtract(heart.emitterTarget).scale((double)emission).add(heart.emitterTarget);
                    BlockPos target = BlockPos.containing((Position)position);
                    float volume = (float)heart.emitter / 2.0f / 100.0f + 0.5f;
                    level.playSound(null, target, ModSoundEvents.CREAKING_HEART_HURT.get(), SoundSource.BLOCKS, volume, 1.0f);
                }
                --heart.emitter;
            }
            if (heart.ticker-- < 0) {
                heart.ticker = heart.level == null ? 20 : heart.level.random.nextInt(5) + 20;
                BlockState updatedState = CreakingHeartBlockEntity.updateCreakingState(level, state, pos, heart);
                if (updatedState != state) {
                    level.setBlock(pos, updatedState, 3);
                    if (updatedState.getValue(CreakingHeartBlock.STATE) == CreakingHeartState.UPROOTED) {
                        return;
                    }
                }
                if (heart.creakingInfo == null) {
                    Player player;
                    if (updatedState.getValue(CreakingHeartBlock.STATE) == CreakingHeartState.AWAKE && level.getDifficulty() != Difficulty.PEACEFUL && level.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && (player = level.getNearestPlayer((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 32.0, false)) != null && (creaking = CreakingHeartBlockEntity.spawnProtector(server, heart)) != null) {
                        heart.setCreakingInfo(creaking);
                        creaking.playSound(ModSoundEvents.CREAKING_SPAWN.get());
                        level.playSound(null, heart.getBlockPos(), ModSoundEvents.CREAKING_HEART_SPAWN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                } else {
                    Optional<Creaking> protector = heart.getCreakingProtector();
                    if (protector.isPresent()) {
                        creaking = protector.get();
                        if (!CreakingHeartBlock.isNaturalNight(level) && !creaking.isPersistenceRequired() || heart.distanceToCreaking() > 34.0 || creaking.playerIsStuckInYou()) {
                            heart.removeProtector(null);
                        }
                    }
                }
            }
        }
    }

    private static BlockState updateCreakingState(Level level, BlockState state, BlockPos pos, CreakingHeartBlockEntity heart) {
        if (!CreakingHeartBlock.hasRequiredLogs(state, (LevelReader)level, pos) && heart.creakingInfo == null) {
            return (BlockState)state.setValue(CreakingHeartBlock.STATE, (Comparable)((Object)CreakingHeartState.UPROOTED));
        }
        boolean isNaturalNight = CreakingHeartBlock.isNaturalNight(level);
        return (BlockState)state.setValue(CreakingHeartBlock.STATE, (Comparable)((Object)(isNaturalNight ? CreakingHeartState.AWAKE : CreakingHeartState.DORMANT)));
    }

    private double distanceToCreaking() {
        return this.getCreakingProtector().map(creaking -> Math.sqrt(creaking.distanceToSqr(Vec3.atBottomCenterOf((Vec3i)this.getBlockPos())))).orElse(0.0);
    }

    private void clearCreakingInfo() {
        this.creakingInfo = null;
        this.setChanged();
    }

    public void setCreakingInfo(Creaking creaking) {
        this.creakingInfo = Either.left((Object)((Object)creaking));
        this.setChanged();
    }

    public void setCreakingInfo(UUID uuid) {
        this.creakingInfo = Either.right((Object)uuid);
        this.ticksExisted = 0L;
        this.setChanged();
    }

    private Optional<Creaking> getCreakingProtector() {
        Level level;
        if (this.creakingInfo == null) {
            return NO_CREAKING;
        }
        if (this.creakingInfo.left().isPresent()) {
            Creaking creaking = (Creaking)((Object)this.creakingInfo.left().get());
            if (!creaking.isRemoved()) {
                return Optional.of(creaking);
            }
            this.setCreakingInfo(creaking.getUUID());
        }
        if ((level = this.level) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (this.creakingInfo.right().isPresent()) {
                UUID uuid = (UUID)this.creakingInfo.right().get();
                Entity entity = server.getEntity(uuid);
                if (entity instanceof Creaking) {
                    Creaking creaking = (Creaking)entity;
                    this.setCreakingInfo(creaking);
                    return Optional.of(creaking);
                }
                if (this.ticksExisted >= 30L) {
                    this.clearCreakingInfo();
                }
                return NO_CREAKING;
            }
        }
        return NO_CREAKING;
    }

    @Nullable
    private static Creaking spawnProtector(ServerLevel level, CreakingHeartBlockEntity heart) {
        if (!((Boolean)VanillaBackport.COMMON_CONFIG.hasCreaking.get()).booleanValue()) {
            return null;
        }
        BlockPos pos = heart.getBlockPos();
        Optional<Creaking> protector = SpawnExtras.trySpawnMob(ModEntities.CREAKING.get(), MobSpawnType.SPAWNER, level, pos, 5, 16, 8, SpawnExtras.ON_TOP_OF_COLLIDER_NO_LEAVES, true);
        if (protector.isEmpty()) {
            return null;
        }
        Creaking creaking = protector.get();
        level.gameEvent((Entity)creaking, (Holder)GameEvent.ENTITY_PLACE, creaking.position());
        level.broadcastEntityEvent((Entity)creaking, (byte)60);
        creaking.setTransient(pos);
        return creaking;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveCustomOnly(provider);
    }

    public void creakingHurt() {
        Level level;
        Creaking creaking = this.getCreakingProtector().orElse(null);
        if (creaking != null && (level = this.level) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (this.emitter <= 0) {
                this.emitParticles(server, 20, false);
                if (this.getBlockState().getValue(CreakingHeartBlock.STATE) == CreakingHeartState.AWAKE && ((Boolean)VanillaBackport.COMMON_CONFIG.hasResin.get()).booleanValue()) {
                    int i = this.level.getRandom().nextIntBetweenInclusive(2, 3);
                    for (int j = 0; j < i; ++j) {
                        this.spreadResin().ifPresent(pos -> {
                            this.level.playSound(null, pos, ModSoundEvents.RESIN_PLACE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                            this.level.gameEvent((Holder)GameEvent.BLOCK_PLACE, pos, GameEvent.Context.of((BlockState)this.getBlockState()));
                        });
                    }
                }
                this.emitter = 100;
                this.emitterTarget = creaking.getBoundingBox().getCenter();
            }
        }
    }

    private Optional<BlockPos> spreadResin() {
        if (this.level == null) {
            return Optional.empty();
        }
        MutableObject mutable = new MutableObject(null);
        BlockPos.breadthFirstTraversal((BlockPos)this.worldPosition, (int)2, (int)64, (pos, consumer) -> {
            for (Direction direction : Util.shuffledCopy((Object[])Direction.values(), (RandomSource)this.level.getRandom())) {
                BlockPos neighbor = pos.relative(direction);
                if (!this.level.getBlockState(neighbor).is(ModBlockTags.PALE_OAK_LOGS)) continue;
                consumer.accept(neighbor);
            }
        }, arg_0 -> this.lambda$spreadResin$4((Mutable)mutable, arg_0));
        return Optional.ofNullable((BlockPos)mutable.getValue());
    }

    private void emitParticles(ServerLevel level, int count, boolean reverseDirection) {
        Creaking creaking = this.getCreakingProtector().orElse(null);
        if (creaking != null) {
            int color = reverseDirection ? (Integer)VanillaBackport.COMMON_CONFIG.creakingParticleReverseColor.get() : (Integer)VanillaBackport.COMMON_CONFIG.creakingParticleColor.get();
            RandomSource random = level.getRandom();
            for (double i = 0.0; i < (double)count; i += 1.0) {
                AABB creakingBounds = creaking.getBoundingBox();
                Vec3 currentPos = new Vec3(creakingBounds.minX, creakingBounds.minY, creakingBounds.minZ).add(random.nextDouble() * creakingBounds.getXsize(), random.nextDouble() * creakingBounds.getYsize(), random.nextDouble() * creakingBounds.getZsize());
                Vec3 heartPos = Vec3.atLowerCornerOf((Vec3i)this.getBlockPos()).add(random.nextDouble(), random.nextDouble(), random.nextDouble());
                if (reverseDirection) {
                    Vec3 target = currentPos;
                    currentPos = heartPos;
                    heartPos = target;
                }
                TrailParticleOption particle = new TrailParticleOption(heartPos, color, random.nextInt(40) + 10);
                ModParticles.sendParticles(level, particle, true, true, currentPos.x, currentPos.y, currentPos.z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public void removeProtector(@Nullable DamageSource source) {
        Creaking creaking = this.getCreakingProtector().orElse(null);
        if (creaking != null) {
            if (source == null) {
                creaking.tearDown();
            } else {
                creaking.creakingDeathEffects(source);
                creaking.setTearingDown();
                creaking.setHealth(0.0f);
            }
            this.clearCreakingInfo();
        }
    }

    public boolean isProtector(Creaking creaking) {
        return this.getCreakingProtector().map(target -> target == creaking).orElse(false);
    }

    public int getAnalogOutputSignal() {
        return this.outputSignal;
    }

    public int computeAnalogOutputSignal() {
        if (this.creakingInfo != null && this.getCreakingProtector().isPresent()) {
            double distance = this.distanceToCreaking();
            double signalFromDistance = Mth.clamp((double)distance, (double)0.0, (double)32.0) / 32.0;
            return 15 - (int)Math.floor(signalFromDistance * 15.0);
        }
        return 0;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.hasUUID("creaking")) {
            this.setCreakingInfo(tag.getUUID("creaking"));
        } else {
            this.clearCreakingInfo();
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.creakingInfo != null) {
            tag.putUUID("creaking", (UUID)this.creakingInfo.map(Entity::getUUID, uuid -> uuid));
        }
    }

    private /* synthetic */ boolean lambda$spreadResin$4(Mutable mutable, BlockPos pos) {
        if (this.level.getBlockState(pos).is(ModBlockTags.PALE_OAK_LOGS)) {
            for (Direction direction : Util.shuffledCopy((Object[])Direction.values(), (RandomSource)this.level.getRandom())) {
                BlockPos neighbor = pos.relative(direction);
                BlockState neighborState = this.level.getBlockState(neighbor);
                Direction opposite = direction.getOpposite();
                Block resinClump = ModBlocks.RESIN_CLUMP.get();
                if (neighborState.isAir()) {
                    neighborState = resinClump.defaultBlockState();
                } else if (neighborState.is(Blocks.WATER) && neighborState.getFluidState().isSource()) {
                    neighborState = (BlockState)resinClump.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true));
                }
                if (!neighborState.is(resinClump) || MultifaceBlock.hasFace((BlockState)neighborState, (Direction)opposite)) continue;
                this.level.setBlock(neighbor, (BlockState)neighborState.setValue((Property)MultifaceBlock.getFaceProperty((Direction)opposite), (Comparable)Boolean.valueOf(true)), 3);
                mutable.setValue((Object)neighbor);
                return false;
            }
        }
        return true;
    }
}

