/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.api.bundle;

import com.blackgear.vanillabackport.client.registries.ModSoundEvents;
import com.blackgear.vanillabackport.common.api.bundle.IBundle;
import com.blackgear.vanillabackport.common.registries.ModItems;
import com.blackgear.vanillabackport.core.VanillaBackport;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BundleContents;

public class BundleFeatures {
    public static boolean onBundleUpdate() {
        return (Boolean)VanillaBackport.COMMON_CONFIG.hasUpdatedBundles.get();
    }

    public static boolean canItemBeInBundle(ItemStack stack) {
        return !stack.isEmpty() && stack.getItem().canFitInsideContainerItems();
    }

    public static void toggleSelectedItem(ItemStack stack, int index) {
        BundleContents contents = (BundleContents)stack.get(DataComponents.BUNDLE_CONTENTS);
        if (contents != null) {
            BundleContents.Mutable mutable = new BundleContents.Mutable(contents);
            ((IBundle.Mutable)mutable).toggleSelectedItem(index);
            stack.set(DataComponents.BUNDLE_CONTENTS, (Object)mutable.toImmutable());
        }
    }

    public static int getSelectedItem(ItemStack stack) {
        BundleContents contents = (BundleContents)stack.getOrDefault(DataComponents.BUNDLE_CONTENTS, (Object)BundleContents.EMPTY);
        return ((IBundle)contents).getSelectedItem();
    }

    public static ItemStack getSelectedItemStack(ItemStack stack) {
        BundleContents contents = (BundleContents)stack.get(DataComponents.BUNDLE_CONTENTS);
        IBundle ibundle = (IBundle)contents;
        return contents != null && ibundle.getSelectedItem() != -1 ? contents.getItemUnsafe(ibundle.getSelectedItem()) : ItemStack.EMPTY;
    }

    public static int getNumberOfItemsToShow(ItemStack stack) {
        BundleContents contents = (BundleContents)stack.getOrDefault(DataComponents.BUNDLE_CONTENTS, (Object)BundleContents.EMPTY);
        return ((IBundle)contents).getNumberOfItemsToShow();
    }

    public static Optional<ItemStack> removeOneItemFromBundle(ItemStack stack, Player player, BundleContents contents) {
        BundleContents.Mutable mutable = new BundleContents.Mutable(contents);
        ItemStack itemStack = mutable.removeOne();
        if (itemStack != null) {
            BundleFeatures.playRemoveOneSound((Entity)player);
            stack.set(DataComponents.BUNDLE_CONTENTS, (Object)mutable.toImmutable());
            return Optional.of(itemStack);
        }
        return Optional.empty();
    }

    public static Item getByColor(DyeColor dyeColor) {
        return switch (dyeColor) {
            case DyeColor.WHITE -> ModItems.WHITE_BUNDLE.get();
            case DyeColor.ORANGE -> ModItems.ORANGE_BUNDLE.get();
            case DyeColor.MAGENTA -> ModItems.MAGENTA_BUNDLE.get();
            case DyeColor.LIGHT_BLUE -> ModItems.LIGHT_BLUE_BUNDLE.get();
            case DyeColor.YELLOW -> ModItems.YELLOW_BUNDLE.get();
            case DyeColor.LIME -> ModItems.LIME_BUNDLE.get();
            case DyeColor.PINK -> ModItems.PINK_BUNDLE.get();
            case DyeColor.GRAY -> ModItems.GRAY_BUNDLE.get();
            case DyeColor.LIGHT_GRAY -> ModItems.LIGHT_GRAY_BUNDLE.get();
            case DyeColor.CYAN -> ModItems.CYAN_BUNDLE.get();
            case DyeColor.BLUE -> ModItems.BLUE_BUNDLE.get();
            case DyeColor.BROWN -> ModItems.BROWN_BUNDLE.get();
            case DyeColor.GREEN -> ModItems.GREEN_BUNDLE.get();
            case DyeColor.RED -> ModItems.RED_BUNDLE.get();
            case DyeColor.BLACK -> ModItems.BLACK_BUNDLE.get();
            case DyeColor.PURPLE -> ModItems.PURPLE_BUNDLE.get();
            default -> Items.BUNDLE;
        };
    }

    public static void playRemoveOneSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    public static void playInsertFailSound(Entity entity) {
        entity.playSound(ModSoundEvents.BUNDLE_INSERT_FAIL.get(), 1.0f, 1.0f);
    }

    public static void broadcastChangesOnContainerMenu(Player player) {
        AbstractContainerMenu menu = player.containerMenu;
        if (menu.stillValid(player)) {
            menu.slotsChanged((Container)player.getInventory());
        }
    }
}

