/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common;

import com.blackgear.platform.common.data.LootModifier;
import com.blackgear.vanillabackport.common.registries.ModBlocks;
import com.blackgear.vanillabackport.common.registries.ModItems;
import com.blackgear.vanillabackport.core.VanillaBackport;
import java.util.List;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.TagPredicate;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.DamageSourceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class LootIntegrations
implements LootModifier.LootTableModifier {
    private static final List<ResourceKey<LootTable>> CONTAIN_BUNDLE = List.of(BuiltInLootTables.VILLAGE_WEAPONSMITH, BuiltInLootTables.VILLAGE_CARTOGRAPHER, BuiltInLootTables.VILLAGE_TANNERY, BuiltInLootTables.VILLAGE_PLAINS_HOUSE, BuiltInLootTables.VILLAGE_TAIGA_HOUSE, BuiltInLootTables.VILLAGE_SAVANNA_HOUSE, BuiltInLootTables.VILLAGE_SNOWY_HOUSE, BuiltInLootTables.VILLAGE_DESERT_HOUSE);

    public void modify(ResourceKey<LootTable> key, LootModifier.LootTableContext context, boolean builtin) {
        if (key.equals((Object)EntityType.GHAST.getDefaultLootTable()) && ((Boolean)VanillaBackport.COMMON_CONFIG.hasTearsMusicDisc.get()).booleanValue()) {
            context.addPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.MUSIC_DISC_TEARS.get()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))).when(DamageSourceCondition.hasDamageSource((DamageSourcePredicate.Builder)DamageSourcePredicate.Builder.damageType().tag(TagPredicate.is((TagKey)DamageTypeTags.IS_PROJECTILE)).direct(EntityPredicate.Builder.entity().of(EntityType.FIREBALL)))).when(LootItemKilledByPlayerCondition.killedByPlayer()));
        }
        if (key.equals((Object)BuiltInLootTables.PIGLIN_BARTERING) && ((Boolean)VanillaBackport.COMMON_CONFIG.hasDriedGhasts.get()).booleanValue()) {
            context.addToPool(new LootPoolEntryContainer[]{LootItem.lootTableItem((ItemLike)((ItemLike)ModBlocks.DRIED_GHAST.get())).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))).build()});
        }
        if (key.equals((Object)EntityType.ZOMBIE.getDefaultLootTable())) {
            context.addPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.MUSIC_DISC_LAVA_CHICKEN.get()))).when(LootItemKilledByPlayerCondition.killedByPlayer()).when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().flags(EntityFlagsPredicate.Builder.flags().setIsBaby(Boolean.valueOf(true))).vehicle(EntityPredicate.Builder.entity().of(EntityType.CHICKEN)))));
        }
        if (key.equals((Object)BuiltInLootTables.WOODLAND_MANSION) && ((Boolean)VanillaBackport.COMMON_CONFIG.hasResin.get()).booleanValue()) {
            context.addToPool(1, new LootPoolEntryContainer[]{LootItem.lootTableItem((ItemLike)((ItemLike)ModBlocks.RESIN_CLUMP.get())).setWeight(50).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f))).build()});
        }
        if (CONTAIN_BUNDLE.contains(key) && ((Boolean)VanillaBackport.COMMON_CONFIG.hasVillageBundles.get()).booleanValue()) {
            context.addPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BUNDLE).setWeight(1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f)))).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(2)));
        }
    }
}

