/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.loot;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tiviacz.travelersbackpack.components.StarterUpgrades;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModItems;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class AddItemModifier
extends LootModifier {
    public static final Supplier<MapCodec<AddItemModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> AddItemModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(m -> m.item)).and((App)Codec.FLOAT.fieldOf("weight").forGetter(m -> Float.valueOf(m.weight))).apply((Applicative)inst, AddItemModifier::new)));
    private final Item item;
    private final float weight;

    protected AddItemModifier(LootItemCondition[] conditionsIn, Item item, float weight) {
        super(conditionsIn);
        this.item = item;
        this.weight = weight;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (!((Boolean)TravelersBackpackConfig.COMMON.enableLoot.get()).booleanValue()) {
            return generatedLoot;
        }
        if (context.getQueriedLootTableId().equals((Object)BuiltInLootTables.ABANDONED_MINESHAFT.location())) {
            if (this.item == ModItems.BAT_TRAVELERS_BACKPACK.get() && context.getRandom().nextFloat() <= this.weight) {
                generatedLoot.add((Object)this.withTanksUpgrade(this.item));
            }
            if (this.item == ModItems.STANDARD_TRAVELERS_BACKPACK.get() && context.getRandom().nextFloat() <= this.weight) {
                generatedLoot.add((Object)this.withTanksUpgrade(this.item));
            }
            if (this.item == ModItems.IRON_TIER_UPGRADE.get() && context.getRandom().nextFloat() <= this.weight) {
                generatedLoot.add((Object)new ItemStack((ItemLike)this.item));
            }
            if (this.item == ModItems.GOLD_TIER_UPGRADE.get() && context.getRandom().nextFloat() <= this.weight) {
                generatedLoot.add((Object)new ItemStack((ItemLike)this.item));
            }
        }
        if (context.getQueriedLootTableId().equals((Object)BuiltInLootTables.VILLAGE_ARMORER.location()) && this.item == ModItems.IRON_GOLEM_TRAVELERS_BACKPACK.get() && context.getRandom().nextFloat() <= this.weight) {
            generatedLoot.add((Object)this.withTanksUpgrade(this.item));
        }
        if (context.getQueriedLootTableId().equals((Object)BuiltInLootTables.SIMPLE_DUNGEON.location())) {
            if (this.item == ModItems.STANDARD_TRAVELERS_BACKPACK.get() && context.getRandom().nextFloat() <= this.weight) {
                generatedLoot.add((Object)this.withTanksUpgrade(this.item));
            }
            if (this.item == ModItems.IRON_TIER_UPGRADE.get() && context.getRandom().nextFloat() <= this.weight) {
                generatedLoot.add((Object)new ItemStack((ItemLike)this.item));
            }
        }
        if (context.getQueriedLootTableId().equals((Object)BuiltInLootTables.DESERT_PYRAMID.location())) {
            if (this.item == ModItems.STANDARD_TRAVELERS_BACKPACK.get() && context.getRandom().nextFloat() <= this.weight) {
                generatedLoot.add((Object)this.withTanksUpgrade(this.item));
            }
            if (this.item == ModItems.IRON_TIER_UPGRADE.get() && context.getRandom().nextFloat() <= this.weight) {
                generatedLoot.add((Object)new ItemStack((ItemLike)this.item));
            }
            if (this.item == ModItems.GOLD_TIER_UPGRADE.get() && context.getRandom().nextFloat() <= this.weight) {
                generatedLoot.add((Object)new ItemStack((ItemLike)this.item));
            }
        }
        if (context.getQueriedLootTableId().equals((Object)BuiltInLootTables.SHIPWRECK_TREASURE.location())) {
            if (this.item == ModItems.IRON_TIER_UPGRADE.get() && context.getRandom().nextFloat() <= this.weight) {
                generatedLoot.add((Object)new ItemStack((ItemLike)this.item));
            }
            if (this.item == ModItems.GOLD_TIER_UPGRADE.get() && context.getRandom().nextFloat() <= this.weight) {
                generatedLoot.add((Object)new ItemStack((ItemLike)this.item));
            }
        }
        if (context.getQueriedLootTableId().equals((Object)BuiltInLootTables.WOODLAND_MANSION.location())) {
            if (this.item == ModItems.IRON_TIER_UPGRADE.get() && context.getRandom().nextFloat() <= this.weight) {
                generatedLoot.add((Object)new ItemStack((ItemLike)this.item));
            }
            if (this.item == ModItems.GOLD_TIER_UPGRADE.get() && context.getRandom().nextFloat() <= this.weight) {
                generatedLoot.add((Object)new ItemStack((ItemLike)this.item));
            }
        }
        if (context.getQueriedLootTableId().equals((Object)BuiltInLootTables.NETHER_BRIDGE.location())) {
            if (this.item == ModItems.IRON_TIER_UPGRADE.get() && context.getRandom().nextFloat() <= this.weight) {
                generatedLoot.add((Object)new ItemStack((ItemLike)this.item));
            }
            if (this.item == ModItems.GOLD_TIER_UPGRADE.get() && context.getRandom().nextFloat() <= this.weight) {
                generatedLoot.add((Object)new ItemStack((ItemLike)this.item));
            }
        }
        if (context.getQueriedLootTableId().equals((Object)BuiltInLootTables.BASTION_TREASURE.location())) {
            if (this.item == ModItems.IRON_TIER_UPGRADE.get() && context.getRandom().nextFloat() <= this.weight) {
                generatedLoot.add((Object)new ItemStack((ItemLike)this.item));
            }
            if (this.item == ModItems.GOLD_TIER_UPGRADE.get() && context.getRandom().nextFloat() <= this.weight) {
                generatedLoot.add((Object)new ItemStack((ItemLike)this.item));
            }
        }
        if (context.getQueriedLootTableId().equals((Object)BuiltInLootTables.END_CITY_TREASURE.location())) {
            if (this.item == ModItems.GOLD_TIER_UPGRADE.get() && context.getRandom().nextFloat() <= this.weight) {
                generatedLoot.add((Object)new ItemStack((ItemLike)this.item));
            }
            if (this.item == ModItems.DIAMOND_TIER_UPGRADE.get() && context.getRandom().nextFloat() <= this.weight) {
                generatedLoot.add((Object)new ItemStack((ItemLike)this.item));
            }
        }
        return generatedLoot;
    }

    public ItemStack withTanksUpgrade(Item item) {
        ItemStack stack = item.getDefaultInstance();
        stack.set(ModDataComponents.STARTER_UPGRADES, (Object)new StarterUpgrades(List.of(ModItems.TANKS_UPGRADE.toStack())));
        return stack;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return (MapCodec)CODEC.get();
    }
}

