/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.items;

import com.google.common.collect.Multimap;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.client.screens.tooltip.BackpackTooltipComponent;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.config.BackpackEffect;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.entity.BackpackItemEntity;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.BackpackContainer;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.menu.slot.BackpackSlotItemHandler;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import com.tiviacz.travelersbackpack.util.KeyHelper;
import com.tiviacz.travelersbackpack.util.TextUtils;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class TravelersBackpackItem
extends BlockItem {
    @Deprecated(forRemoval=true)
    public final ResourceLocation texture;

    public TravelersBackpackItem(Block block) {
        this(block, "");
    }

    @Deprecated(forRemoval=true)
    public TravelersBackpackItem(Block block, String name) {
        this(block, ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)("textures/model/" + name.toLowerCase(Locale.ENGLISH) + ".png")));
    }

    @Deprecated(forRemoval=true)
    public TravelersBackpackItem(Block block, ResourceLocation texture) {
        super(block, new Item.Properties().stacksTo(1).component(ModDataComponents.TIER, (Object)0).component(ModDataComponents.SLEEPING_BAG_COLOR, (Object)DyeColor.RED.getId()).component(ModDataComponents.IS_VISIBLE, (Object)true));
        this.texture = texture;
    }

    @Deprecated(forRemoval=true)
    public ResourceLocation getBackpackTexture() {
        return this.texture;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (hand == InteractionHand.OFF_HAND || player.isCrouching()) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        if (!((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.allowOnlyEquippedBackpack.get()).booleanValue()) {
            if (!level.isClientSide) {
                BackpackContainer.openBackpack((ServerPlayer)player, player.getInventory().getSelected(), 1, player.getInventory().selected);
            }
        } else if (!AttachmentUtils.isWearingBackpack(player) && !TravelersBackpack.enableIntegration()) {
            ServerActions.equipBackpack(player);
            player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide);
    }

    public InteractionResult useOn(UseOnContext context) {
        InteractionResult interactionResult = this.place(new BlockPlaceContext(context));
        return !interactionResult.consumesAction() ? this.use(context.getLevel(), context.getPlayer(), context.getHand()).getResult() : interactionResult;
    }

    public InteractionResult place(BlockPlaceContext context) {
        if (!context.canPlace() || context.getHand() == InteractionHand.MAIN_HAND && context.getPlayer() != null && !context.getPlayer().isCrouching()) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext blockitemusecontext = this.updatePlacementContext(context);
        if (blockitemusecontext == null) {
            return InteractionResult.FAIL;
        }
        BlockState blockstate = this.getPlacementState(blockitemusecontext);
        if (blockstate == null) {
            return InteractionResult.FAIL;
        }
        if (!this.placeBlock(blockitemusecontext, blockstate)) {
            return InteractionResult.FAIL;
        }
        BlockPos blockpos = blockitemusecontext.getClickedPos();
        Level level = blockitemusecontext.getLevel();
        Player player = blockitemusecontext.getPlayer();
        ItemStack itemstack = blockitemusecontext.getItemInHand();
        BlockState blockstate1 = level.getBlockState(blockpos);
        if (blockstate1.is(blockstate.getBlock())) {
            this.updateCustomBlockEntityTag(blockpos, level, player, itemstack, blockstate1);
            blockstate1.getBlock().setPlacedBy(level, blockpos, blockstate1, (LivingEntity)player, itemstack);
            BlockEntity blockEntity = level.getBlockEntity(blockpos);
            if (blockEntity instanceof BackpackBlockEntity) {
                BackpackBlockEntity blockEntity2 = (BackpackBlockEntity)blockEntity;
                blockEntity2.setBackpack(itemstack, (HolderLookup.Provider)level.registryAccess());
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.PLACED_BLOCK.trigger(serverPlayer, blockpos, itemstack);
            }
        }
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_PLACE, blockpos);
        SoundType soundtype = blockstate1.getSoundType((LevelReader)level, blockpos, (Entity)context.getPlayer());
        level.playSound(player, blockpos, this.getPlaceSound(blockstate1, level, blockpos, player), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
        if (player == null || !player.getAbilities().instabuild) {
            itemstack.shrink(1);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected boolean updateCustomBlockEntityTag(BlockPos pPos, Level pLevel, @Nullable Player pPlayer, ItemStack pStack, BlockState pState) {
        return TravelersBackpackItem.updateCustomBlockEntityTag(pLevel, pPlayer, pPos, pStack);
    }

    public static boolean updateCustomBlockEntityTag(Level pLevel, @Nullable Player pPlayer, BlockPos pPos, ItemStack pStack) {
        MinecraftServer minecraftserver = pLevel.getServer();
        if (minecraftserver == null) {
            return false;
        }
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity != null && (pLevel.isClientSide || !blockEntity.onlyOpCanSetNbt() || pPlayer != null && pPlayer.canUseGameMasterBlocks())) {
            blockEntity.applyComponentsFromItemStack(pStack.copy());
            return true;
        }
        return false;
    }

    public static boolean isCreative(Player player) {
        return player.level().isClientSide() && player.containerMenu instanceof CreativeModeInventoryScreen.ItemPickerMenu;
    }

    public boolean overrideStackedOnOther(ItemStack stack, Slot slot, ClickAction action, Player player) {
        if (TravelersBackpackItem.isCreative(player) || stack.getCount() > 1 || !slot.mayPickup(player) || action != ClickAction.SECONDARY) {
            return super.overrideStackedOnOther(stack, slot, action, player);
        }
        ItemStack itemstack = slot.getItem();
        if (BackpackSlotItemHandler.isItemValid(itemstack)) {
            int count = TravelersBackpackItem.add(player, stack, itemstack, true);
            if (count <= 0) {
                return false;
            }
            int j = TravelersBackpackItem.add(player, stack, slot.safeTake(count, count, player), false);
            if (j > 0) {
                this.playInsertSound((Entity)player);
            }
            return true;
        }
        return super.overrideStackedOnOther(stack, slot, action, player);
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (TravelersBackpackItem.isCreative(player) || stack.getCount() > 1 || !slot.mayPlace(stack) || action != ClickAction.SECONDARY) {
            return super.overrideOtherStackedOnMe(stack, other, slot, action, player, access);
        }
        if (slot.allowModification(player)) {
            int i = TravelersBackpackItem.add(player, stack, other, false);
            if (i > 0) {
                this.playInsertSound((Entity)player);
                other.shrink(i);
            }
            return true;
        }
        return super.overrideOtherStackedOnMe(stack, other, slot, action, player, access);
    }

    private static int add(Player player, ItemStack backpackStack, ItemStack insertedStack, boolean simulate) {
        int k = insertedStack.getCount();
        if (!insertedStack.isEmpty() && BackpackSlotItemHandler.isItemValid(insertedStack)) {
            IItemHandler handler = (IItemHandler)backpackStack.getCapability(Capabilities.ItemHandler.ITEM);
            if (handler == null) {
                return 0;
            }
            ItemStack result = InventoryHelper.addItemStackToHandler(handler, insertedStack, simulate);
            return k - result.getCount();
        }
        return 0;
    }

    private void playInsertSound(Entity pEntity) {
        pEntity.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + pEntity.level().getRandom().nextFloat() * 0.4f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (stack.has(ModDataComponents.TIER)) {
            tooltipComponents.add((Component)Component.translatable((String)"tier.travelersbackpack.backpack").append(Tiers.of((Integer)stack.get(ModDataComponents.TIER)).getLocalizedName()));
        }
        if (stack.has(ModDataComponents.BACKPACK_CONTAINER) && !KeyHelper.isCtrlPressed()) {
            tooltipComponents.add((Component)Component.translatable((String)"item.travelersbackpack.inventory_tooltip").withStyle(ChatFormatting.BLUE));
        }
        if (((Boolean)TravelersBackpackConfig.CLIENT.obtainTips.get()).booleanValue()) {
            if (stack.getItem() == ModItems.BAT_TRAVELERS_BACKPACK.get()) {
                tooltipComponents.add((Component)Component.translatable((String)"obtain.travelersbackpack.bat").withStyle(ChatFormatting.BLUE));
            }
            if (stack.getItem() == ModItems.VILLAGER_TRAVELERS_BACKPACK.get()) {
                tooltipComponents.add((Component)Component.translatable((String)"obtain.travelersbackpack.villager").withStyle(ChatFormatting.BLUE));
            }
            if (stack.getItem() == ModItems.IRON_GOLEM_TRAVELERS_BACKPACK.get()) {
                tooltipComponents.add((Component)Component.translatable((String)"obtain.travelersbackpack.iron_golem").withStyle(ChatFormatting.BLUE));
            }
        }
        if (BackpackAbilities.ALLOWED_ABILITIES.contains(stack.getItem()) && ((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get()).booleanValue()) {
            if (KeyHelper.isShiftPressed()) {
                if (BackpackAbilities.CUSTOM_DESCRIPTIONS.contains(stack.getItem())) {
                    tooltipComponents.add((Component)Component.translatable((String)("ability.travelersbackpack." + this.getDescriptionId(stack).replaceAll("block.travelersbackpack.", ""))).withStyle(ChatFormatting.BLUE));
                }
                boolean whenEquippedPresent = false;
                if (BackpackAbilities.getBackpackEffects().containsKey((Object)stack.getItem())) {
                    tooltipComponents.add((Component)Component.translatable((String)"ability.travelersbackpack.when_equipped").withStyle(ChatFormatting.DARK_PURPLE));
                    whenEquippedPresent = true;
                    BackpackAbilities.getBackpackEffects().entries().stream().filter(entry -> entry.getKey() == stack.getItem()).forEach(entry -> {
                        MutableComponent mutablecomponent = Component.literal((String)"- ");
                        mutablecomponent.append((Component)Component.translatable((String)((MobEffect)((BackpackEffect)entry.getValue()).effect().value()).getDescriptionId()));
                        if (((BackpackEffect)entry.getValue()).amplifier() > 0) {
                            mutablecomponent = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{mutablecomponent, Component.translatable((String)("potion.potency." + ((BackpackEffect)entry.getValue()).amplifier()))});
                        }
                        if (BackpackAbilities.getCooldowns().containsKey(stack.getItem())) {
                            mutablecomponent.append(" " + TextUtils.getConvertedTime(((BackpackEffect)entry.getValue()).minDuration()));
                        }
                        tooltipComponents.add((Component)mutablecomponent.withStyle(((MobEffect)((BackpackEffect)entry.getValue()).effect().value()).getCategory().getTooltipFormatting()));
                    });
                }
                this.addAttributeModifierTooltip(stack, tooltipComponents, whenEquippedPresent);
                if (BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, stack) && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, stack)) {
                    tooltipComponents.add((Component)Component.translatable((String)"ability.travelersbackpack.item_and_block"));
                } else if (BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, stack) && !BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, stack)) {
                    tooltipComponents.add((Component)Component.translatable((String)"ability.travelersbackpack.block"));
                } else if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, stack) && !BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, stack)) {
                    tooltipComponents.add((Component)Component.translatable((String)"ability.travelersbackpack.item"));
                }
            } else {
                tooltipComponents.add((Component)Component.translatable((String)"ability.travelersbackpack.hold_shift").withStyle(ChatFormatting.BLUE));
            }
        }
    }

    private void addAttributeModifierTooltip(ItemStack stack, List<Component> components, boolean whenEquippedPresent) {
        Multimap<Holder<Attribute>, AttributeModifier> multimap = BackpackAbilities.ABILITIES.getAttributeAbilityMultimap(stack);
        if (!multimap.isEmpty()) {
            if (!whenEquippedPresent) {
                components.add((Component)Component.translatable((String)"ability.travelersbackpack.when_equipped").withStyle(ChatFormatting.DARK_PURPLE));
            }
            for (Map.Entry entry : multimap.entries()) {
                Holder attribute = (Holder)entry.getKey();
                AttributeModifier modifier = (AttributeModifier)entry.getValue();
                double d = modifier.amount();
                double e = modifier.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_BASE && modifier.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? (attribute.is(Attributes.KNOCKBACK_RESISTANCE) ? d * 10.0 : d) : d * 100.0;
                if (d > 0.0) {
                    components.add((Component)Component.translatable((String)("attribute.modifier.plus." + modifier.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(e), Component.translatable((String)((Attribute)attribute.value()).getDescriptionId())}).withStyle(((Attribute)attribute.value()).getStyle(true)));
                    continue;
                }
                if (!(d < 0.0)) continue;
                components.add((Component)Component.translatable((String)("attribute.modifier.take." + modifier.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(-e), Component.translatable((String)((Attribute)attribute.value()).getDescriptionId())}).withStyle(((Attribute)attribute.value()).getStyle(false)));
            }
        }
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return this.hasCustomData(stack);
    }

    @Nullable
    public Entity createEntity(Level level, Entity entity, ItemStack itemstack) {
        if (!(entity instanceof ItemEntity)) {
            return null;
        }
        ItemEntity itemEntity = (ItemEntity)entity;
        return this.createBackpackEntity(level, itemEntity, itemstack);
    }

    public boolean hasCustomData(ItemStack stack) {
        if (((BackpackContainerContents)stack.getOrDefault(ModDataComponents.BACKPACK_CONTAINER, (Object)BackpackContainerContents.fromItems(0, List.of()))).getItems().stream().anyMatch(itemStack -> !itemStack.isEmpty())) {
            return true;
        }
        NonNullList<ItemStack> upgrades = ((BackpackContainerContents)stack.getOrDefault((DataComponentType)ModDataComponents.UPGRADES.get(), (Object)BackpackContainerContents.fromItems(0, List.of()))).getItems();
        if (upgrades.stream().anyMatch(itemStack -> !itemStack.isEmpty() && !itemStack.is((Item)ModItems.TANKS_UPGRADE.get())) && upgrades.stream().anyMatch(itemStack -> itemStack.is((Item)ModItems.TANKS_UPGRADE.get()))) {
            return true;
        }
        if (((BackpackContainerContents)stack.getOrDefault(ModDataComponents.TOOLS_CONTAINER, (Object)BackpackContainerContents.fromItems(0, List.of()))).getItems().stream().anyMatch(itemStack -> !itemStack.isEmpty())) {
            return true;
        }
        return (Integer)stack.getOrDefault(ModDataComponents.TIER, (Object)0) >= Tiers.DIAMOND.getOrdinal();
    }

    @Nullable
    private BackpackItemEntity createBackpackEntity(Level level, ItemEntity itemEntity, ItemStack itemstack) {
        BackpackItemEntity backpackItemEntity = (BackpackItemEntity)ModItems.BACKPACK_ITEM_ENTITY.get().create(level);
        if (backpackItemEntity != null) {
            backpackItemEntity.setPos(itemEntity.getX(), itemEntity.getY(), itemEntity.getZ());
            backpackItemEntity.setItem(itemstack.copy());
            backpackItemEntity.setPickUpDelay(itemEntity.pickupDelay);
            if (itemEntity.getOwner() != null) {
                backpackItemEntity.setThrower(itemEntity.getOwner());
            }
            backpackItemEntity.setDeltaMovement(itemEntity.getDeltaMovement());
        }
        return backpackItemEntity;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack pStack) {
        return Optional.of(new BackpackTooltipComponent(pStack));
    }

    public boolean canFitInsideContainerItems() {
        return false;
    }

    public static void registerCauldronInteraction() {
        CauldronInteraction.WATER.map().put((Item)ModItems.STANDARD_TRAVELERS_BACKPACK.get(), CauldronInteraction.DYED_ITEM);
    }
}

