/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.voiding;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.BackpackSettingsScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.FilterUpgradeWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetElement;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.DisabledSlot;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.ButtonStates;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.FilterButton;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TankWidget;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.voiding.VoidUpgrade;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import com.tiviacz.travelersbackpack.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class VoidWidget
extends FilterUpgradeWidgetBase<VoidWidget, VoidUpgrade> {
    private static final ResourceLocation TRASH_UPGRADE = ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"textures/item/void_upgrade.png");
    private static final int RED_HIGHLIGHT_COLOR = 2143884822;
    private static final int RED_ARROW_COLOR = -5636096;
    private static final int HIGHLIGHT_TANK_COLOR = -2130706433;
    private final WidgetElement trashBinSlot = new WidgetElement(new Point(25, 4), new Point(16, 16));
    public final List<Integer> selectedSlots = new ArrayList<Integer>();
    public final List<Integer> selectedTanks = new ArrayList<Integer>();
    private boolean tickAnimation = false;
    private float progress = 0.0f;
    private boolean hoveringTrashBin = false;
    private static final List<Component> WHITELIST_TOOLTIPS = List.of(Component.translatable((String)"screen.travelersbackpack.filter_allow_voiding"), Component.translatable((String)"screen.travelersbackpack.filter_block_voiding"), Component.translatable((String)"screen.travelersbackpack.filter_match_contents_voiding"));
    private static final List<Component> OBJECT_TOOLTIPS = List.of(Component.translatable((String)"screen.travelersbackpack.filter_item"), Component.translatable((String)"screen.travelersbackpack.filter_modid"), Component.translatable((String)"screen.travelersbackpack.filter_tag"));
    private static final List<Component> IGNORE_MODE_TOOLTIPS = List.of(Component.translatable((String)"screen.travelersbackpack.filter_match_components"), Component.translatable((String)"screen.travelersbackpack.filter_ignore_components"));

    public VoidWidget(BackpackScreen screen, VoidUpgrade upgrade, Point pos) {
        super(screen, upgrade, pos, new Point(137, 0), "screen.travelersbackpack.void_upgrade");
        FilterButton<VoidWidget> whitelistButton = new FilterButton<VoidWidget>(this, upgrade.getFilter().get(0), ButtonStates.ALLOW, new Point(pos.x() + 6, pos.y() + 22));
        FilterButton<VoidWidget> objectButton = new FilterButton<VoidWidget>(this, upgrade.getFilter().get(1), ButtonStates.OBJECT_TYPE, new Point(pos.x() + 6 + 18, pos.y() + 22));
        FilterButton<VoidWidget> ignoreModeButton = new FilterButton<VoidWidget>(this, upgrade.getFilter().get(2), ButtonStates.IGNORE_MODE, new Point(pos.x() + 6 + 36, pos.y() + 22));
        this.addFilterButton(whitelistButton);
        this.addFilterButton(objectButton);
        this.addFilterButton(ignoreModeButton);
    }

    @Override
    public void renderBg(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, x, y, mouseX, mouseY);
        this.renderMatchContentsSlotOverlay(guiGraphics, ((VoidUpgrade)this.upgrade).getFilter(), 0, 2, (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.voidUpgradeSettings.filterSlotCount.get());
        if (this.isTabOpened()) {
            if (this.isHoveringWithTrashBin()) {
                RenderSystem.enableBlend();
                guiGraphics.setColor(1.0f, 1.0f, 1.0f, 0.5f);
                this.renderTrashBin(guiGraphics, this.pos.x() + 31, this.pos.y() + 9, this.selectedSlots.isEmpty() && this.selectedTanks.isEmpty() ? 0.0f : 3.0f);
                if (!this.selectedSlots.isEmpty() || !this.selectedTanks.isEmpty()) {
                    guiGraphics.setColor(1.0f, 1.0f, 1.0f, 0.75f);
                    this.renderRedDownArrow(guiGraphics, this.pos.x() + 31 + 1, this.pos.y() + 5);
                }
                guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                RenderSystem.disableBlend();
            } else {
                this.renderTrashBinAnimation(guiGraphics, this.pos.x() + 31, this.pos.y() + 9);
            }
        }
    }

    @Override
    public void renderUnderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderUnderTooltip(guiGraphics, mouseX, mouseY, partialTicks);
        Slot slot = ((BackpackScreen)this.screen).getSlotUnderMouse();
        if (this.isHoveringWithTrashBin() && slot != null && this.canSelectSlot(slot) && !this.selectedSlots.contains(slot.index)) {
            this.drawRedHighlight(guiGraphics, slot);
        }
        this.selectedSlots.forEach(index -> this.drawRedHighlight(guiGraphics, ((BackpackBaseMenu)((BackpackScreen)this.screen).getMenu()).getSlot((int)index)));
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.isTabOpened()) {
            if (this.isWithinTrashBinSlot(mouseX, mouseY)) {
                if (!(!this.isHoveringWithTrashBin() || this.selectedSlots.isEmpty() && this.selectedTanks.isEmpty())) {
                    guiGraphics.renderTooltip(((BackpackScreen)this.screen).getFont(), (Component)Component.translatable((String)"screen.travelersbackpack.void_upgrade_trash_bin_drop").withStyle(ChatFormatting.RED), mouseX, mouseY);
                }
                if (this.selectedSlots.isEmpty() && this.selectedTanks.isEmpty()) {
                    ArrayList<Component> components = new ArrayList<Component>(TextUtils.getTranslatedSplittedText("screen.travelersbackpack.void_upgrade_trash_bin", null));
                    if (((BackpackScreen)this.screen).getWrapper().getUpgradeManager().getUpgrade(TanksUpgrade.class).isEmpty()) {
                        components.remove(2);
                    }
                    guiGraphics.renderComponentTooltip(((BackpackScreen)this.screen).getFont(), components, mouseX, mouseY);
                }
            }
            if (this.getFilterButton(ButtonStates.ALLOW).isMouseOver(mouseX, mouseY)) {
                guiGraphics.renderTooltip(((BackpackScreen)this.screen).getFont(), WHITELIST_TOOLTIPS.get(this.getFilterButton(ButtonStates.ALLOW).getCurrentState()), mouseX, mouseY);
            }
            if (this.getFilterButton(ButtonStates.OBJECT_TYPE).isMouseOver(mouseX, mouseY)) {
                guiGraphics.renderTooltip(((BackpackScreen)this.screen).getFont(), OBJECT_TOOLTIPS.get(this.getFilterButton(ButtonStates.OBJECT_TYPE).getCurrentState()), mouseX, mouseY);
            }
            if (this.getFilterButton(ButtonStates.IGNORE_MODE).isMouseOver(mouseX, mouseY)) {
                guiGraphics.renderTooltip(((BackpackScreen)this.screen).getFont(), IGNORE_MODE_TOOLTIPS.get(this.getFilterButton(ButtonStates.IGNORE_MODE).getCurrentState()), mouseX, mouseY);
            }
        }
    }

    @Override
    public void renderOnTop(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderOnTop(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.isTabOpened()) {
            boolean bl = this.tickAnimation = this.isHoveringWithTrashBin() || this.isWithinTrashBinSlot(mouseX, mouseY);
            if (this.isHoveringWithTrashBin()) {
                this.renderTrashBinAnimation(guiGraphics, mouseX - 1, mouseY - 1);
            }
        }
    }

    @Override
    public boolean isMouseOver(double pMouseX, double pMouseY) {
        if (this.isHoveringWithTrashBin()) {
            return true;
        }
        return super.isMouseOver(pMouseX, pMouseY);
    }

    public boolean isWithinTrashBinSlot(double mouseX, double mouseY) {
        return this.isWithinBounds(mouseX, mouseY, this.trashBinSlot);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.select(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isTabOpened()) {
            if (this.isWithinTrashBinSlot(mouseX, mouseY) && ((BackpackScreen)this.screen).getWrapper().isOwner(((BackpackScreen)this.screen).getScreenPlayer()) && ((BackpackBaseMenu)((BackpackScreen)this.screen).getMenu()).getCarried().isEmpty()) {
                boolean bl = this.hoveringTrashBin = !this.hoveringTrashBin;
                if (!this.isHoveringWithTrashBin()) {
                    this.selectedSlots.forEach(index -> ServerboundActionTagPacket.create(16, 0, ItemStack.EMPTY, index));
                    this.selectedSlots.clear();
                    this.selectedTanks.forEach(tank -> ServerboundActionTagPacket.create(16, 1, ItemStack.EMPTY, tank));
                    this.selectedTanks.clear();
                }
            } else if (this.select(mouseX, mouseY, button)) {
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean isHoveringWithTrashBin() {
        return this.hoveringTrashBin;
    }

    public boolean select(double mouseX, double mouseY, int button) {
        if (this.isHoveringWithTrashBin()) {
            if (this.selectSlots(((BackpackScreen)this.screen).getSlotUnderMouse(), button)) {
                return true;
            }
            WidgetBase<?> widgetBase = ((BackpackScreen)this.screen).mappedWidgets.get(TanksUpgrade.class);
            if (widgetBase instanceof TankWidget) {
                TankWidget tankWidget = (TankWidget)widgetBase;
                if (this.selectTank(tankWidget, ((TanksUpgrade)tankWidget.getUpgrade()).getLeftTank().isEmpty(), tankWidget.leftTankElement, mouseX, mouseY, 0, button)) {
                    return true;
                }
                if (this.selectTank(tankWidget, ((TanksUpgrade)tankWidget.getUpgrade()).getRightTank().isEmpty(), tankWidget.rightTankElement, mouseX, mouseY, 1, button)) {
                    return true;
                }
            }
            if (!this.isWithinTrashBinSlot(mouseX, mouseY)) {
                return true;
            }
        }
        return false;
    }

    public boolean selectTank(TankWidget tankWidget, boolean isEmpty, WidgetElement tankElement, double mouseX, double mouseY, int tank, int button) {
        if (tankWidget.inTank(tankElement, mouseX, mouseY) && !isEmpty) {
            if (button == 0 && !this.selectedTanks.contains(tank)) {
                this.selectedTanks.add(tank);
                return true;
            }
            if (button == 1 && this.selectedTanks.contains(tank)) {
                this.selectedTanks.remove((Object)tank);
                return true;
            }
        }
        return false;
    }

    public boolean canSelectSlot(Slot slot) {
        return slot.index >= 0 && slot.index < ((BackpackScreen)this.screen).getWrapper().getStorage().getSlots() || slot.container instanceof Inventory;
    }

    public boolean selectSlots(Slot slot, int button) {
        if (slot != null) {
            if (slot instanceof DisabledSlot || !slot.hasItem()) {
                return false;
            }
            if (this.canSelectSlot(slot) && BackpackSettingsScreen.selectSlotsIndex(this.selectedSlots, this.hoveringTrashBin, slot, button)) {
                return true;
            }
        }
        return false;
    }

    public void drawRedTankHighlight(GuiGraphics guiGraphics, int x, int y, boolean inTank, int height, int tankIndex) {
        boolean flag;
        if (this.isHoveringWithTrashBin() && ((flag = inTank) || this.selectedTanks.contains(tankIndex))) {
            if (flag) {
                guiGraphics.fillGradient(RenderType.guiOverlay(), x, y, x + 16, y + height, -2130706433, -2130706433, 0);
            }
            guiGraphics.fill(RenderType.guiOverlay(), x, y, x + 16, y + height, 0, 2143884822);
        }
    }

    public void drawRedHighlight(GuiGraphics guiGraphics, Slot slot) {
        guiGraphics.fill(RenderType.guiOverlay(), ((BackpackScreen)this.screen).getGuiLeft() + slot.x, ((BackpackScreen)this.screen).getGuiTop() + slot.y, ((BackpackScreen)this.screen).getGuiLeft() + slot.x + 16, ((BackpackScreen)this.screen).getGuiTop() + slot.y + 16, 0, 2143884822);
    }

    public void renderRedDownArrow(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.fill(RenderType.guiOverlay(), x, y + 2, x + 2, y + 5, -5636096);
        guiGraphics.fill(RenderType.guiOverlay(), x - 2, y + 5, x + 4, y + 6, -5636096);
        guiGraphics.fill(RenderType.guiOverlay(), x - 1, y + 6, x + 3, y + 7, -5636096);
        guiGraphics.fill(RenderType.guiOverlay(), x, y + 7, x + 2, y + 8, -5636096);
    }

    public void renderTrashBinAnimation(GuiGraphics guiGraphics, int x, int y) {
        this.tickAnimation();
        float time = (float)(System.currentTimeMillis() % 2000L) / 1000.0f;
        float f = (float)(Math.sin((double)time * Math.PI) * 1.0 + 1.0);
        guiGraphics.pose().pushPose();
        if (this.isHoveringWithTrashBin()) {
            RenderSystem.disableDepthTest();
            guiGraphics.pose().translate(0.0f, 0.0f, 500.0f);
            guiGraphics.pose().rotateAround(Axis.ZP.rotationDegrees(-12.5f + f * 12.5f), (float)x, (float)y, 0.0f);
            RenderSystem.enableDepthTest();
        }
        this.renderTrashBin(guiGraphics, x, y, this.progress);
        guiGraphics.pose().popPose();
    }

    public void renderTrashBin(GuiGraphics guiGraphics, int x, int y, float progress) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().rotateAround(Axis.ZP.rotationDegrees(progress * 7.5f), (float)x, (float)y, 0.0f);
        guiGraphics.blit(TRASH_UPGRADE, x, y - (int)(1.0f * progress), 6.0f, 4.0f, 4, 1, 16, 16);
        guiGraphics.blit(TRASH_UPGRADE, x - 2, y + 1 - (int)(1.0f * progress), 4.0f, 5.0f, 8, 1, 16, 16);
        guiGraphics.pose().popPose();
        guiGraphics.blit(TRASH_UPGRADE, x - 2, y + 2, 4.0f, 6.0f, 8, 1, 16, 16);
        guiGraphics.blit(TRASH_UPGRADE, x - 1, y + 3, 5.0f, 7.0f, 6, 5, 16, 16);
    }

    public void tickAnimation() {
        this.progress = this.tickAnimation ? (this.progress < 3.0f ? (this.progress += 0.2f) : 3.0f) : (this.progress > 0.0f ? (this.progress -= 0.2f) : 0.0f);
    }
}

