/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.refill;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.FilterSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.ITickableUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.FilterHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.IFilterSlots;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class RefillUpgrade
extends UpgradeBase<RefillUpgrade>
implements IEnable,
ITickableUpgrade,
IFilterSlots {
    private final FilterHandler filter;

    public RefillUpgrade(UpgradeManager manager, int dataHolderSlot, NonNullList<ItemStack> filter) {
        super(manager, dataHolderSlot, new Point(66, 28));
        this.filter = this.createFilter(filter, this.getFilterSlotCount());
    }

    @Override
    public int getFilterSlotCount() {
        return (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.refillUpgradeSettings.filterSlotCount.get();
    }

    @Override
    public int getSlotsInRow() {
        return (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.refillUpgradeSettings.slotsInRow.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public WidgetBase createWidget(BackpackScreen screen, int x, int y) {
        return new UpgradeWidgetBase<RefillUpgrade>(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y), new Point(137, 0), "screen.travelersbackpack.refill_upgrade");
    }

    @Override
    public List<Pair<Integer, Integer>> getUpgradeSlotsPosition(int x, int y) {
        ArrayList<Pair<Integer, Integer>> positions = new ArrayList<Pair<Integer, Integer>>();
        for (int i = 0; i < this.getRows(); ++i) {
            for (int j = 0; j < this.getSlotsInRow(i); ++j) {
                positions.add((Pair<Integer, Integer>)Pair.of((Object)(x + 7 + j * 18), (Object)(y + 23 + i * 18)));
            }
        }
        return positions;
    }

    @Override
    public List<? extends Slot> getUpgradeSlots(final BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y) {
        ArrayList<1> slots = new ArrayList<1>();
        for (int i = 0; i < this.getRows(); ++i) {
            for (int j = 0; j < this.getSlotsInRow(i); ++j) {
                slots.add(new FilterSlotItemHandler(this, this, (IItemHandler)this.filter, j + i * this.getSlotsInRow(), x + 7 + j * 18, y + 23 + i * 18, this.getFilterSlotCount()){

                    @Override
                    public boolean mayPlace(ItemStack pStack) {
                        return menu.getWrapper().isOwner(menu.player) && super.mayPlace(pStack);
                    }
                });
            }
        }
        return slots;
    }

    @Override
    public void tick(@Nullable Player player, Level level, BlockPos pos, int currentTick) {
        if (this.getCooldown() == 0) {
            return;
        }
        if (currentTick % this.getCooldown() != 0) {
            return;
        }
        this.getUpgradeManager().getWrapper().loadAdditionally(0);
        IItemHandler cap = (IItemHandler)player.getCapability(Capabilities.ItemHandler.ENTITY);
        if (cap != null) {
            this.tryRefillItems(cap, player);
        }
        if (!this.hasCooldown() || this.getCooldown() != this.getTickRate()) {
            this.setCooldown(this.getTickRate());
        }
    }

    public void tryRefillItems(IItemHandler playerInv, Player player) {
        InventoryHelper.iterateHandler((IItemHandler)this.filter, (slot, filterStack) -> {
            if (!filterStack.isEmpty()) {
                this.refill(playerInv, player, (ItemStack)filterStack);
            }
        });
    }

    public void refill(IItemHandler playerInv, Player player, ItemStack filterStack) {
        Pair pair = this.countAndSupply(playerInv, filterStack, player);
        int missingCount = this.getMissingCount(filterStack, (Integer)pair.getFirst());
        if ((Integer)pair.getFirst() >= filterStack.getMaxStackSize() || missingCount <= 0) {
            return;
        }
        boolean standalone = false;
        if ((Integer)pair.getFirst() == 0) {
            int count = (Integer)pair.getFirst();
            pair = Pair.of((Object)count, (Object)player.getInventory().getFreeSlot());
            standalone = true;
        }
        if ((Integer)pair.getSecond() == -1) {
            return;
        }
        ItemStackHandler backpackStorage = this.upgradeManager.getWrapper().getStorage();
        if (backpackStorage == null) {
            return;
        }
        ItemStack extracted = InventoryHelper.extractFromBackpack((IItemHandler)backpackStorage, filterStack, missingCount, true);
        if (extracted.isEmpty()) {
            return;
        }
        boolean addItem = true;
        int extractedCount = extracted.getCount();
        if (!standalone) {
            player.getInventory().getItem(((Integer)pair.getSecond()).intValue()).grow(extractedCount);
        } else {
            addItem = player.addItem(extracted);
        }
        if (addItem) {
            InventoryHelper.extractFromBackpack((IItemHandler)backpackStorage, filterStack, extractedCount, false);
        }
    }

    private Pair<Integer, Integer> countAndSupply(IItemHandler playerInv, ItemStack filterStack, Player player) {
        AtomicInteger count = new AtomicInteger();
        AtomicInteger supplySlot = new AtomicInteger(-1);
        InventoryHelper.iterateHandler(playerInv, (slot, stack) -> {
            if (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)filterStack)) {
                if (supplySlot.get() == -1) {
                    supplySlot.set((int)slot);
                }
                count.addAndGet(stack.getCount());
            }
        });
        if (player.containerMenu != null && ItemStack.isSameItemSameComponents((ItemStack)player.containerMenu.getCarried(), (ItemStack)filterStack)) {
            count.addAndGet(player.containerMenu.getCarried().getCount());
        }
        return Pair.of((Object)count.get(), (Object)supplySlot.get());
    }

    private int getMissingCount(ItemStack filterStack, int count) {
        return filterStack.getMaxStackSize() - count;
    }

    @Override
    public int getTickRate() {
        return (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.refillUpgradeSettings.tickRate.get();
    }

    protected FilterHandler createFilter(NonNullList<ItemStack> stacks, final int size) {
        return new FilterHandler(stacks, size){

            protected void onContentsChanged(int slot) {
                RefillUpgrade.this.updateDataHolderUnchecked((DataComponentType)ModDataComponents.BACKPACK_CONTAINER.get(), InventoryHelper.itemsToList(size, (IItemHandler)RefillUpgrade.this.filter));
            }
        };
    }
}

