/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.crafting;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetElement;
import com.tiviacz.travelersbackpack.compat.craftingtweaks.BackpackCraftingGridAddition;
import com.tiviacz.travelersbackpack.compat.craftingtweaks.ICraftingTweaks;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.ResultArrowElement;
import com.tiviacz.travelersbackpack.inventory.upgrades.crafting.CraftingUpgrade;
import net.minecraft.client.gui.GuiGraphics;

public class CraftingWidget
extends UpgradeWidgetBase<CraftingUpgrade> {
    private final ResultArrowElement resultArrowElement;
    public final WidgetElement arrowElement = new WidgetElement(new Point(8, 91), new Point(12, 12));
    private static ICraftingTweaks craftingTweaksAddition = ICraftingTweaks.EMPTY;

    public CraftingWidget(BackpackScreen screen, CraftingUpgrade upgrade, Point pos) {
        super(screen, upgrade, pos, new Point(51, 0), "screen.travelersbackpack.crafting_upgrade");
        this.resultArrowElement = new ResultArrowElement(screen, this, this.arrowElement);
        this.getCraftingTweaksAddition().setScreen(screen);
        if (this.isTabOpened()) {
            this.getCraftingTweaksAddition().onCraftingSlotsDisplayed();
        }
    }

    @Override
    public void renderBg(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        if (this.isTabOpened()) {
            if (this.isCraftingTweaksAdditionEnabled()) {
                guiGraphics.blit(BackpackScreen.TABS, this.pos.x(), this.pos.y(), this.tabUv.x(), this.tabUv.y(), this.width - 19, this.height);
                guiGraphics.blit(BackpackScreen.TABS, this.pos.x() + this.width - 20, this.pos.y(), this.tabUv.x() + 66, this.tabUv.y(), 20, this.height);
            } else {
                guiGraphics.blit(BackpackScreen.TABS, this.pos.x(), this.pos.y(), this.tabUv.x(), this.tabUv.y(), this.width, this.height);
            }
            guiGraphics.renderItem(((BackpackScreen)this.screen).getWrapper().getUpgrades().getStackInSlot(this.dataHolderSlot), this.pos.x() + 4, this.pos.y() + 4);
        }
        this.resultArrowElement.renderBg(guiGraphics, x, y, mouseX, mouseY);
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        this.resultArrowElement.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    @Override
    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.resultArrowElement.mouseClicked(pMouseX, pMouseY, pButton)) {
            return true;
        }
        if (this.isMouseOverIcon(pMouseX, pMouseY)) {
            if (((CraftingUpgrade)this.upgrade).isTabOpened()) {
                craftingTweaksAddition.onCraftingSlotsHidden();
            } else {
                craftingTweaksAddition.onCraftingSlotsDisplayed();
            }
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public static void setCraftingTweaksAddition(ICraftingTweaks addition) {
        craftingTweaksAddition = addition;
    }

    public ICraftingTweaks getCraftingTweaksAddition() {
        return craftingTweaksAddition;
    }

    public boolean isCraftingTweaksAdditionEnabled() {
        return craftingTweaksAddition instanceof BackpackCraftingGridAddition;
    }
}

