/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.sorter;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class SortSelector {
    public static Comparator<ItemStack> getSortTypeComparator(List<ItemStack> stacks, SortType type) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Comparator.comparing(SortSelector::getStringForCategorySort);
            case 1 -> Comparator.comparing(SortSelector::getStringForNameSort);
            case 2 -> SortSelector.getCountTypeComparator(stacks);
        };
    }

    public static Comparator<ItemStack> getCountTypeComparator(List<ItemStack> stacks) {
        HashMap<Item, Integer> counts = SortSelector.calculateCount(stacks);
        ArrayList<Item> sortedItems = new ArrayList<Item>(counts.keySet());
        sortedItems.sort((item1, item2) -> {
            int countCompare = Integer.compare((Integer)counts.get(item2), (Integer)counts.get(item1));
            if (countCompare != 0) {
                return countCompare;
            }
            return item1.getDescriptionId().compareTo(item2.getDescriptionId());
        });
        return (stack1, stack2) -> {
            if (stack1.isEmpty() && stack2.isEmpty()) {
                return 0;
            }
            if (stack1.isEmpty()) {
                return 1;
            }
            if (stack2.isEmpty()) {
                return -1;
            }
            int index1 = sortedItems.indexOf(stack1.getItem());
            int index2 = sortedItems.indexOf(stack2.getItem());
            return Integer.compare(index1, index2);
        };
    }

    public static HashMap<Item, Integer> calculateCount(List<ItemStack> stacks) {
        HashMap<Item, Integer> itemCounts = new HashMap<Item, Integer>();
        for (ItemStack stack : stacks) {
            if (stack.isEmpty()) continue;
            Item item = stack.getItem();
            int count = stack.getCount();
            itemCounts.put(item, itemCounts.getOrDefault(item, 0) + count);
        }
        return itemCounts;
    }

    public static String getStringForCategorySort(ItemStack stack) {
        String name = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString();
        name = SortSelector.specialCases(stack, name);
        return name;
    }

    public static String getStringForNameSort(ItemStack stack) {
        String key = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString();
        String itemName = key.split(":")[1];
        itemName = SortSelector.specialCases(stack, itemName);
        return itemName;
    }

    private static String specialCases(ItemStack stack, String name) {
        Item item = stack.getItem();
        name = SortSelector.stackSize(stack, name);
        if (item instanceof EnchantedBookItem) {
            return SortSelector.enchantedBookNameCase(stack, name);
        }
        if (item instanceof TieredItem) {
            return SortSelector.toolDurabilityCase(stack, name);
        }
        return name;
    }

    private static String stackSize(ItemStack stack, String name) {
        int invertedCount = 9999 - stack.getCount();
        return name + String.format("%04d", invertedCount);
    }

    private static String enchantedBookNameCase(ItemStack stack, String name) {
        Set enchants = ((ItemEnchantments)stack.get(DataComponents.STORED_ENCHANTMENTS)).entrySet();
        ArrayList<String> names = new ArrayList<String>();
        StringBuilder enchantNames = new StringBuilder();
        for (Object2IntMap.Entry e : enchants) {
            names.add(Enchantment.getFullname((Holder)((Holder)e.getKey()), (int)e.getIntValue()).getString());
        }
        Collections.sort(names);
        for (String enchant : names) {
            enchantNames.append(enchant).append(" ");
        }
        return name + " " + enchants.size() + " " + String.valueOf(enchantNames);
    }

    private static String toolDurabilityCase(ItemStack stack, String name) {
        return name + stack.getDamageValue();
    }

    public static enum SortType {
        CATEGORY,
        NAME,
        COUNT;


        public SortType next() {
            SortType[] values = SortType.values();
            int nextIndex = (this.ordinal() + 1) % values.length;
            return values[nextIndex];
        }
    }
}

