/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.handlers;

import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.datagen.ModLootTableProvider;
import com.tiviacz.travelersbackpack.datagen.ModRecipeProvider;
import com.tiviacz.travelersbackpack.init.ModBlockEntityTypes;
import com.tiviacz.travelersbackpack.init.ModNetwork;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber(modid="travelersbackpack", bus=EventBusSubscriber.Bus.MOD)
public class ModEventHandler {
    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        boolean includeServer = event.includeServer();
        generator.addProvider(includeServer, (DataProvider)new ModRecipeProvider(output, event.getLookupProvider()));
        generator.addProvider(includeServer, (DataProvider)ModLootTableProvider.create(output, event.getLookupProvider()));
    }

    @SubscribeEvent
    public static void registerPayloadHandler(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar payloadRegistrar = event.registrar("travelersbackpack");
        ModNetwork.register(payloadRegistrar);
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.BACKPACK.get(), (blockEntity, side) -> {
            if (blockEntity.getWrapper() != BackpackWrapper.DUMMY) {
                return blockEntity.getWrapper().getStorageForInputOutput();
            }
            return new ItemStackHandler(0);
        });
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.BACKPACK.get(), (blockEntity, side) -> {
            Direction direction = blockEntity.getBlockDirection();
            if (blockEntity.getWrapper() != BackpackWrapper.DUMMY && blockEntity.getWrapper().getUpgradeManager().getUpgrade(TanksUpgrade.class).isPresent()) {
                TanksUpgrade tanksUpgrade = blockEntity.getWrapper().getUpgradeManager().getUpgrade(TanksUpgrade.class).get();
                if (side == null) {
                    return tanksUpgrade.getLeftTank();
                }
                if (direction == Direction.NORTH) {
                    switch (side) {
                        case WEST: {
                            return tanksUpgrade.getRightTank();
                        }
                        case EAST: {
                            return tanksUpgrade.getLeftTank();
                        }
                    }
                }
                if (direction == Direction.SOUTH) {
                    switch (side) {
                        case EAST: {
                            return tanksUpgrade.getRightTank();
                        }
                        case WEST: {
                            return tanksUpgrade.getLeftTank();
                        }
                    }
                }
                if (direction == Direction.EAST) {
                    switch (side) {
                        case NORTH: {
                            return tanksUpgrade.getRightTank();
                        }
                        case SOUTH: {
                            return tanksUpgrade.getLeftTank();
                        }
                    }
                }
                if (direction == Direction.WEST) {
                    switch (side) {
                        case SOUTH: {
                            return tanksUpgrade.getRightTank();
                        }
                        case NORTH: {
                            return tanksUpgrade.getLeftTank();
                        }
                    }
                }
                return tanksUpgrade.getLeftTank();
            }
            return new FluidTank(0);
        });
    }

    @SubscribeEvent
    public static void onModConfigLoad(ModConfigEvent.Loading configEvent) {
        if (configEvent.getConfig().getSpec() == TravelersBackpackConfig.serverSpec) {
            TravelersBackpackConfig.SERVER.initializeLists();
        }
    }

    @SubscribeEvent
    public static void onModConfigReload(ModConfigEvent.Reloading configEvent) {
        if (configEvent.getConfig().getSpec() == TravelersBackpackConfig.serverSpec) {
            TravelersBackpackConfig.SERVER.initializeLists();
        }
    }
}

