/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ClearCommand {
    public ClearCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder tbCommand = (LiteralArgumentBuilder)Commands.literal((String)"tb").requires(player -> player.hasPermission(2));
        tbCommand.then(((LiteralArgumentBuilder)Commands.literal((String)"remove").executes(source -> ClearCommand.removeBackpack((CommandSourceStack)source.getSource(), ((CommandSourceStack)source.getSource()).getPlayerOrException()))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(source -> ClearCommand.removeBackpack((CommandSourceStack)source.getSource(), EntityArgument.getPlayer((CommandContext)source, (String)"player")))));
        tbCommand.then(((LiteralArgumentBuilder)Commands.literal((String)"clear").executes(source -> ClearCommand.clearBackpack((CommandSourceStack)source.getSource(), ((CommandSourceStack)source.getSource()).getPlayerOrException()))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(source -> ClearCommand.clearBackpack((CommandSourceStack)source.getSource(), EntityArgument.getPlayer((CommandContext)source, (String)"player")))));
        dispatcher.register(tbCommand);
    }

    private static int removeBackpack(CommandSourceStack source, ServerPlayer player) {
        if (AttachmentUtils.isWearingBackpack((Player)player)) {
            if (TravelersBackpack.enableIntegration()) {
                return -1;
            }
            AttachmentUtils.getAttachment((Player)player).ifPresent(data -> {
                if (!player.addItem(data.getBackpack().copy())) {
                    player.drop(data.getBackpack().copy(), true);
                }
                data.equipBackpack(ItemStack.EMPTY);
                data.synchronise();
            });
            source.sendSuccess(() -> Component.literal((String)("Removed Traveler's Backpack from " + player.getDisplayName().getString() + " and added copy to inventory")), true);
            return 1;
        }
        source.sendFailure((Component)Component.literal((String)("Player " + player.getDisplayName().getString() + " is not wearing backpack")));
        return -1;
    }

    private static int clearBackpack(CommandSourceStack source, ServerPlayer player) {
        if (AttachmentUtils.isWearingBackpack((Player)player)) {
            if (TravelersBackpack.enableIntegration()) {
                return -1;
            }
            AttachmentUtils.getAttachment((Player)player).ifPresent(data -> {
                ItemStack stack = data.getBackpack().copy();
                if (!player.addItem(stack.copy())) {
                    player.drop(stack.copy(), true);
                }
                int tier = (Integer)stack.getOrDefault(ModDataComponents.TIER, (Object)0);
                ItemStack clearedStack = stack.getItem().getDefaultInstance();
                clearedStack.set(ModDataComponents.TIER, (Object)tier);
                data.equipBackpack(clearedStack);
                data.synchronise();
            });
            source.sendSuccess(() -> Component.literal((String)("Cleared contents of Traveler's Backpack from " + player.getDisplayName().getString() + " and added copy to inventory")), true);
            return 1;
        }
        source.sendFailure((Component)Component.literal((String)("Player " + player.getDisplayName().getString() + " is not wearing backpack")));
        return -1;
    }
}

