/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.widgets;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class ToolSlotsWidget
extends WidgetBase<BackpackScreen> {
    private final int xPos;

    public ToolSlotsWidget(BackpackScreen screen, Point pos, int xPos) {
        super(screen, pos, 10, 10);
        this.xPos = xPos;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isMouseOver(mouseX, mouseY)) {
            guiGraphics.blit(BackpackScreen.ICONS, this.pos.x() - 1, this.pos.y() - 1, 78, 82, this.width + 2, this.height + 2);
        }
        if (!((BackpackScreen)this.screen).getWrapper().showToolSlots()) {
            guiGraphics.blit(BackpackScreen.ICONS, this.pos.x(), this.pos.y(), 4, 24, this.width, this.height);
        } else {
            guiGraphics.blit(BackpackScreen.ICONS, this.pos.x(), this.pos.y(), 4, 34, this.width, this.height);
            this.renderToolsAddition(guiGraphics, ((BackpackScreen)this.screen).getWrapper().getTools().getSlots(), this.pos.x() - 130 - this.xPos, this.pos.y() + 16 + 10 - 19);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver(mouseX, mouseY)) {
            ServerboundActionTagPacket.create(8, !((BackpackScreen)this.screen).getWrapper().showToolSlots());
            ((BackpackScreen)this.screen).playUIClickSound();
            return true;
        }
        return false;
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            if (((BackpackScreen)this.screen).getWrapper().showToolSlots()) {
                guiGraphics.renderTooltip(((BackpackScreen)this.screen).getFont(), (Component)Component.translatable((String)"screen.travelersbackpack.hide_tool_slots"), mouseX, mouseY);
            } else {
                guiGraphics.renderTooltip(((BackpackScreen)this.screen).getFont(), (Component)Component.translatable((String)"screen.travelersbackpack.show_tool_slots"), mouseX, mouseY);
            }
        }
    }

    public void renderToolsAddition(GuiGraphics guiGraphics, int size, int x, int y) {
        guiGraphics.blit(BackpackScreen.ICONS, x, y, 0, 67, 23, 5);
        for (int i = 0; i < size; ++i) {
            guiGraphics.blit(BackpackScreen.ICONS, x, y + 5 + i * 18, 0, 72, 23, 18);
        }
        guiGraphics.blit(BackpackScreen.ICONS, x, y + 5 + size * 18, 0, 90, 23, 5);
    }

    public int[] getAdditionSizeAndPos() {
        int[] size = new int[]{this.pos.x() - 130 - this.xPos, this.pos.y() + 16 + 10 - 19, 23, 5 + ((BackpackScreen)this.screen).getWrapper().getTools().getSlots() * 18 + 5};
        return size;
    }
}

