/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.buttons;

import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.buttons.Button;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import com.tiviacz.travelersbackpack.util.TextUtils;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class AbilitySliderButton
extends Button {
    private final boolean isBlock;

    public AbilitySliderButton(BackpackScreen screen, boolean isBlock, int xOffset) {
        super(screen, screen.getWidthAdditions() + 145 - xOffset, screen.getMiddleBar(), 12, 12);
        this.isBlock = isBlock;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isBlock) {
            this.drawButton(guiGraphics, mouseX, mouseY, BackpackScreen.ICONS);
        } else if (AttachmentUtils.isWearingBackpack(((BackpackBaseMenu)this.screen.getMenu()).getPlayerInventory().player)) {
            this.drawButton(guiGraphics, mouseX, mouseY, BackpackScreen.ICONS);
        }
    }

    public void drawButton(GuiGraphics guiGraphics, int mouseX, int mouseY, ResourceLocation texture) {
        if (this.screen.getWrapper().isAbilityEnabled()) {
            this.drawButton(guiGraphics, mouseX, mouseY, texture, 44, 56, 78, 82);
        } else {
            this.drawButton(guiGraphics, mouseX, mouseY, texture, 44, 67, 78, 82);
        }
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.inButton(mouseX, mouseY)) {
            if (!BackpackAbilities.isAbilityEnabledInConfig(this.screen.getWrapper().getBackpackStack())) {
                guiGraphics.renderTooltip(this.screen.getFont(), (Component)Component.translatable((String)"screen.travelersbackpack.ability_disabled_config"), mouseX, mouseY);
                return;
            }
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
            if (this.screen.getWrapper().isAbilityEnabled()) {
                components.add(Component.translatable((String)"screen.travelersbackpack.ability_enabled"));
            } else {
                components.add(Component.translatable((String)"screen.travelersbackpack.ability_disabled"));
            }
            if (BackpackAbilities.hasCooldown(this.screen.getWrapper().getBackpackStack())) {
                components.add(Component.translatable((String)"screen.travelersbackpack.ability_cooldown", (Object[])new Object[]{TextUtils.getConvertedTime(this.screen.getWrapper().getCooldown())}));
            } else {
                components.add(Component.translatable((String)"screen.travelersbackpack.ability_ready"));
            }
            guiGraphics.renderTooltip(this.screen.getFont(), components, Optional.empty(), mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get()).booleanValue() || !BackpackAbilities.isAbilityEnabledInConfig(this.screen.getWrapper().getBackpackStack())) {
            return false;
        }
        if (this.isBlock) {
            if (BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, this.screen.getWrapper().getBackpackStack()) && this.inButton((int)mouseX, (int)mouseY)) {
                ServerboundActionTagPacket.create(14, !this.screen.getWrapper().isAbilityEnabled());
                this.screen.playUIClickSound();
                return true;
            }
        } else if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, this.screen.getWrapper().getBackpackStack()) && this.inButton((int)mouseX, (int)mouseY)) {
            ServerboundActionTagPacket.create(14, !this.screen.getWrapper().isAbilityEnabled());
            this.screen.playUIClickSound();
            return true;
        }
        return false;
    }
}

