/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.client.screens.AbstractBackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.UpgradeSlot;
import com.tiviacz.travelersbackpack.client.screens.buttons.AbilitySliderButton;
import com.tiviacz.travelersbackpack.client.screens.buttons.EquipButton;
import com.tiviacz.travelersbackpack.client.screens.buttons.IButton;
import com.tiviacz.travelersbackpack.client.screens.buttons.MoreButton;
import com.tiviacz.travelersbackpack.client.screens.buttons.SleepingBagButton;
import com.tiviacz.travelersbackpack.client.screens.buttons.UnequipButton;
import com.tiviacz.travelersbackpack.client.screens.widgets.FilterUpgradeWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.InventoryScroll;
import com.tiviacz.travelersbackpack.client.screens.widgets.SettingsWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.SortingButtons;
import com.tiviacz.travelersbackpack.client.screens.widgets.ToolSlotsWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.handlers.ModClientEventHandler;
import com.tiviacz.travelersbackpack.inventory.CommonFluid;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.FilterUpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.items.upgrades.TanksUpgradeItem;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import com.tiviacz.travelersbackpack.util.KeyHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;

@OnlyIn(value=Dist.CLIENT)
public class BackpackScreen
extends AbstractBackpackScreen<BackpackBaseMenu>
implements MenuAccess<BackpackBaseMenu> {
    public boolean tanksVisible;
    public Map<Class<?>, WidgetBase<?>> mappedWidgets = new HashMap();
    public List<UpgradeSlot> upgradeSlots = new ArrayList<UpgradeSlot>();
    boolean upgradesInitialized = false;
    public List<IButton> buttons = new ArrayList<IButton>();
    public SortingButtons sortingButtons;
    public ToolSlotsWidget toolSlotsWidget;
    public SettingsWidget settingsWidget;
    public int warningTicks = 0;

    public BackpackScreen(BackpackBaseMenu backpackMenu, Inventory inventory, Component component) {
        super(backpackMenu, inventory, backpackMenu.getWrapper().getBackpackScreenTitle());
        this.recalculate();
        this.updateBackpackSlotsPosition();
        this.updatePlayerSlotsPosition();
        this.titleLabelX = 8 + (this.tanksVisible ? 22 : 0);
    }

    protected void init() {
        super.init();
        this.initButtons();
        this.initWidgets();
    }

    public void resize(Minecraft minecraft, int width, int height) {
        super.resize(minecraft, width, height);
        this.updateScreen(true);
        ((BackpackBaseMenu)this.getMenu()).rebuildSlots();
        this.updateBackpackSlotsPosition();
        this.updatePlayerSlotsPosition();
    }

    protected void containerTick() {
        super.containerTick();
        if (this.warningTicks > 0) {
            --this.warningTicks;
        }
    }

    public void recalculate() {
        boolean wideTexture;
        this.clearWidgets();
        this.upgradeSlots.clear();
        this.visibleSlots = this.slotCount = this.getWrapper().getStorage().getSlots();
        this.slotsHeight = this.calculateSlotHeight(this.slotCount > 81);
        this.tanksVisible = this.getWrapper().tanksVisible();
        this.leftPos = 0;
        this.topPos = 0;
        this.wider = wideTexture = this.slotCount > 81;
        this.visibleRows = (int)Math.ceil((double)this.slotCount / (double)this.getSlotsInRow());
        int playerInventoryHeight = 96;
        this.imageWidth = wideTexture ? (this.tanksVisible ? 256 : 212) : (this.tanksVisible ? 220 : 176);
        this.imageHeight = 17 + this.slotsHeight + playerInventoryHeight + 1;
        this.updateDimensions();
        this.inventoryLabelY = 20 + this.visibleRows * 18;
        this.inventoryLabelX = 8;
        this.titleLabelX = 8 + (this.tanksVisible ? 22 : 0);
        this.titleLabelY = 6;
        if (this.tanksVisible) {
            this.inventoryLabelX += 22;
        }
        if (wideTexture) {
            this.inventoryLabelX += 18;
        }
        if (((BackpackBaseMenu)this.menu).getSlot((int)0).y >= 0) {
            this.slotYPos = ((BackpackBaseMenu)this.menu).getSlot((int)0).y;
        }
    }

    public int getMiddleBar() {
        return 17 + this.calculateSlotHeight(this.visibleRows) + 1;
    }

    public int getWidthAdditions() {
        int addition = 0;
        if (this.tanksVisible) {
            addition += 22;
        }
        if (this.wider) {
            addition += 18;
        }
        return addition;
    }

    public void updateScreen(boolean duplicatedCall) {
        this.isScrollable = false;
        this.recalculate();
        this.init();
        if (!duplicatedCall) {
            this.updateBackpackSlotsPosition();
            this.updatePlayerSlotsPosition();
        }
    }

    @Override
    public void renderScreen(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.renderUpgradeSlots(guiGraphics, x, y);
        this.children().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderBg(guiGraphics, x, y, mouseX, mouseY));
        boolean wideTexture = this.slotCount > 81;
        int inventoryXOffset = this.tanksVisible ? 22 : 0;
        this.renderInventoryBackground(guiGraphics, x + inventoryXOffset, y, wideTexture ? BACKGROUND_11 : BACKGROUND_9, this.imageWidth, this.slotsHeight);
        int slotsXOffset = 7;
        if (this.tanksVisible) {
            slotsXOffset = 29;
            int halfTankHeight = this.slotsHeight / 2;
            int tanksHeight = 90;
            int uOffset = 56;
            int posOffset = 193;
            if (wideTexture) {
                uOffset = 0;
                posOffset = 229;
            }
            guiGraphics.blit(TANKS, x, y, 0, 0, 27, 8 + halfTankHeight);
            guiGraphics.blit(TANKS, x, y + 17 - 9 + halfTankHeight, uOffset, 256 - (tanksHeight + halfTankHeight + 17), 27, tanksHeight + halfTankHeight + 17 - 9);
            guiGraphics.blit(TANKS, x + posOffset, y, uOffset + 28, 0, 27, 8 + halfTankHeight);
            guiGraphics.blit(TANKS, x + posOffset, y + 17 - 9 + halfTankHeight, uOffset + 28, 256 - (tanksHeight + halfTankHeight + 17), 27, tanksHeight + halfTankHeight + 17 - 9);
        }
        this.children().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderAboveBg(guiGraphics, x, y, mouseX, mouseY, partialTicks));
        this.renderSlots(guiGraphics, x + slotsXOffset, y + 17, this.slotCount);
        this.renderLockedBackpackSlot(guiGraphics);
    }

    public void renderUpgradeSlots(GuiGraphics guiGraphics, int x, int y) {
        for (UpgradeSlot slot : this.upgradeSlots) {
            slot.render(guiGraphics, x, y);
        }
    }

    public void initializeUpgradeSlots() {
        for (int i = 0; i < this.getWrapper().getUpgrades().getSlots(); ++i) {
            int x = ((BackpackBaseMenu)this.menu).upgradeSlot.get((int)i).x - 4;
            int y = ((BackpackBaseMenu)this.menu).upgradeSlot.get((int)i).y - 4;
            this.upgradeSlots.add(new UpgradeSlot(this.getWrapper(), new Point(this.getGuiLeft() + x, this.getGuiTop() + y), i, x, y, ((BackpackBaseMenu)this.menu).upgradeSlot.get((int)i).isHidden));
        }
        this.upgradesInitialized = true;
    }

    protected <T extends GuiEventListener & Renderable> T addRenderableWidget(T widget) {
        if (widget instanceof UpgradeWidgetBase) {
            UpgradeWidgetBase upgradeWidgetBase = (UpgradeWidgetBase)widget;
            this.mappedWidgets.put(upgradeWidgetBase.getUpgrade().getClass(), upgradeWidgetBase);
        }
        return (T)super.addRenderableWidget(widget);
    }

    public void initWidgets() {
        this.settingsWidget = new SettingsWidget(this, new Point(this.leftPos + this.imageWidth - 3, this.topPos + 4), false);
        this.addRenderableWidget(this.settingsWidget);
        int xPos = this.leftPos + (this.wider ? 36 : 0) + (this.tanksVisible ? 22 : 0) + 120;
        this.sortingButtons = new SortingButtons(this, new Point(xPos, this.topPos - 10 + 12), 50, 13);
        this.addRenderableWidget(this.sortingButtons);
        int xPosTools = (this.wider ? 36 : 0) + (this.tanksVisible ? 22 : 0);
        this.toolSlotsWidget = new ToolSlotsWidget(this, new Point(this.leftPos + xPosTools + 110, this.topPos - 10 + 15), xPosTools);
        this.addRenderableWidget(this.toolSlotsWidget);
        UpgradeManager manager = this.getWrapper().getUpgradeManager();
        Iterator iterator = manager.mappedUpgrades.keySet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            Optional upgrade = (Optional)manager.mappedUpgrades.get((Object)i);
            upgrade.ifPresent(loadedUpgrade -> {
                int x = ((BackpackBaseMenu)this.menu).upgradeSlot.get((int)i).x - 4;
                int y = ((BackpackBaseMenu)this.menu).upgradeSlot.get((int)i).y - 4;
                this.addRenderableWidget(loadedUpgrade.createWidget(this, x, y));
            });
        }
        this.initializeUpgradeSlots();
        if (this.isScrollable) {
            int scrollXPos = this.leftPos + 7 + (this.tanksVisible ? 22 : 0);
            this.scroll = new InventoryScroll(this, Minecraft.getInstance(), 4, this.visibleRows * 18, this.topPos + 17, scrollXPos + this.getSlotsInRow() * 18);
            if (this.scrollAmount != 0) {
                this.scroll.setScrollDistance(this.scrollAmount);
            }
            this.addRenderableWidget(this.scroll);
        }
    }

    public void initButtons() {
        this.buttons.clear();
        int xOffset = 0;
        if (this.getWrapper().getScreenID() == 1 && !TravelersBackpack.enableIntegration()) {
            this.buttons.add(new EquipButton(this, this.getWrapper().getBackpackSlotIndex() == this.getScreenPlayer().getInventory().selected));
            xOffset += 12;
        }
        if (this.getWrapper().getScreenID() == 2 && this.getWrapper().isOwner(((BackpackBaseMenu)this.getMenu()).player)) {
            this.buttons.add(new MoreButton(this));
            if (!TravelersBackpack.enableIntegration()) {
                this.buttons.add(new UnequipButton(this));
                xOffset += 12;
            }
            if (((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.quickSleepingBag.get()).booleanValue()) {
                this.buttons.add(new SleepingBagButton(this, true, xOffset));
                xOffset += 12;
            }
            if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, this.getWrapper().getBackpackStack())) {
                this.buttons.add(new AbilitySliderButton(this, false, xOffset));
            }
        }
        if (this.getWrapper().getScreenID() == 3) {
            this.buttons.add(new MoreButton(this));
            this.buttons.add(new SleepingBagButton(this, false, 0));
            if (BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, this.getWrapper().getBackpackStack())) {
                this.buttons.add(new AbilitySliderButton(this, true, 12));
            }
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.buttons.forEach(button -> {
            if (this.getWrapper().showMoreButtons() || button instanceof MoreButton || button instanceof EquipButton) {
                button.render(guiGraphics, mouseX, mouseY, partialTicks);
            }
        });
        this.children().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderUnderTooltip(guiGraphics, mouseX, mouseY, partialTicks));
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.children().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderOnTop(guiGraphics, mouseX, mouseY, partialTicks));
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        this.buttons.forEach(button -> {
            if (this.getWrapper().showMoreButtons() || button instanceof MoreButton || button instanceof EquipButton) {
                button.renderTooltip(guiGraphics, mouseX, mouseY);
            }
        });
        this.children().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderTooltip(guiGraphics, mouseX, mouseY));
        this.renderFluidWarningTooltip(guiGraphics, mouseX, mouseY);
    }

    @Override
    public void drawUnsortableSlots(GuiGraphics guiGraphics) {
        if (!this.getWrapper().getUnsortableSlots().isEmpty()) {
            this.getWrapper().getUnsortableSlots().forEach(i -> guiGraphics.blit(ICONS, this.getGuiLeft() + ((BackpackBaseMenu)this.getMenu()).getSlot((int)i.intValue()).x, this.getGuiTop() + ((BackpackBaseMenu)this.getMenu()).getSlot((int)i.intValue()).y, 25, 55, 16, 16));
        }
    }

    @Override
    public void drawMemorySlots(GuiGraphics guiGraphics) {
        if (!this.getWrapper().getMemorySlots().isEmpty()) {
            this.getWrapper().getMemorySlots().forEach(pair -> {
                if (((BackpackBaseMenu)this.getMenu()).getSlot((Integer)pair.getFirst()).getItem().isEmpty()) {
                    ItemStack itemstack = (ItemStack)((Pair)pair.getSecond()).getFirst();
                    guiGraphics.renderFakeItem(itemstack, this.getGuiLeft() + ((BackpackBaseMenu)this.getMenu()).getSlot((int)((Integer)pair.getFirst()).intValue()).x, this.getGuiTop() + ((BackpackBaseMenu)this.getMenu()).getSlot((int)((Integer)pair.getFirst()).intValue()).y);
                    guiGraphics.fill(RenderType.guiGhostRecipeOverlay(), this.getGuiLeft() + ((BackpackBaseMenu)this.getMenu()).getSlot((int)((Integer)pair.getFirst()).intValue()).x, this.getGuiTop() + ((BackpackBaseMenu)this.getMenu()).getSlot((int)((Integer)pair.getFirst()).intValue()).y, this.getGuiLeft() + ((BackpackBaseMenu)this.getMenu()).getSlot((int)((Integer)pair.getFirst()).intValue()).x + 16, this.getGuiTop() + ((BackpackBaseMenu)this.getMenu()).getSlot((int)((Integer)pair.getFirst()).intValue()).y + 16, 0x30FFFFFF);
                }
            });
        }
    }

    protected boolean hasClickedOutside(double pMouseX, double pMouseY, int pGuiLeft, int pGuiTop, int pMouseButton) {
        if (!((BackpackBaseMenu)this.menu).getCarried().isEmpty()) {
            for (GuiEventListener widget : this.children()) {
                WidgetBase base;
                if (!(widget instanceof WidgetBase) || !(base = (WidgetBase)widget).isMouseOver(pMouseX, pMouseY)) continue;
                return false;
            }
        }
        return pMouseX < (double)pGuiLeft || pMouseY < (double)pGuiTop || pMouseX >= (double)(pGuiLeft + this.imageWidth) || pMouseY >= (double)(pGuiTop + this.imageHeight);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.buttons.forEach(b -> {
            if (this.getWrapper().showMoreButtons() || b instanceof MoreButton || b instanceof EquipButton) {
                b.mouseClicked(mouseX, mouseY, button);
            }
        });
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        FilterUpgradeWidgetBase widget;
        GuiEventListener child;
        if (this.getChildAt(mouseX, mouseY).isPresent() && (child = (GuiEventListener)this.getChildAt(mouseX, mouseY).get()) instanceof FilterUpgradeWidgetBase && ((FilterUpgradeBase)(widget = (FilterUpgradeWidgetBase)child).getUpgrade()).isTagSelector() && widget.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (ModClientEventHandler.SORT_BACKPACK.isActiveAndMatches(InputConstants.getKey((int)pKeyCode, (int)pScanCode))) {
            ServerboundActionTagPacket.create(3, 0, KeyHelper.isShiftPressed());
            this.playUIClickSound();
            return true;
        }
        if (ModClientEventHandler.OPEN_BACKPACK.isActiveAndMatches(InputConstants.getKey((int)pKeyCode, (int)pScanCode))) {
            LocalPlayer playerEntity = this.getMinecraft().player;
            if (!(playerEntity == null || this.hoveredSlot != null && this.hoveredSlot.getItem().getItem() instanceof TravelersBackpackItem)) {
                this.onClose();
            }
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public void addCompatWidget(AbstractWidget widget) {
        this.addRenderableWidget(widget);
    }

    public void removeCompatWidget(AbstractWidget widget) {
        this.removeWidget((GuiEventListener)widget);
    }

    public static void displayTanksUpgradeWarning(Player player) {
        Screen screen;
        if (player.level().isClientSide && (screen = Minecraft.getInstance().screen) instanceof BackpackScreen) {
            BackpackScreen screen2 = (BackpackScreen)screen;
            screen2.warningTicks = 60;
        }
    }

    public void renderFluidWarningTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.warningTicks > 0) {
            if (!(((BackpackBaseMenu)this.menu).getCarried().getItem() instanceof TanksUpgradeItem)) {
                this.warningTicks = 0;
            }
            ArrayList<Object> tooltip = new ArrayList<Object>();
            tooltip.add(Component.translatable((String)"screen.travelersbackpack.cant_apply_upgrade"));
            tooltip.add(Component.translatable((String)"screen.travelersbackpack.too_much_fluid"));
            FluidStack leftFluidStack = TanksUpgradeItem.getLeftFluidStack(((BackpackBaseMenu)this.menu).getCarried());
            FluidStack rightFluidStack = TanksUpgradeItem.getRightFluidStack(((BackpackBaseMenu)this.menu).getCarried());
            if (!leftFluidStack.isEmpty() && leftFluidStack.getAmount() > this.getWrapper().getBackpackTankCapacity()) {
                tooltip.add(this.crateFluidWarning(leftFluidStack, this.getWrapper().getBackpackTankCapacity()));
            }
            if (!rightFluidStack.isEmpty() && rightFluidStack.getAmount() > this.getWrapper().getBackpackTankCapacity()) {
                tooltip.add(this.crateFluidWarning(rightFluidStack, this.getWrapper().getBackpackTankCapacity()));
            }
            guiGraphics.renderTooltip(this.getFont(), tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    public Component crateFluidWarning(FluidStack fluidStack, int backpackCapacity) {
        return Component.literal((String)(CommonFluid.getFluidName(fluidStack).getString() + " " + fluidStack.getAmount() + "/" + backpackCapacity + "mB")).withStyle(ChatFormatting.RED);
    }
}

