/*
 * Decompiled with CFR 0.152.
 */
package net.adeptstack.ui.screens;

import java.util.function.Consumer;
import java.util.function.Function;
import net.adeptstack.ui.controls.BlockButton;
import net.adeptstack.utils.screenUtils.ToolTipUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.IntegerProperty;

public class PlatformBlockScreenBase
extends Screen {
    public static final int NO_VARIANT_SELECTED = -1;
    private static final ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"trainutilities", (String)"textures/gui/selection_screen.png");
    private static final int TEXTURE_WIDTH = 256;
    private static final int TEXTURE_HEIGHT = 256;
    private static final int WINDOW_WIDTH = 218;
    private static final int WINDOW_HEIGHT = 66;
    private static final int WINDOW_TOP_PART_HEIGHT = 21;
    private static final int WINDOW_BUTTON_AREA_Y = 21;
    private static final int WINDOW_BOTTOM_PART_Y = 41;
    private static final int WINDOW_BOTTOM_PART_HEIGHT = 45;
    private static final int MARGIN_LEFT = 8;
    private static final int MARGIN_RIGHT = 8;
    private static final int PREVIEW_ICON_SIZE = 32;
    private static final int DEFAULT_BUTTON_WIDTH = 70;
    private static final int MAX_BUTTONS_PER_ROW = 10;
    private final int maxValues;
    private final int maxRows;
    private final int startValue;
    private final Function<Integer, TextureResult> textureGetter;
    private final Consumer<Integer> onDone;
    private int guiLeft;
    private int guiTop;
    private TextureResult preview;
    private int selectedVariant = -1;
    private int typeID = 0;

    public <T extends IntegerProperty> PlatformBlockScreenBase(int variant, T property, Function<Integer, TextureResult> textureGetter, Consumer<Integer> onDone, String id, int typeId) {
        super((Component)Component.translatable((String)id));
        this.maxValues = property.getPossibleValues().size();
        this.startValue = property.getAllValues().mapToInt(x -> (Integer)x.value()).min().orElse(0);
        this.maxRows = (int)Math.ceil((double)this.maxValues / 10.0);
        this.textureGetter = textureGetter;
        this.onDone = onDone;
        this.selectedVariant = variant;
        this.typeID = typeId;
        if (variant != -1) {
            this.preview = textureGetter.apply(variant);
        }
    }

    protected void onDone() {
        this.onDone.accept(this.selectedVariant);
    }

    public void onClose() {
        super.onClose();
    }

    public int getSelectedVariantId() {
        return this.selectedVariant;
    }

    protected void init() {
        super.init();
        this.guiLeft = this.width / 2 - 109;
        this.guiTop = this.height / 2 - (66 + this.maxRows * 20) / 2;
        int i = 0;
        int count = 0;
        while (count < this.maxValues) {
            for (int k = 0; k < 10 && count < this.maxValues; ++k, ++count) {
                String msg = "";
                int n = count;
                TextureResult result = this.textureGetter.apply(this.startValue + n);
                if (this.typeID == 1) {
                    msg = ToolTipUtils.GetDEPlatformBlockToolTipName(n);
                } else if (this.typeID == 2) {
                    msg = ToolTipUtils.GetNLPlatformBlockToolTipName(n);
                } else if (this.typeID == 3) {
                    msg = ToolTipUtils.GetCHPlatformBlockToolTipName(n);
                }
                this.addRenderableWidget((GuiEventListener)new BlockButton(this.guiLeft + 8 + 1 + k * 20, this.guiTop + 21 + i * 20, b -> {
                    this.selectedVariant = this.startValue + n;
                    this.preview = result;
                }, result.location(), result.textureWidth(), result.textureHeight(), msg));
            }
            ++i;
        }
        this.addRenderableWidget((GuiEventListener)new Button.Builder(CommonComponents.GUI_CANCEL, btn -> this.onClose()).pos(this.guiLeft + 218 - 8 - 70, this.guiTop + 21 + this.maxRows * 20 + 45 - 28).size(70, 20).build());
        this.addRenderableWidget((GuiEventListener)new Button.Builder(CommonComponents.GUI_DONE, btn -> {
            this.onDone();
            this.onClose();
        }).pos(this.guiLeft + 218 - 8 - 140 - 4, this.guiTop + 21 + this.maxRows * 20 + 45 - 28).size(70, 20).build());
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.preview != null) {
            guiGraphics.blit(this.preview.location(), this.guiLeft + 8, this.guiTop + 21 + this.maxRows * 20 + 4, 32, 32, 0.0f, 0.0f, this.preview.textureWidth(), this.preview.textureHeight(), this.preview.textureWidth(), this.preview.textureHeight());
        }
        guiGraphics.drawString(this.font, this.title, this.width / 2 - this.font.width((FormattedText)this.title) / 2, this.guiTop + 6, -12566464, false);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.blit(texture, this.guiLeft, this.guiTop, 218, 21, 0.0f, 0.0f, 218, 21, 256, 256);
        for (int i = 0; i < this.maxRows; ++i) {
            guiGraphics.blit(texture, this.guiLeft, this.guiTop + 21 + i * 20, 218, 20, 0.0f, 21.0f, 218, 20, 256, 256);
        }
        guiGraphics.blit(texture, this.guiLeft, this.guiTop + 21 + this.maxRows * 20, 218, 45, 0.0f, 41.0f, 218, 45, 256, 256);
    }

    public record TextureResult(ResourceLocation location, int textureWidth, int textureHeight) {
    }
}

