/*
 * Decompiled with CFR 0.152.
 */
package net.adeptstack.ui.controls;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class BlockButton
extends Button {
    private final ResourceLocation location;
    private final int textureWidth;
    private final int textureHeight;

    public BlockButton(int x, int y, Consumer<BlockButton> onPress, ResourceLocation textureLocation, int textureWidth, int textureHeight, String tooltipMessage) {
        super(x, y, 20, 20, (Component)Component.empty(), b -> onPress.accept((BlockButton)b), DEFAULT_NARRATION);
        this.location = textureLocation;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.setTooltip(Tooltip.create((Component)Component.translatable((String)tooltipMessage)));
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        guiGraphics.blitSprite(SPRITES.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.blit(this.location, this.getX() + 2, this.getY() + 2, 16, 16, 0.0f, 0.0f, this.textureWidth, this.textureHeight, this.textureWidth, this.textureHeight);
    }
}

