/*
 * Decompiled with CFR 0.152.
 */
package net.adeptstack.network.packets;

import de.mrjulsen.mcdragonlib.net.BaseNetworkPacket;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.adeptstack.blocks.panelBlocks.platformBlocks.PlatformBlockCH;
import net.adeptstack.blocks.panelBlocks.platformBlocks.PlatformBlockDE;
import net.adeptstack.blocks.panelBlocks.platformBlocks.PlatformBlockNL;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PlatformBlockPacket
extends BaseNetworkPacket<PlatformBlockPacket> {
    public BlockPos pos;
    public int signblock;

    public PlatformBlockPacket() {
    }

    public PlatformBlockPacket(FriendlyByteBuf buf) {
        this(buf.readBlockPos(), buf.readInt());
    }

    public PlatformBlockPacket(BlockPos pos, int signblock) {
        this.pos = pos;
        this.signblock = signblock;
    }

    public void encode(PlatformBlockPacket packet, RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(packet.pos);
        buf.writeInt(packet.signblock);
    }

    public PlatformBlockPacket decode(RegistryFriendlyByteBuf buf) {
        return new PlatformBlockPacket(buf.readBlockPos(), buf.readInt());
    }

    public void handle(PlatformBlockPacket packet, Supplier<NetworkManager.PacketContext> supplier) {
        this.apply(packet, supplier);
    }

    public void apply(PlatformBlockPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            BlockState state = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().level().getBlockState(packet.pos);
            if (this.signblock >= 0) {
                if (state.getBlock() instanceof PlatformBlockNL) {
                    state = (BlockState)state.setValue((Property)PlatformBlockNL.SIGN_BLOCKS, (Comparable)Integer.valueOf(packet.signblock));
                } else if (state.getBlock() instanceof PlatformBlockDE) {
                    state = (BlockState)state.setValue((Property)PlatformBlockDE.SIGN_BLOCKS, (Comparable)Integer.valueOf(packet.signblock));
                } else if (state.getBlock() instanceof PlatformBlockCH) {
                    state = (BlockState)state.setValue((Property)PlatformBlockCH.SIGN_BLOCKS, (Comparable)Integer.valueOf(packet.signblock));
                }
            }
            ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().level().setBlockAndUpdate(packet.pos, state);
        });
    }
}

