/*
 * Decompiled with CFR 0.152.
 */
package net.adeptstack.network.packets;

import de.mrjulsen.mcdragonlib.net.BaseNetworkPacket;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.adeptstack.blocks.doors.slidingDoor.TrainSlidingDoorBlock;
import net.adeptstack.utils.PlacementUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class ChangeDoorSoundPacket
extends BaseNetworkPacket<ChangeDoorSoundPacket> {
    public BlockPos pos;
    public int door_sound;

    public ChangeDoorSoundPacket() {
    }

    public ChangeDoorSoundPacket(FriendlyByteBuf buf) {
        this(buf.readBlockPos(), buf.readInt());
    }

    public ChangeDoorSoundPacket(BlockPos pos, int door_sound) {
        this.pos = pos;
        this.door_sound = door_sound;
    }

    public void apply(ChangeDoorSoundPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            BlockState state = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().level().getBlockState(packet.pos);
            BlockState state2 = null;
            BlockState state3 = null;
            BlockState state4 = null;
            BlockPos pos2 = null;
            BlockPos pos3 = null;
            BlockPos pos4 = null;
            if (this.door_sound >= 0 && ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().level() != null && state.getBlock() instanceof TrainSlidingDoorBlock) {
                if ((state = (BlockState)state.setValue((Property)TrainSlidingDoorBlock.DOOR_SOUND, (Comparable)Integer.valueOf(packet.door_sound))).getValue((Property)TrainSlidingDoorBlock.HALF) == DoubleBlockHalf.LOWER && state.getValue((Property)TrainSlidingDoorBlock.HINGE) == DoorHingeSide.LEFT) {
                    pos2 = packet.pos.above();
                    state2 = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().level().getBlockState(pos2);
                    if (((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().level().getBlockState(PlacementUtils.getPlaceDirectionLeft(packet.pos, (Direction)state.getValue((Property)TrainSlidingDoorBlock.FACING))).getBlock() instanceof TrainSlidingDoorBlock) {
                        pos3 = PlacementUtils.getPlaceDirectionLeft(packet.pos, (Direction)state.getValue((Property)TrainSlidingDoorBlock.FACING));
                        pos4 = pos3.above();
                        state3 = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().level().getBlockState(pos3);
                        state4 = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().level().getBlockState(pos4);
                    }
                } else if (state.getValue((Property)TrainSlidingDoorBlock.HALF) == DoubleBlockHalf.LOWER && state.getValue((Property)TrainSlidingDoorBlock.HINGE) == DoorHingeSide.RIGHT) {
                    pos2 = packet.pos.above();
                    state2 = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().level().getBlockState(pos2);
                    if (((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().level().getBlockState(PlacementUtils.getPlaceDirectionRight(packet.pos, (Direction)state.getValue((Property)TrainSlidingDoorBlock.FACING))).getBlock() instanceof TrainSlidingDoorBlock) {
                        pos3 = PlacementUtils.getPlaceDirectionRight(packet.pos, (Direction)state.getValue((Property)TrainSlidingDoorBlock.FACING));
                        pos4 = pos3.above();
                        state3 = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().level().getBlockState(pos3);
                        state4 = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().level().getBlockState(pos4);
                    }
                } else if (state.getValue((Property)TrainSlidingDoorBlock.HALF) == DoubleBlockHalf.UPPER && state.getValue((Property)TrainSlidingDoorBlock.HINGE) == DoorHingeSide.LEFT) {
                    pos2 = packet.pos.below();
                    state2 = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().level().getBlockState(pos2);
                    if (((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().level().getBlockState(PlacementUtils.getPlaceDirectionLeft(packet.pos, (Direction)state.getValue((Property)TrainSlidingDoorBlock.FACING))).getBlock() instanceof TrainSlidingDoorBlock) {
                        pos3 = PlacementUtils.getPlaceDirectionLeft(packet.pos, (Direction)state.getValue((Property)TrainSlidingDoorBlock.FACING));
                        pos4 = pos3.below();
                        state3 = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().level().getBlockState(pos3);
                        state4 = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().level().getBlockState(pos4);
                    }
                } else if (state.getValue((Property)TrainSlidingDoorBlock.HALF) == DoubleBlockHalf.UPPER && state.getValue((Property)TrainSlidingDoorBlock.HINGE) == DoorHingeSide.RIGHT) {
                    pos2 = packet.pos.below();
                    state2 = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().level().getBlockState(pos2);
                    if (((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().level().getBlockState(PlacementUtils.getPlaceDirectionRight(packet.pos, (Direction)state.getValue((Property)TrainSlidingDoorBlock.FACING))).getBlock() instanceof TrainSlidingDoorBlock) {
                        pos3 = PlacementUtils.getPlaceDirectionRight(packet.pos, (Direction)state.getValue((Property)TrainSlidingDoorBlock.FACING));
                        pos4 = pos3.below();
                        state3 = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().level().getBlockState(pos3);
                        state4 = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().level().getBlockState(pos4);
                    }
                }
                if (pos2 == null && state2 == null && pos3 == null & pos4 == null && state3 == null && state4 == null) {
                    return;
                }
                state2 = (BlockState)state2.setValue((Property)TrainSlidingDoorBlock.DOOR_SOUND, (Comparable)Integer.valueOf(packet.door_sound));
                if (pos3 != null && pos4 != null && state3 != null && state4 != null) {
                    state3 = (BlockState)state3.setValue((Property)TrainSlidingDoorBlock.DOOR_SOUND, (Comparable)Integer.valueOf(packet.door_sound));
                    state4 = (BlockState)state4.setValue((Property)TrainSlidingDoorBlock.DOOR_SOUND, (Comparable)Integer.valueOf(packet.door_sound));
                }
            }
            ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().level().setBlockAndUpdate(packet.pos, state);
            if (pos2 != null && state2 != null) {
                ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().level().setBlockAndUpdate(pos2, state2);
            }
            if (pos3 != null && pos4 != null && state3 != null && state4 != null) {
                ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().level().setBlockAndUpdate(pos3, state3);
                ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().level().setBlockAndUpdate(pos4, state4);
            }
        });
    }

    public void encode(ChangeDoorSoundPacket packet, RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(packet.pos);
        buf.writeInt(packet.door_sound);
    }

    public ChangeDoorSoundPacket decode(RegistryFriendlyByteBuf buf) {
        return new ChangeDoorSoundPacket(buf.readBlockPos(), buf.readInt());
    }

    public void handle(ChangeDoorSoundPacket packet, Supplier<NetworkManager.PacketContext> supplier) {
        this.apply(packet, supplier);
    }
}

