/*
 * Decompiled with CFR 0.152.
 */
package net.adeptstack.blocks.panelBlocks;

import net.adeptstack.utils.enums.EBlockPlacePosition;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PanelBlockBase
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<EBlockPlacePosition> Z_ALIGN = EnumProperty.create((String)"z_align", EBlockPlacePosition.class);
    private static final VoxelShape SHAPE_CT_SN = Block.box((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    private static final VoxelShape SHAPE_CT_EW = Block.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_S = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    private static final VoxelShape SHAPE_E = Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_N = Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_W = Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public PanelBlockBase(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(Z_ALIGN, (Comparable)((Object)EBlockPlacePosition.CENTER)));
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{FACING, Z_ALIGN});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.getDefaultPlacementState(context);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (pState.getValue(Z_ALIGN) == EBlockPlacePosition.POSITIVE) {
            return pState.getValue((Property)FACING) == Direction.NORTH ? SHAPE_N : (pState.getValue((Property)FACING) == Direction.WEST ? SHAPE_W : (pState.getValue((Property)FACING) == Direction.SOUTH ? SHAPE_S : SHAPE_E));
        }
        if (pState.getValue(Z_ALIGN) == EBlockPlacePosition.NEGATIVE) {
            return pState.getValue((Property)FACING) == Direction.NORTH ? SHAPE_S : (pState.getValue((Property)FACING) == Direction.WEST ? SHAPE_E : (pState.getValue((Property)FACING) == Direction.SOUTH ? SHAPE_N : SHAPE_W));
        }
        return pState.getValue((Property)FACING) == Direction.NORTH || pState.getValue((Property)FACING) == Direction.SOUTH ? SHAPE_CT_SN : SHAPE_CT_EW;
    }

    public BlockState getDefaultPlacementState(BlockPlaceContext context) {
        BlockState stateForPlacement = super.getStateForPlacement(context);
        Direction direction = context.getClickedFace();
        Direction looking = context.getHorizontalDirection();
        Direction.Axis axis = looking.getAxis();
        Direction.AxisDirection axisDirection = looking.getAxisDirection();
        double xzPos = 0.5;
        if (axis == Direction.Axis.X) {
            xzPos = context.getClickLocation().x - (double)context.getClickedPos().getX();
        } else if (axis == Direction.Axis.Z) {
            xzPos = context.getClickLocation().z - (double)context.getClickedPos().getZ();
        }
        EBlockPlacePosition zAlign = EBlockPlacePosition.CENTER;
        if (direction == context.getPlayer().getDirection().getOpposite() || (axisDirection == Direction.AxisDirection.POSITIVE ? xzPos > 0.66666666 : xzPos < 0.33333333)) {
            zAlign = EBlockPlacePosition.POSITIVE;
        } else if (direction == context.getPlayer().getDirection() || (axisDirection == Direction.AxisDirection.POSITIVE ? xzPos < 0.33333333 : xzPos > 0.66666666)) {
            zAlign = EBlockPlacePosition.NEGATIVE;
        }
        return (BlockState)((BlockState)stateForPlacement.setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue(Z_ALIGN, (Comparable)((Object)zAlign));
    }
}

