/*
 * Decompiled with CFR 0.152.
 */
package net.adeptstack.blocks.panelBlocks;

import net.adeptstack.blocks.panelBlocks.PanelBlockBase;
import net.adeptstack.utils.PlacementUtils;
import net.adeptstack.utils.enums.EMultiBlockPart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class IsoWallBlock
extends PanelBlockBase {
    public static final EnumProperty<EMultiBlockPart> PART = EnumProperty.create((String)"part", EMultiBlockPart.class);

    public IsoWallBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(PART, (Comparable)((Object)EMultiBlockPart.BOTTOM_LEFT)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{PART});
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos posBL = context.getClickedPos();
        BlockPos posML = posBL.above();
        BlockPos posTL = posML.above();
        BlockPos posBR = PlacementUtils.getPlaceDirectionLeft(posBL, context.getHorizontalDirection());
        BlockPos posMR = posBR.above();
        BlockPos posTR = posMR.above();
        Level level = context.getLevel();
        if (level.getBlockState(posML).canBeReplaced() && level.getBlockState(posMR).canBeReplaced() && level.getBlockState(posBR).canBeReplaced() && level.getBlockState(posTR).canBeReplaced() && level.getBlockState(posTL).canBeReplaced() && posTL.getY() < level.getMaxBuildHeight() - 1) {
            return super.getStateForPlacement(context);
        }
        return null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockPos posBL = pos;
        BlockPos posBR = PlacementUtils.getPlaceDirectionRight(pos, (Direction)state.getValue((Property)FACING));
        BlockPos posML = pos.above();
        BlockPos posMR = posBR.above();
        BlockPos posTL = posML.above();
        BlockPos posTR = posMR.above();
        level.setBlockAndUpdate(posBR, (BlockState)state.setValue(PART, (Comparable)((Object)EMultiBlockPart.BOTTOM_RIGHT)));
        level.setBlockAndUpdate(posML, (BlockState)state.setValue(PART, (Comparable)((Object)EMultiBlockPart.MIDDLE_LEFT)));
        level.setBlockAndUpdate(posMR, (BlockState)state.setValue(PART, (Comparable)((Object)EMultiBlockPart.MIDDLE_RIGHT)));
        level.setBlockAndUpdate(posTL, (BlockState)state.setValue(PART, (Comparable)((Object)EMultiBlockPart.TOP_LEFT)));
        level.setBlockAndUpdate(posTR, (BlockState)state.setValue(PART, (Comparable)((Object)EMultiBlockPart.TOP_RIGHT)));
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (state.getValue(PART) == EMultiBlockPart.TOP_LEFT) {
            BlockPos posTR = PlacementUtils.getPlaceDirectionRight(pos, (Direction)state.getValue((Property)FACING));
            BlockPos posMR = posTR.below();
            BlockPos posML = pos.below();
            BlockPos posBL = posML.below();
            BlockPos posBR = posMR.below();
            if (level.getBlockState(posBL).is((Block)this) && level.getBlockState(posBR).is((Block)this) && level.getBlockState(posTR).is((Block)this)) {
                level.removeBlock(posTR, false);
                level.removeBlock(posML, false);
                level.removeBlock(posMR, false);
                level.removeBlock(posBL, false);
                level.removeBlock(posBR, false);
            }
        } else if (state.getValue(PART) == EMultiBlockPart.MIDDLE_LEFT) {
            BlockPos posMR = PlacementUtils.getPlaceDirectionRight(pos, (Direction)state.getValue((Property)FACING));
            BlockPos posTL = pos.above();
            BlockPos posTR = posMR.above();
            BlockPos posBL = pos.below();
            BlockPos posBR = posMR.below();
            if (level.getBlockState(posBL).is((Block)this) && level.getBlockState(posBR).is((Block)this) && level.getBlockState(posTR).is((Block)this) && level.getBlockState(posTL).is((Block)this)) {
                level.removeBlock(posTR, false);
                level.removeBlock(posTL, false);
                level.removeBlock(posMR, false);
                level.removeBlock(posBL, false);
                level.removeBlock(posBR, false);
            }
        } else if (state.getValue(PART) == EMultiBlockPart.BOTTOM_LEFT) {
            BlockPos posBR = PlacementUtils.getPlaceDirectionRight(pos, (Direction)state.getValue((Property)FACING));
            BlockPos posMR = posBR.above();
            BlockPos posML = pos.above();
            BlockPos posTL = posML.above();
            BlockPos posTR = posMR.above();
            if (level.getBlockState(posBR).is((Block)this) && level.getBlockState(posTR).is((Block)this) && level.getBlockState(posTL).is((Block)this)) {
                level.removeBlock(posTR, false);
                level.removeBlock(posML, false);
                level.removeBlock(posMR, false);
                level.removeBlock(posTL, false);
                level.removeBlock(posBR, false);
            }
        } else if (state.getValue(PART) == EMultiBlockPart.TOP_RIGHT) {
            BlockPos posTL = PlacementUtils.getPlaceDirectionLeft(pos, (Direction)state.getValue((Property)FACING));
            BlockPos posMR = posTL.below();
            BlockPos posML = pos.below();
            BlockPos posBL = posML.below();
            BlockPos posBR = posMR.below();
            if (level.getBlockState(posBL).is((Block)this) && level.getBlockState(posBR).is((Block)this) && level.getBlockState(posTL).is((Block)this)) {
                level.removeBlock(posTL, false);
                level.removeBlock(posML, false);
                level.removeBlock(posMR, false);
                level.removeBlock(posBL, false);
                level.removeBlock(posBR, false);
            }
        } else if (state.getValue(PART) == EMultiBlockPart.MIDDLE_RIGHT) {
            BlockPos posML = PlacementUtils.getPlaceDirectionLeft(pos, (Direction)state.getValue((Property)FACING));
            BlockPos posTL = pos.above();
            BlockPos posTR = posML.above();
            BlockPos posBL = pos.below();
            BlockPos posBR = posML.below();
            if (level.getBlockState(posBL).is((Block)this) && level.getBlockState(posBR).is((Block)this) && level.getBlockState(posTR).is((Block)this) && level.getBlockState(posTL).is((Block)this)) {
                level.removeBlock(posTR, false);
                level.removeBlock(posTL, false);
                level.removeBlock(posML, false);
                level.removeBlock(posBL, false);
                level.removeBlock(posBR, false);
            }
        } else if (state.getValue(PART) == EMultiBlockPart.BOTTOM_RIGHT) {
            BlockPos posBL = PlacementUtils.getPlaceDirectionLeft(pos, (Direction)state.getValue((Property)FACING));
            BlockPos posMR = posBL.above();
            BlockPos posML = pos.above();
            BlockPos posTL = posML.above();
            BlockPos posTR = posMR.above();
            if (level.getBlockState(posBL).is((Block)this) && level.getBlockState(posTR).is((Block)this) && level.getBlockState(posTL).is((Block)this)) {
                level.removeBlock(posTR, false);
                level.removeBlock(posML, false);
                level.removeBlock(posMR, false);
                level.removeBlock(posTL, false);
                level.removeBlock(posBL, false);
            }
        }
    }
}

