/*
 * Decompiled with CFR 0.152.
 */
package net.adeptstack.blocks.doors.slidingDoor;

import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.decoration.slidingDoor.SlidingDoorBlock;
import net.adeptstack.blocks.doors.slidingDoor.TrainSlidingDoorBlockEntity;
import net.adeptstack.client.ClientWrapper;
import net.adeptstack.registry.ModBlockEntities;
import net.adeptstack.utils.PlacementUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.BlockHitResult;

public class TrainSlidingDoorBlock
extends SlidingDoorBlock {
    public static final IntegerProperty DOOR_SOUND = IntegerProperty.create((String)"door_sound", (int)0, (int)22);

    public TrainSlidingDoorBlock(BlockBehaviour.Properties properties, BlockSetType type, boolean isFolding, int defaultSound) {
        super(properties, type, isFolding);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DOOR_SOUND, (Comparable)Integer.valueOf(defaultSound)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{DOOR_SOUND});
    }

    public static boolean isDoubleDoor(DoorHingeSide hinge, BlockPos pos, Direction facing, MovementContext context) {
        if (hinge == DoorHingeSide.LEFT) {
            BlockPos posH2 = PlacementUtils.getPlaceDirectionLeft(pos, facing);
            StructureTemplate.StructureBlockInfo structureBlockInfo = (StructureTemplate.StructureBlockInfo)context.contraption.getBlocks().get(posH2);
            if (structureBlockInfo == null) {
                return false;
            }
            if (structureBlockInfo.state().getBlock() instanceof TrainSlidingDoorBlock) {
                return structureBlockInfo.state().getValue((Property)HINGE) == DoorHingeSide.RIGHT;
            }
        } else {
            BlockPos posH2 = PlacementUtils.getPlaceDirectionRight(pos, facing);
            StructureTemplate.StructureBlockInfo structureBlockInfo = (StructureTemplate.StructureBlockInfo)context.contraption.getBlocks().get(posH2);
            if (structureBlockInfo == null) {
                return false;
            }
            if (structureBlockInfo.state().getBlock() instanceof TrainSlidingDoorBlock) {
                return structureBlockInfo.state().getValue((Property)HINGE) == DoorHingeSide.LEFT;
            }
        }
        return false;
    }

    public InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHit) {
        if (!pPlayer.isShiftKeyDown()) {
            return super.useWithoutItem(pState, pLevel, pPos, pPlayer, pHit);
        }
        if (pLevel.isClientSide) {
            ClientWrapper.openChangeDoorSoundScreen(pPos, pState);
        }
        return InteractionResult.SUCCESS;
    }

    public BlockEntityType<? extends TrainSlidingDoorBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModBlockEntities.SLIDING_DOOR.get();
    }
}

