/*
 * Decompiled with CFR 0.152.
 */
package net.adeptstack.behaviour.doorBlock;

import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.SimpleBlockMovingInteraction;
import net.adeptstack.blocks.doors.slidingDoor.TrainSlidingDoorBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class DoorBlockMovingInteraction
extends SimpleBlockMovingInteraction {
    protected BlockState handle(Player player, Contraption contraption, BlockPos pos, BlockState currentState) {
        if (!(currentState.getBlock() instanceof DoorBlock)) {
            return currentState;
        }
        boolean trainDoor = currentState.getBlock() instanceof TrainSlidingDoorBlock;
        SoundEvent sound = ((Boolean)currentState.getValue((Property)DoorBlock.OPEN)).booleanValue() ? (trainDoor ? null : SoundEvents.WOODEN_DOOR_CLOSE) : (trainDoor ? SoundEvents.IRON_DOOR_OPEN : SoundEvents.WOODEN_DOOR_OPEN);
        BlockPos otherPos = currentState.getValue((Property)DoorBlock.HALF) == DoubleBlockHalf.LOWER ? pos.above() : pos.below();
        StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(otherPos);
        if (info.state().hasProperty((Property)DoorBlock.OPEN)) {
            BlockState newState = (BlockState)info.state().cycle((Property)DoorBlock.OPEN);
            this.setContraptionBlockData(contraption.entity, otherPos, new StructureTemplate.StructureBlockInfo(info.pos(), newState, info.nbt()));
        }
        currentState = (BlockState)currentState.cycle((Property)DoorBlock.OPEN);
        if (player != null) {
            if (trainDoor) {
                DoorHingeSide hinge = (DoorHingeSide)currentState.getValue((Property)TrainSlidingDoorBlock.HINGE);
                Direction facing = (Direction)currentState.getValue((Property)TrainSlidingDoorBlock.FACING);
                BlockPos doublePos = pos.relative(hinge == DoorHingeSide.LEFT ? facing.getClockWise() : facing.getCounterClockWise());
                StructureTemplate.StructureBlockInfo doubleInfo = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(doublePos);
                if (doubleInfo != null && TrainSlidingDoorBlock.isDoubleDoor((BlockState)currentState, (DoorHingeSide)hinge, (Direction)facing, (BlockState)doubleInfo.state())) {
                    this.handlePlayerInteraction(null, InteractionHand.MAIN_HAND, doublePos, contraption.entity);
                }
            } else {
                float pitch = player.level().random.nextFloat() * 0.1f + 0.9f;
                if (sound != null) {
                    this.playSound(player, sound, pitch);
                }
            }
        }
        return currentState;
    }

    protected boolean updateColliders() {
        return true;
    }
}

