/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.network.packets.cts;

import de.mrjulsen.mcdragonlib.net.BaseNetworkPacket;
import de.mrjulsen.trafficcraft.item.CreativePatternCatalogueItem;
import de.mrjulsen.trafficcraft.item.PatternCatalogueItem;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;

public class PatternCatalogueIndexPacket
extends BaseNetworkPacket<PatternCatalogueIndexPacket> {
    private int index;

    public PatternCatalogueIndexPacket() {
    }

    public PatternCatalogueIndexPacket(int index) {
        this.index = index;
    }

    public void encode(PatternCatalogueIndexPacket packet, RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(packet.index);
    }

    public PatternCatalogueIndexPacket decode(RegistryFriendlyByteBuf buffer) {
        int index = buffer.readInt();
        return new PatternCatalogueIndexPacket(index);
    }

    public void handle(PatternCatalogueIndexPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            ServerPlayer sender = (ServerPlayer)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer();
            Item patt0$temp = sender.getMainHandItem().getItem();
            if (patt0$temp instanceof PatternCatalogueItem) {
                PatternCatalogueItem item = (PatternCatalogueItem)patt0$temp;
                item.setSelectedIndex(sender.getMainHandItem(), packet.index);
                Item patt1$temp = sender.getMainHandItem().getItem();
                if (patt1$temp instanceof CreativePatternCatalogueItem) {
                    creativeItem = (CreativePatternCatalogueItem)patt1$temp;
                    creativeItem.clearCustomImage(sender.getMainHandItem());
                }
            } else {
                Item patt1$temp = sender.getOffhandItem().getItem();
                if (patt1$temp instanceof PatternCatalogueItem) {
                    PatternCatalogueItem item = (PatternCatalogueItem)patt1$temp;
                    item.setSelectedIndex(sender.getOffhandItem(), packet.index);
                    Item patt2$temp = sender.getOffhandItem().getItem();
                    if (patt2$temp instanceof CreativePatternCatalogueItem) {
                        creativeItem = (CreativePatternCatalogueItem)patt2$temp;
                        creativeItem.clearCustomImage(sender.getOffhandItem());
                    }
                }
            }
            sender.getInventory().setChanged();
        });
    }
}

