/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.network.packets.cts;

import de.mrjulsen.mcdragonlib.net.BaseNetworkPacket;
import de.mrjulsen.trafficcraft.components.BrushComponent;
import de.mrjulsen.trafficcraft.item.BrushItem;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;

public class PaintBrushPacket
extends BaseNetworkPacket<PaintBrushPacket> {
    private int pattern;

    public PaintBrushPacket() {
    }

    public PaintBrushPacket(int pattern) {
        this.pattern = pattern;
    }

    public void encode(PaintBrushPacket packet, RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(packet.pattern);
    }

    public PaintBrushPacket decode(RegistryFriendlyByteBuf buffer) {
        int pattern = buffer.readInt();
        return new PaintBrushPacket(pattern);
    }

    public void handle(PaintBrushPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            ServerPlayer sender = (ServerPlayer)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer();
            Item patt0$temp = sender.getMainHandItem().getItem();
            if (patt0$temp instanceof BrushItem) {
                BrushItem brush = (BrushItem)patt0$temp;
                stack = sender.getMainHandItem();
                BrushComponent comp = (BrushComponent)brush.getComponent(stack);
                brush.setComponent(stack, new BrushComponent(packet.pattern, comp.paintAmount(), comp.colorId()));
            } else {
                Item patt1$temp = sender.getOffhandItem().getItem();
                if (patt1$temp instanceof BrushItem) {
                    BrushItem brush = (BrushItem)patt1$temp;
                    stack = sender.getOffhandItem();
                    BrushComponent comp = (BrushComponent)brush.getComponent(stack);
                    brush.setComponent(stack, new BrushComponent(packet.pattern, comp.paintAmount(), comp.colorId()));
                }
            }
            sender.getInventory().setChanged();
        });
    }
}

