/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.network.packets.cts;

import de.mrjulsen.mcdragonlib.net.BaseNetworkPacket;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.trafficcraft.client.screen.menu.TrafficSignWorkbenchMenu;
import de.mrjulsen.trafficcraft.item.ColorPaletteItem;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class ColorPaletteItemPacket
extends BaseNetworkPacket<ColorPaletteItemPacket> {
    private int color;
    private byte index;

    public ColorPaletteItemPacket() {
    }

    public ColorPaletteItemPacket(int color, int index) {
        this.color = color;
        this.index = (byte)index;
    }

    public void encode(ColorPaletteItemPacket packet, RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(packet.color);
        buffer.writeByte((int)packet.index);
    }

    public ColorPaletteItemPacket decode(RegistryFriendlyByteBuf buffer) {
        int color = buffer.readInt();
        byte index = buffer.readByte();
        return new ColorPaletteItemPacket(color, index);
    }

    public void handle(ColorPaletteItemPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            ServerPlayer sender = (ServerPlayer)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer();
            AbstractContainerMenu patt0$temp = sender.containerMenu;
            if (patt0$temp instanceof TrafficSignWorkbenchMenu) {
                TrafficSignWorkbenchMenu menu = (TrafficSignWorkbenchMenu)patt0$temp;
                ItemStack stack = menu.colorSlot.getItem();
                if (!(stack.getItem() instanceof ColorPaletteItem)) {
                    return;
                }
                ColorPaletteItem.setColor(stack, packet.index, packet.color);
                menu.colorSlot.set(stack);
                menu.colorSlot.setChanged();
                menu.broadcastChanges();
                DLUtils.giveAdvancement((ServerPlayer)sender, (String)"trafficcraft", (String)"store_color_palette", (String)"requirement");
            }
        });
    }
}

