/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.item;

import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import de.mrjulsen.trafficcraft.block.StreetLampBaseBlock;
import de.mrjulsen.trafficcraft.block.entity.StreetLampBlockEntity;
import de.mrjulsen.trafficcraft.client.ClientWrapper;
import de.mrjulsen.trafficcraft.components.StreetLampComponent;
import de.mrjulsen.trafficcraft.item.IUseDataComponent;
import de.mrjulsen.trafficcraft.registry.ModDataComponents;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class StreetLampConfigCardItem
extends Item
implements IUseDataComponent<StreetLampComponent> {
    public static final int DEFAULT_TURN_ON_TIME = 18500;
    public static final int DEFAULT_TURN_OFF_TIME = 5500;
    private static final Component textClear = TextUtils.translate((String)"item.trafficcraft.street_lamp_config_card.use.clear");
    private static final Component textErrorTimeEqual = TextUtils.translate((String)"item.trafficcraft.street_lamp_config_card.use.error_same_time").withStyle(ChatFormatting.RED);
    private static final Component textApply = TextUtils.translate((String)"item.trafficcraft.street_lamp_config_card.use.set").withStyle(ChatFormatting.GREEN);
    private static final Component textRemove = TextUtils.translate((String)"item.trafficcraft.street_lamp_config_card.use.unset").withStyle(ChatFormatting.RED);
    private static final String keyTurnOn = "item.trafficcraft.street_lamp_config_card.tooltip.turn_on_time";
    private static final String keyTurnOff = "item.trafficcraft.street_lamp_config_card.tooltip.turn_off_time";

    public StreetLampConfigCardItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            stack.remove((DataComponentType)ModDataComponents.STREET_LAMP_COMPONENT.get());
            player.displayClientMessage(textClear, true);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        if (level.isClientSide) {
            StreetLampComponent comp = (StreetLampComponent)this.getComponent(stack);
            ClientWrapper.showStreetLampScheduleScreen(comp.turnOnTime(), comp.turnOffTime(), comp.timeFormat());
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return super.use(level, player, hand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (!this.hasComponent(stack)) {
            return;
        }
        StreetLampComponent comp = (StreetLampComponent)this.getComponent(stack);
        tooltipComponents.add((Component)TextUtils.translate((String)keyTurnOn, (Object[])new Object[]{TimeUtils.parseTime((long)comp.turnOnTime(), (TimeUtils.TimeFormat)comp.timeFormat())}));
        tooltipComponents.add((Component)TextUtils.translate((String)keyTurnOff, (Object[])new Object[]{TimeUtils.parseTime((long)comp.turnOffTime(), (TimeUtils.TimeFormat)comp.timeFormat())}));
    }

    public boolean isFoil(ItemStack pStack) {
        return this.hasComponent(pStack) || super.isFoil(pStack);
    }

    public InteractionResult useOn(UseOnContext pContext) {
        BlockEntity blockEntity;
        Level level = pContext.getLevel();
        ItemStack stack = pContext.getItemInHand();
        BlockPos pos = pContext.getClickedPos();
        BlockState state = pContext.getLevel().getBlockState(pos);
        Player player = pContext.getPlayer();
        if (!player.isShiftKeyDown() && state.getBlock() instanceof StreetLampBaseBlock && (blockEntity = level.getBlockEntity(pos)) instanceof StreetLampBlockEntity) {
            StreetLampBlockEntity blockEntity2 = (StreetLampBlockEntity)blockEntity;
            if (!level.isClientSide) {
                if (this.hasComponent(stack)) {
                    StreetLampComponent comp = (StreetLampComponent)this.getComponent(stack);
                    if (comp.turnOnTime() == comp.turnOffTime()) {
                        player.displayClientMessage(textErrorTimeEqual, false);
                        return InteractionResult.FAIL;
                    }
                    blockEntity2.setOnTime((int)TimeUtils.shiftDayTimeToMinecraftTicks((long)comp.turnOnTime()));
                    blockEntity2.setOffTime((int)TimeUtils.shiftDayTimeToMinecraftTicks((long)comp.turnOffTime()));
                    player.displayClientMessage(textApply, true);
                    DLUtils.giveAdvancement((ServerPlayer)((ServerPlayer)player), (String)"trafficcraft", (String)"street_lamp_config", (String)"requirement");
                } else {
                    stack.remove((DataComponentType)ModDataComponents.STREET_LAMP_COMPONENT.get());
                    player.displayClientMessage(textRemove, true);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(pContext);
    }

    @Override
    public DataComponentType<StreetLampComponent> getComponentType() {
        return (DataComponentType)ModDataComponents.STREET_LAMP_COMPONENT.get();
    }

    @Override
    public StreetLampComponent emptyComponent() {
        return StreetLampComponent.empty();
    }
}

