/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.item;

import de.mrjulsen.trafficcraft.Constants;
import de.mrjulsen.trafficcraft.client.ClientWrapper;
import de.mrjulsen.trafficcraft.components.CreativePatternCatalogueComponent;
import de.mrjulsen.trafficcraft.data.NamedTrafficSignTextureReference;
import de.mrjulsen.trafficcraft.item.PatternCatalogueItem;
import de.mrjulsen.trafficcraft.registry.ModDataComponents;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class CreativePatternCatalogueItem
extends PatternCatalogueItem {
    public CreativePatternCatalogueItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    @Override
    public int getMaxPatterns() {
        return Short.MAX_VALUE;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Constants.CREATIVE_MODE_ONLY_TOOLTIP);
    }

    public boolean isFoil(ItemStack pStack) {
        return true;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (level.isClientSide) {
            ClientWrapper.showSignPatternSelectionScreen(stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @Override
    public NamedTrafficSignTextureReference getSelectedImageData(ItemStack stack) {
        return this.shouldUseCustomPattern(stack) ? this.getCustomImage(stack) : super.getSelectedImageData(stack);
    }

    public boolean hasCreativeComponent(ItemStack stack) {
        return stack.has((DataComponentType)ModDataComponents.CREATIVE_PATTERN_CATALOGUE_COMPONENT.get());
    }

    public CreativePatternCatalogueComponent getCreativeComponent(ItemStack stack) {
        if (!this.hasCreativeComponent(stack)) {
            return (CreativePatternCatalogueComponent)stack.set((DataComponentType)ModDataComponents.CREATIVE_PATTERN_CATALOGUE_COMPONENT.get(), (Object)CreativePatternCatalogueComponent.empty());
        }
        return (CreativePatternCatalogueComponent)stack.get((DataComponentType)ModDataComponents.CREATIVE_PATTERN_CATALOGUE_COMPONENT.get());
    }

    public CreativePatternCatalogueComponent setCreativeComponent(ItemStack stack, CreativePatternCatalogueComponent data) {
        return (CreativePatternCatalogueComponent)stack.set((DataComponentType)ModDataComponents.CREATIVE_PATTERN_CATALOGUE_COMPONENT.get(), (Object)data);
    }

    public void setCustomImage(ItemStack stack, NamedTrafficSignTextureReference data) {
        this.setCreativeComponent(stack, new CreativePatternCatalogueComponent(Optional.of(data)));
    }

    public void clearCustomImage(ItemStack stack) {
        stack.remove((DataComponentType)ModDataComponents.CREATIVE_PATTERN_CATALOGUE_COMPONENT.get());
    }

    public NamedTrafficSignTextureReference getCustomImage(ItemStack stack) {
        if (this.hasCustomPattern(stack)) {
            return this.getCreativeComponent(stack).customTexture().get();
        }
        return null;
    }

    public boolean hasCustomPattern(ItemStack stack) {
        return this.hasCreativeComponent(stack);
    }

    public boolean shouldUseCustomPattern(ItemStack stack) {
        return this.hasCustomPattern(stack) && this.getCreativeComponent(stack).customTexture().isPresent() && !this.indexInBounds(stack, this.getSelectedIndex(stack));
    }
}

